/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public class PixelDailyConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue RESET_PLAYTIME_PLAYER;
    public static final ForgeConfigSpec.BooleanValue RESET_PLAYTIME_LOCAL_HOURS;
    public static final ForgeConfigSpec.BooleanValue RESET_PLAYTIME_WEEKLY;
    public static final ForgeConfigSpec.ConfigValue<String> DAY_AFFICHAGE_HEADER;
    public static final ForgeConfigSpec.ConfigValue<String> MYSQL_HOST;
    public static final ForgeConfigSpec.IntValue MYSQL_PORT;
    public static final ForgeConfigSpec.ConfigValue<String> MYSQL_DATABASE;
    public static final ForgeConfigSpec.ConfigValue<String> MYSQL_USERNAME;
    public static final ForgeConfigSpec.ConfigValue<String> MYSQL_PASSWORD;
    public static final ForgeConfigSpec.BooleanValue MYSQL_USE_SSL;
    public static final ForgeConfigSpec.IntValue MYSQL_MAX_POOL_SIZE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> PLAYTIME_DAY_AFFICHAGE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> PLAYTIME_DAY_AFFICHAGE_PREMIUM;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> PLAYTIME_DAY_COMMANDS_FREE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> PLAYTIME_DAY_COMMANDS_PREMIUM;

    public static String getMySQLUrl() {
        String host = (String)MYSQL_HOST.get();
        int port = (Integer)MYSQL_PORT.get();
        String database = (String)MYSQL_DATABASE.get();
        boolean useSSL = (Boolean)MYSQL_USE_SSL.get();
        return String.format("jdbc:mysql://%s:%d/%s?useSSL=%s&allowPublicKeyRetrieval=true&serverTimezone=UTC", host, port, database, useSSL);
    }

    public static String getMySQLUsername() {
        return (String)MYSQL_USERNAME.get();
    }

    public static String getMySQLPassword() {
        return (String)MYSQL_PASSWORD.get();
    }

    public static int getMySQLMaxPoolSize() {
        return (Integer)MYSQL_MAX_POOL_SIZE.get();
    }

    public static Map<Integer, String> getDisplayFree() {
        return PixelDailyConfig.parseDisplay((List)PLAYTIME_DAY_AFFICHAGE.get());
    }

    public static Map<Integer, String> getDisplayPremium() {
        return PixelDailyConfig.parseDisplay((List)PLAYTIME_DAY_AFFICHAGE_PREMIUM.get());
    }

    private static Map<Integer, String> parseDisplay(List<? extends String> list) {
        TreeMap<Integer, String> out = new TreeMap<Integer, String>();
        if (list == null) {
            return out;
        }
        for (String string : list) {
            int idx;
            if (string == null || (idx = string.indexOf(61)) <= 0) continue;
            String left = string.substring(0, idx).trim();
            String right = string.substring(idx + 1).trim();
            try {
                int seconds = Integer.parseInt(left);
                out.put(seconds, right);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return out;
    }

    public static Map<Integer, List<String>> getCommandsFree() {
        return PixelDailyConfig.parseCommands((List)PLAYTIME_DAY_COMMANDS_FREE.get());
    }

    public static Map<Integer, List<String>> getCommandsPremium() {
        return PixelDailyConfig.parseCommands((List)PLAYTIME_DAY_COMMANDS_PREMIUM.get());
    }

    private static Map<Integer, List<String>> parseCommands(List<? extends String> list) {
        TreeMap<Integer, List<String>> out = new TreeMap<Integer, List<String>>();
        if (list == null) {
            return out;
        }
        for (String string : list) {
            String[] parts;
            if (string == null || (parts = string.split("\\|", 3)).length < 3) continue;
            try {
                int seconds = Integer.parseInt(parts[0].trim());
                String entry = parts[1].trim() + "|" + parts[2].trim();
                out.computeIfAbsent(seconds, k -> new ArrayList()).add(entry);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return out;
    }

    public static List<Integer> getSortedDisplayKeysFree() {
        return PixelDailyConfig.getDisplayFree().keySet().stream().sorted().collect(Collectors.toList());
    }

    public static List<Integer> getSortedDisplayKeysPremium() {
        return PixelDailyConfig.getDisplayPremium().keySet().stream().sorted().collect(Collectors.toList());
    }

    static {
        BUILDER.push("PixelDaily Configuration");
        RESET_PLAYTIME_PLAYER = BUILDER.comment("Reset playtime based on player's first connection (24h from first login)").define("resetplaytimeplayer", false);
        RESET_PLAYTIME_LOCAL_HOURS = BUILDER.comment("Reset playtime based on local time (midnight reset)").define("resetplaytimelocalhours", false);
        RESET_PLAYTIME_WEEKLY = BUILDER.comment("Reset playtime every Sunday at 00:00 (LOCAL TIME)").define("resetplaytimeweekly", true);
        DAY_AFFICHAGE_HEADER = BUILDER.comment("Header text for daily playtime display").define("dayaffichageheader", (Object)"R\u00e9compense dans &a%PLAYTIME%");
        BUILDER.push("MySQL Database Configuration");
        MYSQL_HOST = BUILDER.comment("MySQL server host (IP address or domain)").define("mysql.host", (Object)"localhost");
        MYSQL_PORT = BUILDER.comment("MySQL server port").defineInRange("mysql.port", 3306, 1, 65535);
        MYSQL_DATABASE = BUILDER.comment("MySQL database name").define("mysql.database", (Object)"pixelmon");
        MYSQL_USERNAME = BUILDER.comment("MySQL username").define("mysql.username", (Object)"root");
        MYSQL_PASSWORD = BUILDER.comment("MySQL password").define("mysql.password", (Object)"password");
        MYSQL_USE_SSL = BUILDER.comment("Use SSL connection to MySQL").define("mysql.use_ssl", false);
        MYSQL_MAX_POOL_SIZE = BUILDER.comment("Maximum number of connections in the pool").defineInRange("mysql.max_pool_size", 10, 1, 50);
        BUILDER.pop();
        BUILDER.push("Display Configuration");
        List<String> defaultDisplay = Arrays.asList("300=1000$", "900=x32 Pok\u00e9balls", "1800=5000$");
        PLAYTIME_DAY_AFFICHAGE = BUILDER.comment("Display configuration for free players. Format: 'seconds=label'").defineList("playtimedayaffichage", defaultDisplay, o -> o instanceof String && ((String)o).contains("="));
        List<String> defaultDisplayPremium = Arrays.asList("300=2000$", "900=x64 Pok\u00e9balls", "1800=10000$");
        PLAYTIME_DAY_AFFICHAGE_PREMIUM = BUILDER.comment("Display configuration for premium players. Format: 'seconds=label'").defineList("playtimedayaffichagepremium", defaultDisplayPremium, o -> o instanceof String && ((String)o).contains("="));
        BUILDER.pop();
        BUILDER.push("Commands Configuration");
        List<String> defaultCommandsFree = Arrays.asList("200|MESSAGE|&eTemps de Jeu &7\u00bb &cR\u00e9compense de temps de jeu dans 5 minutes !", "300|MESSAGE|&eTemps de Jeu &7\u00bb &cVous avez jou\u00e9 pendant 5 minutes ! &aVous recevez 1000$ !", "300|COMMAND|money give %PLAYER% 1000", "900|MESSAGE|&eTemps de Jeu &7\u00bb &cVous avez jou\u00e9 pendant 15 minutes ! &aVous recevez 32 Pok\u00e9balls !", "900|COMMAND|give %PLAYER% cobblemon:poke_ball 32", "1800|MESSAGE|&eTemps de Jeu &7\u00bb &cVous avez jou\u00e9 pendant 30 minutes ! &aVous recevez 5000$ !", "1800|COMMAND|money give %PLAYER% 5000");
        PLAYTIME_DAY_COMMANDS_FREE = BUILDER.comment("Commands executed for free players. Format: 'seconds|TYPE|payload'").defineList("playtimedaycommandsfree", defaultCommandsFree, o -> o instanceof String && ((String)o).contains("|"));
        List<String> defaultCommandsPremium = Arrays.asList("200|MESSAGE|&eTemps de Jeu &7\u00bb &cR\u00e9compense de temps de jeu dans 5 minutes !", "300|MESSAGE|&eTemps de Jeu &7\u00bb &cVous avez jou\u00e9 pendant 5 minutes ! &aVous recevez 2000$ !", "300|COMMAND|money give %PLAYER% 2000", "900|MESSAGE|&eTemps de Jeu &7\u00bb &cVous avez jou\u00e9 pendant 15 minutes ! &aVous recevez 64 Pok\u00e9balls !", "900|COMMAND|give %PLAYER% cobblemon:poke_ball 64", "1800|MESSAGE|&eTemps de Jeu &7\u00bb &cVous avez jou\u00e9 pendant 30 minutes ! &aVous recevez 10000$ !", "1800|COMMAND|money give %PLAYER% 10000");
        PLAYTIME_DAY_COMMANDS_PREMIUM = BUILDER.comment("Commands executed for premium players. Format: 'seconds|TYPE|payload'").defineList("playtimedaycommandspremium", defaultCommandsPremium, o -> o instanceof String && ((String)o).contains("|"));
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

