/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.data;

import com.zordix.pixelmongo.PixelDaily;
import com.zordix.pixelmongo.config.DatabaseConfig;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerDataManager {
    private final Map<UUID, PlayerDailyData> playerDataCache = new ConcurrentHashMap<UUID, PlayerDailyData>();
    private final Map<UUID, Boolean> hudEnabledCache = new ConcurrentHashMap<UUID, Boolean>();
    private static final long SYNC_INTERVAL_MS = 1000L;

    public PlayerDataManager() {
        this.initDatabase();
    }

    private void initDatabase() {
        try (Connection conn = DatabaseConfig.getConnection();){
            String createTableSQL = "CREATE TABLE IF NOT EXISTS player_daily_data (uuid VARCHAR(36) PRIMARY KEY,daily_playtime_seconds BIGINT DEFAULT 0,last_reset_date DATE,first_connection_time BIGINT,executed_commands TEXT,hud_enabled BOOLEAN DEFAULT TRUE,last_save_timestamp BIGINT DEFAULT 0)";
            try (Statement stmt = conn.createStatement();){
                stmt.execute(createTableSQL);
                PixelDaily.LOGGER.info("Database table initialized successfully");
            }
        }
        catch (SQLException e) {
            PixelDaily.LOGGER.error("Failed to initialize database", (Throwable)e);
            throw new RuntimeException("Database initialization failed", e);
        }
    }

    public PlayerDailyData getPlayerData(UUID playerUUID) {
        return this.playerDataCache.computeIfAbsent(playerUUID, this::loadPlayerData);
    }

    public PlayerDailyData loadFreshPlayerData(UUID playerUUID) {
        PlayerDailyData data = this.loadPlayerData(playerUUID);
        this.playerDataCache.put(playerUUID, data);
        return data;
    }

    /*
     * Exception decompiling
     */
    private PlayerDailyData loadPlayerData(UUID playerUUID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void savePlayerData(UUID playerUUID, PlayerDailyData data) {
        if (data == null) {
            return;
        }
        String upsert = "INSERT INTO player_daily_data (uuid, daily_playtime_seconds, last_reset_date, first_connection_time, executed_commands, hud_enabled, last_save_timestamp) VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE daily_playtime_seconds = VALUES(daily_playtime_seconds), last_reset_date = VALUES(last_reset_date), first_connection_time = VALUES(first_connection_time), executed_commands = VALUES(executed_commands), hud_enabled = VALUES(hud_enabled), last_save_timestamp = VALUES(last_save_timestamp)";
        try (Connection conn = DatabaseConfig.getConnection();
             PreparedStatement stmt = conn.prepareStatement(upsert);){
            data.synchronizeForClient();
            stmt.setString(1, playerUUID.toString());
            stmt.setLong(2, data.getDailyPlaytimeSeconds());
            stmt.setDate(3, Date.valueOf(data.lastResetDate));
            stmt.setLong(4, data.firstConnectionTime);
            stmt.setString(5, String.join((CharSequence)",", (CharSequence[])data.executedCommands.stream().map(String::valueOf).toArray(String[]::new)));
            stmt.setBoolean(6, this.hudEnabledCache.getOrDefault(playerUUID, true));
            stmt.setLong(7, System.currentTimeMillis());
            stmt.executeUpdate();
            PixelDaily.LOGGER.debug("Saved data for " + playerUUID + ": " + data.getDailyPlaytimeSeconds() + "s");
        }
        catch (SQLException e) {
            PixelDaily.LOGGER.error("Failed to save player data for " + playerUUID, (Throwable)e);
        }
    }

    public void removePlayerFromCache(UUID playerUUID) {
        this.playerDataCache.remove(playerUUID);
    }

    public boolean shouldResetPlaytime(PlayerDailyData data) {
        boolean isToday_sunday;
        LocalDate today = LocalDate.now();
        DayOfWeek today_day = today.getDayOfWeek();
        boolean bl = isToday_sunday = today_day == DayOfWeek.SUNDAY;
        if (isToday_sunday) {
            return !data.lastResetDate.equals(today);
        }
        return false;
    }

    public boolean isHudEnabled(UUID playerUUID) {
        return this.hudEnabledCache.getOrDefault(playerUUID, true);
    }

    public void setHudEnabled(UUID playerUUID, boolean enabled) {
        this.hudEnabledCache.put(playerUUID, enabled);
        PlayerDailyData data = this.getPlayerData(playerUUID);
        this.savePlayerData(playerUUID, data);
    }

    public void emergencyShutdownSave() {
        PixelDaily.LOGGER.info("Emergency save initiated...");
        for (Map.Entry<UUID, PlayerDailyData> entry : this.playerDataCache.entrySet()) {
            entry.getValue().finalizeSession();
            this.savePlayerData(entry.getKey(), entry.getValue());
        }
        DatabaseConfig.closeDataSource();
    }

    public static class PlayerDailyData {
        private final UUID playerUUID;
        private long dailyPlaytimeSeconds;
        private LocalDate lastResetDate;
        private long firstConnectionTime;
        private final Set<Integer> executedCommands = new HashSet<Integer>();
        private long sessionStartTime = 0L;
        private long sessionPlaytimeSeconds = 0L;
        private long lastActivityTime = 0L;
        private long lastServerSyncTime = 0L;
        private long lastClientUpdateTime = 0L;

        public PlayerDailyData(UUID playerUUID) {
            this.playerUUID = playerUUID;
            this.lastResetDate = LocalDate.now();
            this.firstConnectionTime = System.currentTimeMillis();
        }

        public void startNewSession() {
            this.sessionStartTime = System.currentTimeMillis();
            this.sessionPlaytimeSeconds = 0L;
            this.lastActivityTime = System.currentTimeMillis();
            this.lastServerSyncTime = System.currentTimeMillis();
            PixelDaily.LOGGER.debug("Session started for " + this.playerUUID);
        }

        public void finalizeSession() {
            this.synchronizeForClient();
            PixelDaily.LOGGER.debug("Session finalized for " + this.playerUUID + " - Total: " + this.dailyPlaytimeSeconds + "s");
        }

        public void synchronizeForClient() {
            if (this.sessionStartTime == 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            long elapsedMs = now - this.sessionStartTime;
            this.sessionPlaytimeSeconds = elapsedMs / 1000L;
            if (now - this.lastServerSyncTime >= 1000L) {
                this.lastServerSyncTime = now;
            }
            this.lastClientUpdateTime = now;
        }

        public long getDailyPlaytimeSeconds() {
            this.synchronizeForClient();
            return this.dailyPlaytimeSeconds + this.sessionPlaytimeSeconds;
        }

        public long getDailyPlaytimeHours() {
            return this.getDailyPlaytimeSeconds() / 3600L;
        }

        public boolean hasExecutedCommand(int seconds) {
            return this.executedCommands.contains(seconds);
        }

        public void markCommandExecuted(int seconds) {
            this.executedCommands.add(seconds);
        }

        public void resetDailyPlaytime() {
            this.dailyPlaytimeSeconds = 0L;
            this.sessionPlaytimeSeconds = 0L;
            this.sessionStartTime = System.currentTimeMillis();
            this.lastResetDate = LocalDate.now();
            this.executedCommands.clear();
            this.lastActivityTime = System.currentTimeMillis();
        }

        static /* synthetic */ long access$002(PlayerDailyData x0, long x1) {
            x0.dailyPlaytimeSeconds = x1;
            return x0.dailyPlaytimeSeconds;
        }

        static /* synthetic */ LocalDate access$102(PlayerDailyData x0, LocalDate x1) {
            x0.lastResetDate = x1;
            return x0.lastResetDate;
        }

        static /* synthetic */ long access$202(PlayerDailyData x0, long x1) {
            x0.firstConnectionTime = x1;
            return x0.firstConnectionTime;
        }

        static /* synthetic */ long access$402(PlayerDailyData x0, long x1) {
            x0.lastServerSyncTime = x1;
            return x0.lastServerSyncTime;
        }

        static /* synthetic */ long access$000(PlayerDailyData x0) {
            return x0.dailyPlaytimeSeconds;
        }
    }
}

