/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.events;

import com.zordix.pixelmongo.PixelDaily;
import com.zordix.pixelmongo.config.PixelDailyConfig;
import com.zordix.pixelmongo.data.PlayerDataManager;
import com.zordix.pixelmongo.network.NetworkHandler;
import com.zordix.pixelmongo.rewards.RewardManager;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerEventHandler {
    private int tickCounter = 0;
    private final Map<UUID, Long> connectionTimeouts = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastDisconnectTime = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastHudUpdate = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastSyncTime = new ConcurrentHashMap<UUID, Long>();

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
            UUID playerUUID = player.func_110124_au();
            try {
                Long lastDisconnect = this.lastDisconnectTime.get(playerUUID);
                boolean isQuickReconnect = lastDisconnect != null && System.currentTimeMillis() - lastDisconnect < 30000L;
                PlayerDataManager.PlayerDailyData data = dataManager.loadFreshPlayerData(playerUUID);
                if (dataManager.shouldResetPlaytime(data)) {
                    PixelDaily.LOGGER.info("Nouveau jour d\u00e9tect\u00e9 pour " + player.func_200200_C_().getString() + " - Reset du playtime");
                    data.resetDailyPlaytime();
                    dataManager.savePlayerData(playerUUID, data);
                }
                data.startNewSession();
                this.connectionTimeouts.put(playerUUID, System.currentTimeMillis() + 10000L);
                this.lastHudUpdate.put(playerUUID, 0L);
                this.lastSyncTime.put(playerUUID, System.currentTimeMillis());
                if (isQuickReconnect) {
                    PixelDaily.LOGGER.info("Reconnexion rapide d\u00e9tect\u00e9e pour " + player.func_200200_C_().getString());
                    this.sendHudUpdateWithDelay(player, 500);
                } else {
                    PixelDaily.LOGGER.info("Nouvelle connexion pour " + player.func_200200_C_().getString());
                    this.sendHudUpdateWithDelay(player, 1500);
                }
                PixelDaily.LOGGER.info("Joueur connect\u00e9: " + player.func_200200_C_().getString() + " - Playtime daily: " + data.getDailyPlaytimeSeconds() + "s - Session d\u00e9marr\u00e9e \u00e0 " + new Date());
                this.lastDisconnectTime.remove(playerUUID);
            }
            catch (Exception e) {
                PixelDaily.LOGGER.error("Erreur lors de la connexion de " + player.func_200200_C_().getString(), (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
            UUID playerUUID = player.func_110124_au();
            try {
                PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(playerUUID);
                data.finalizeSession();
                dataManager.savePlayerData(playerUUID, data);
                this.lastDisconnectTime.put(playerUUID, System.currentTimeMillis());
                this.connectionTimeouts.remove(playerUUID);
                this.lastHudUpdate.remove(playerUUID);
                this.lastSyncTime.remove(playerUUID);
                dataManager.removePlayerFromCache(playerUUID);
                PixelDaily.LOGGER.info("Joueur d\u00e9connect\u00e9: " + player.func_200200_C_().getString() + " - Session finale: " + data.getDailyPlaytimeSeconds() + "s - Donn\u00e9es sauvegard\u00e9es");
            }
            catch (Exception e) {
                PixelDaily.LOGGER.error("Erreur lors de la sauvegarde de d\u00e9connexion pour " + player.func_200200_C_().getString(), (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
            PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(player.func_110124_au());
            data.synchronizeForClient();
            dataManager.savePlayerData(player.func_110124_au(), data);
            this.sendHudUpdateWithDelay(player, 1000);
            PixelDaily.LOGGER.debug("Changement de dimension pour " + player.func_200200_C_().getString() + " - Donn\u00e9es synchronis\u00e9es");
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 100 == 0 && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                this.updatePlayerPlaytime(player);
            }
        }
        if (this.tickCounter % 20 == 0 && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                this.sendHudUpdate(player);
            }
        }
        if (this.tickCounter % 200 == 0 && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                UUID uuid = player.func_110124_au();
                PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
                PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(uuid);
                data.synchronizeForClient();
                dataManager.savePlayerData(uuid, data);
                this.lastSyncTime.put(uuid, System.currentTimeMillis());
                PixelDaily.LOGGER.debug("Sauvegarde p\u00e9riodique pour " + player.func_200200_C_().getString() + " - Temps: " + data.getDailyPlaytimeSeconds() + "s");
            }
        }
        if (this.tickCounter % 200 == 0) {
            long now = System.currentTimeMillis();
            this.connectionTimeouts.entrySet().removeIf(entry -> {
                if (now > (Long)entry.getValue()) {
                    PixelDaily.LOGGER.warn("Timeout de connexion pour " + entry.getKey());
                    return true;
                }
                return false;
            });
            this.lastDisconnectTime.entrySet().removeIf(entry -> now - (Long)entry.getValue() > 300000L);
        }
        if (this.tickCounter >= 12000) {
            this.tickCounter = 0;
        }
    }

    private void updatePlayerPlaytime(ServerPlayerEntity player) {
        PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
        PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(player.func_110124_au());
        RewardManager.checkAndExecuteRewards(player, data);
    }

    private void sendHudUpdate(ServerPlayerEntity player) {
        try {
            PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
            UUID playerUUID = player.func_110124_au();
            boolean hudEnabled = dataManager.isHudEnabled(playerUUID);
            PixelDaily.LOGGER.debug("[sendHudUpdate] Joueur: " + player.func_200200_C_().getString() + " | HUD_ENABLED: " + hudEnabled);
            if (!hudEnabled) {
                PixelDaily.LOGGER.info("[HUD BLOCKED] HUD d\u00e9sactiv\u00e9 pour " + player.func_200200_C_().getString() + " - Aucun packet envoy\u00e9");
                return;
            }
            PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(playerUUID);
            String nextRewardText = RewardManager.getNextRewardText(player, data);
            String header = (String)PixelDailyConfig.DAY_AFFICHAGE_HEADER.get();
            if (nextRewardText != null && !nextRewardText.isEmpty()) {
                PixelDaily.LOGGER.debug("[HUD SENT] Envoi mise \u00e0 jour HUD pour " + player.func_200200_C_().getString());
                NetworkHandler.sendToPlayer(new NetworkHandler.PlaytimeUpdatePacket(data.getDailyPlaytimeSeconds(), RewardManager.getNextRewardTime(player, data), header, nextRewardText), player);
            }
        }
        catch (Exception e) {
            PixelDaily.LOGGER.error("Failed to send HUD update to player", (Throwable)e);
        }
    }

    private void sendHudUpdateWithDelay(final ServerPlayerEntity player, int delayMs) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PlayerEventHandler.this.sendHudUpdate(player);
                timer.cancel();
            }
        }, delayMs);
    }
}

