/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.network;

import com.zordix.pixelmongo.PixelDaily;
import com.zordix.pixelmongo.client.PlaytimeClient;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("pixeldaily", "main"), () -> "1", version -> true, version -> true);

    public static void register() {
        int id = 0;
        INSTANCE.registerMessage(id++, PlaytimeUpdatePacket.class, PlaytimeUpdatePacket::encode, PlaytimeUpdatePacket::decode, PlaytimeUpdatePacket::handle);
    }

    public static void sendToPlayer(PlaytimeUpdatePacket packet, ServerPlayerEntity player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static class PlaytimeUpdatePacket {
        private final long currentPlaytimeSeconds;
        private final long nextRewardSeconds;
        private final String header;
        private final String display;

        public PlaytimeUpdatePacket(long currentPlaytimeSeconds, long nextRewardSeconds, String header, String display) {
            this.currentPlaytimeSeconds = currentPlaytimeSeconds;
            this.nextRewardSeconds = nextRewardSeconds;
            this.header = header;
            this.display = display;
        }

        public static void encode(PlaytimeUpdatePacket packet, PacketBuffer buffer) {
            buffer.writeLong(packet.currentPlaytimeSeconds);
            buffer.writeLong(packet.nextRewardSeconds);
            buffer.func_180714_a(packet.header);
            buffer.func_180714_a(packet.display);
        }

        public static PlaytimeUpdatePacket decode(PacketBuffer buffer) {
            return new PlaytimeUpdatePacket(buffer.readLong(), buffer.readLong(), buffer.func_218666_n(), buffer.func_218666_n());
        }

        public static void handle(PlaytimeUpdatePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                PixelDaily.LOGGER.info("[NETWORK] \u2705 PACKET RE\u00c7U! header: '" + packet.header + "' | display: '" + packet.display + "'");
                if ((packet.header == null || packet.header.isEmpty()) && (packet.display == null || packet.display.isEmpty())) {
                    PixelDaily.LOGGER.info("[NETWORK] \ud83d\udd34 Packet VIDE d\u00e9tect\u00e9 - D\u00e9sactivation du HUD");
                    PlaytimeClient.disableHud();
                } else {
                    PixelDaily.LOGGER.info("[NETWORK] \ud83d\udfe2 Mise \u00e0 jour HUD normale re\u00e7ue");
                    PlaytimeClient.updateFromServer(packet.currentPlaytimeSeconds, packet.nextRewardSeconds, packet.header, packet.display);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

