/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.placeholders;

import com.zordix.pixelmongo.PixelDaily;
import com.zordix.pixelmongo.data.PlayerDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;

public class PlaceholderProvider {
    private static final Map<String, Function<ServerPlayerEntity, String>> PLACEHOLDERS = new HashMap<String, Function<ServerPlayerEntity, String>>();

    public static void register() {
        PLACEHOLDERS.put("playtimeday_hours", player -> {
            PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
            PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(player.func_110124_au());
            return String.valueOf(data.getDailyPlaytimeHours());
        });
        PLACEHOLDERS.put("playtimeday_minutes", player -> {
            PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
            PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(player.func_110124_au());
            return String.valueOf(data.getDailyPlaytimeSeconds() / 60L);
        });
        PLACEHOLDERS.put("playtimeday_seconds", player -> {
            PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
            PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(player.func_110124_au());
            return String.valueOf(data.getDailyPlaytimeSeconds());
        });
        PLACEHOLDERS.put("playtimeday_formatted", player -> {
            PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
            PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(player.func_110124_au());
            return PlaceholderProvider.formatPlaytime(data.getDailyPlaytimeSeconds());
        });
    }

    public static String getPlaceholder(String placeholder, ServerPlayerEntity player) {
        Function<ServerPlayerEntity, String> provider = PLACEHOLDERS.get(placeholder);
        return provider != null ? provider.apply(player) : null;
    }

    private static String formatPlaytime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, secs);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, secs);
        }
        return String.format("%ds", secs);
    }

    public static String processPlaceholder(String placeholder, ServerPlayerEntity player) {
        if (placeholder.startsWith("playtimeday_")) {
            return PlaceholderProvider.getPlaceholder(placeholder, player);
        }
        return null;
    }
}

