/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.rewards;

import com.zordix.pixelmongo.config.PixelDailyConfig;
import com.zordix.pixelmongo.data.PlayerDataManager;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class RewardManager {
    private static final String PREMIUM_PERMISSION = "playtimedaily.premium";

    public static void checkAndExecuteRewards(ServerPlayerEntity player, PlayerDataManager.PlayerDailyData data) {
        long playtimeSeconds = data.getDailyPlaytimeSeconds();
        boolean isPremium = RewardManager.hasPermission(player, PREMIUM_PERMISSION);
        Map<Integer, List<String>> commandsByTime = isPremium ? PixelDailyConfig.getCommandsPremium() : PixelDailyConfig.getCommandsFree();
        for (Map.Entry<Integer, List<String>> entry : commandsByTime.entrySet()) {
            int requiredSeconds = entry.getKey();
            if (playtimeSeconds < (long)requiredSeconds || data.hasExecutedCommand(requiredSeconds)) continue;
            RewardManager.executeCommands(player, entry.getValue());
            data.markCommandExecuted(requiredSeconds);
        }
    }

    private static void executeCommands(ServerPlayerEntity player, List<String> entries) {
        MinecraftServer server = player.func_184102_h();
        if (server == null || entries == null) {
            return;
        }
        for (String raw : entries) {
            int sep;
            if (raw == null || (sep = raw.indexOf(124)) <= 0) continue;
            String type = raw.substring(0, sep).trim();
            String payload = raw.substring(sep + 1).trim().replace("%PLAYER%", player.func_200200_C_().getString());
            if (type.equalsIgnoreCase("MESSAGE")) {
                player.func_145747_a((ITextComponent)new StringTextComponent(RewardManager.formatMessage(payload)), player.func_110124_au());
                continue;
            }
            if (!type.equalsIgnoreCase("COMMAND")) continue;
            server.func_195571_aL().func_197059_a(server.func_195573_aM(), payload);
        }
    }

    private static String formatMessage(String message) {
        if (message == null) {
            return "";
        }
        return message.replace("&0", TextFormatting.BLACK.toString()).replace("&1", TextFormatting.DARK_BLUE.toString()).replace("&2", TextFormatting.DARK_GREEN.toString()).replace("&3", TextFormatting.DARK_AQUA.toString()).replace("&4", TextFormatting.DARK_RED.toString()).replace("&5", TextFormatting.DARK_PURPLE.toString()).replace("&6", TextFormatting.GOLD.toString()).replace("&7", TextFormatting.GRAY.toString()).replace("&8", TextFormatting.DARK_GRAY.toString()).replace("&9", TextFormatting.BLUE.toString()).replace("&a", TextFormatting.GREEN.toString()).replace("&b", TextFormatting.AQUA.toString()).replace("&c", TextFormatting.RED.toString()).replace("&d", TextFormatting.LIGHT_PURPLE.toString()).replace("&e", TextFormatting.YELLOW.toString()).replace("&f", TextFormatting.WHITE.toString()).replace("&l", TextFormatting.BOLD.toString()).replace("&m", TextFormatting.STRIKETHROUGH.toString()).replace("&n", TextFormatting.UNDERLINE.toString()).replace("&o", TextFormatting.ITALIC.toString()).replace("&r", TextFormatting.RESET.toString());
    }

    public static String getNextRewardText(ServerPlayerEntity player, PlayerDataManager.PlayerDailyData data) {
        boolean isPremium = RewardManager.hasPermission(player, PREMIUM_PERMISSION);
        Map<Integer, String> display = isPremium ? PixelDailyConfig.getDisplayPremium() : PixelDailyConfig.getDisplayFree();
        long secs = data.getDailyPlaytimeSeconds();
        for (Map.Entry<Integer, String> e : new TreeMap<Integer, String>(display).entrySet()) {
            if (secs >= (long)e.getKey().intValue()) continue;
            return e.getValue();
        }
        return "Toutes les r\u00e9compenses obtenues !";
    }

    public static long getNextRewardTime(ServerPlayerEntity player, PlayerDataManager.PlayerDailyData data) {
        boolean isPremium = RewardManager.hasPermission(player, PREMIUM_PERMISSION);
        Map<Integer, String> display = isPremium ? PixelDailyConfig.getDisplayPremium() : PixelDailyConfig.getDisplayFree();
        long secs = data.getDailyPlaytimeSeconds();
        for (Integer threshold : new TreeMap<Integer, String>(display).keySet()) {
            if (secs >= (long)threshold.intValue()) continue;
            return threshold.intValue();
        }
        return secs;
    }

    private static boolean hasPermission(ServerPlayerEntity player, String permission) {
        return false;
    }
}

