/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicBrowserBase;
import fi.dy.masa.litematica.gui.Icons;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.malilib.gui.interfaces.IFileBrowserIconProvider;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WidgetSchematicBrowser
extends WidgetFileBrowserBase {
    protected static final FileFilter SCHEMATIC_FILTER = new FileFilterSchematics();
    protected final Map<File, SchematicMetadata> cachedMetadata = new HashMap<File, SchematicMetadata>();
    protected final Map<File, Pair<ResourceLocation, DynamicTexture>> cachedPreviewImages = new HashMap<File, Pair<ResourceLocation, DynamicTexture>>();
    protected final GuiSchematicBrowserBase parent;
    protected final int infoWidth;
    protected final int infoHeight;

    public WidgetSchematicBrowser(int x, int y, int width, int height, GuiSchematicBrowserBase parent, @Nullable ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> selectionListener) {
        super(x, y, width, height, DataManager.getDirectoryCache(), parent.getBrowserContext(), parent.getDefaultDirectory(), selectionListener, (IFileBrowserIconProvider)Icons.FILE_ICON_LITEMATIC);
        this.field_230704_d_ = StringUtils.translate((String)"litematica.gui.title.schematic_browser", (Object[])new Object[0]);
        this.infoWidth = 170;
        this.infoHeight = 290;
        this.parent = parent;
    }

    protected int getBrowserWidthForTotalWidth(int width) {
        return super.getBrowserWidthForTotalWidth(width) - this.infoWidth;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.clearPreviewImages();
    }

    protected File getRootDirectory() {
        return DataManager.getSchematicsBaseDirectory();
    }

    protected FileFilter getFileFilter() {
        return SCHEMATIC_FILTER;
    }

    protected void drawAdditionalContents(int mouseX, int mouseY, MatrixStack matrixStack) {
        this.drawSelectedSchematicInfo((WidgetFileBrowserBase.DirectoryEntry)this.getLastSelectedEntry(), matrixStack);
    }

    protected void drawSelectedSchematicInfo(@Nullable WidgetFileBrowserBase.DirectoryEntry entry, MatrixStack matrixStack) {
        int x = this.posX + this.totalWidth - this.infoWidth;
        int y = this.posY;
        int height = Math.min(this.infoHeight, this.parent.getMaxInfoHeight());
        RenderUtils.drawOutlinedBox((int)x, (int)y, (int)this.infoWidth, (int)height, (int)-1610612736, (int)-6710887);
        if (entry == null) {
            return;
        }
        SchematicMetadata meta = this.getSchematicMetadata(entry);
        if (meta != null) {
            String tmp;
            Vector3i areaSize;
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColor = -1061109568;
            int valueColor = -1;
            String str = StringUtils.translate((String)"litematica.gui.label.schematic_info.name", (Object[])new Object[0]);
            this.drawString(matrixStack, str, x += 3, y += 3, textColor);
            this.drawString(matrixStack, meta.getName(), x + 4, y += 12, valueColor);
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.schematic_author", (Object[])new Object[]{meta.getAuthor()});
            this.drawString(matrixStack, str, x, y += 12, textColor);
            String strDate = DATE_FORMAT.format(new Date(meta.getTimeCreated()));
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.time_created", (Object[])new Object[]{strDate});
            this.drawString(matrixStack, str, x, y += 12, textColor);
            y += 12;
            if (meta.hasBeenModified()) {
                strDate = DATE_FORMAT.format(new Date(meta.getTimeModified()));
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.time_modified", (Object[])new Object[]{strDate});
                this.drawString(matrixStack, str, x, y, textColor);
                y += 12;
            }
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.region_count", (Object[])new Object[]{meta.getRegionCount()});
            this.drawString(matrixStack, str, x, y, textColor);
            y += 12;
            if (this.parent.field_230709_l_ >= 340) {
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_volume", (Object[])new Object[]{meta.getTotalVolume()});
                this.drawString(matrixStack, str, x, y, textColor);
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_blocks", (Object[])new Object[]{meta.getTotalBlocks()});
                this.drawString(matrixStack, str, x, y += 12, textColor);
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.enclosing_size", (Object[])new Object[0]);
                this.drawString(matrixStack, str, x, y += 12, textColor);
                areaSize = meta.getEnclosingSize();
                tmp = String.format("%d x %d x %d", areaSize.func_177958_n(), areaSize.func_177956_o(), areaSize.func_177952_p());
                this.drawString(matrixStack, tmp, x + 4, y += 12, valueColor);
                y += 12;
            } else {
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_blocks_and_volume", (Object[])new Object[]{meta.getTotalBlocks(), meta.getTotalVolume()});
                this.drawString(matrixStack, str, x, y, textColor);
                areaSize = meta.getEnclosingSize();
                tmp = String.format("%d x %d x %d", areaSize.func_177958_n(), areaSize.func_177956_o(), areaSize.func_177952_p());
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.enclosing_size_value", (Object[])new Object[]{tmp});
                this.drawString(matrixStack, str, x, y += 12, textColor);
                y += 12;
            }
            Pair<ResourceLocation, DynamicTexture> pair = this.cachedPreviewImages.get(entry.getFullPath());
            if (pair != null) {
                y += 14;
                int iconSize = ((DynamicTexture)pair.getRight()).func_195414_e().func_195702_a();
                boolean needsScaling = height < this.infoHeight;
                RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (needsScaling) {
                    iconSize = height - y + this.posY - 6;
                }
                RenderUtils.drawOutlinedBox((int)(x + 4), (int)y, (int)iconSize, (int)iconSize, (int)-1610612736, (int)-6710887);
                this.bindTexture((ResourceLocation)pair.getLeft());
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + 4), (int)y, (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (int)iconSize, (int)iconSize);
            }
        }
    }

    public void clearSchematicMetadataCache() {
        this.clearPreviewImages();
        this.cachedMetadata.clear();
        this.cachedPreviewImages.clear();
    }

    @Nullable
    protected SchematicMetadata getSchematicMetadata(WidgetFileBrowserBase.DirectoryEntry entry) {
        File file = new File(entry.getDirectory(), entry.getName());
        SchematicMetadata meta = this.cachedMetadata.get(file);
        if (meta == null && !this.cachedMetadata.containsKey(file)) {
            if (entry.getName().endsWith(".litematic") && (meta = LitematicaSchematic.readMetadataFromFile(entry.getDirectory(), entry.getName())) != null) {
                this.createPreviewImage(file, meta);
            }
            this.cachedMetadata.put(file, meta);
        }
        return meta;
    }

    private void clearPreviewImages() {
        for (Pair<ResourceLocation, DynamicTexture> pair : this.cachedPreviewImages.values()) {
            this.mc.func_110434_K().func_147645_c((ResourceLocation)pair.getLeft());
        }
    }

    private void createPreviewImage(File file, SchematicMetadata meta) {
        int size;
        int[] previewImageData = meta.getPreviewImagePixelData();
        if (previewImageData != null && previewImageData.length > 0 && (size = (int)Math.sqrt(previewImageData.length)) * size == previewImageData.length) {
            try {
                NativeImage image = new NativeImage(size, size, false);
                DynamicTexture tex = new DynamicTexture(image);
                ResourceLocation rl = new ResourceLocation("litematica", DigestUtils.sha1Hex((String)file.getAbsolutePath()));
                this.mc.func_110434_K().func_229263_a_(rl, (Texture)tex);
                int i = 0;
                for (int y = 0; y < size; ++y) {
                    for (int x = 0; x < size; ++x) {
                        int val = previewImageData[i++];
                        val = val & 0xFF00FF00 | (val & 0xFF0000) >> 16 | (val & 0xFF) << 16;
                        image.func_195700_a(x, y, val);
                    }
                }
                tex.func_110564_a();
                this.cachedPreviewImages.put(file, (Pair<ResourceLocation, DynamicTexture>)Pair.of((Object)rl, (Object)tex));
            }
            catch (Exception e) {
                Litematica.logger.warn("Failed to create a preview image", (Throwable)e);
            }
        }
    }

    public static class FileFilterSchematics
    implements FileFilter {
        @Override
        public boolean accept(File pathName) {
            String name = pathName.getName();
            return name.endsWith(".litematic") || name.endsWith(".schem") || name.endsWith(".schematic") || name.endsWith(".nbt");
        }
    }
}

