/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.vector.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class MixinWorldRenderer {
    @Shadow
    private ClientWorld field_72769_h;

    @Inject(method={"reload()V"}, at={@At(value="RETURN")})
    private void onLoadRenderers(CallbackInfo ci) {
        if (this.field_72769_h != null && this.field_72769_h == Minecraft.func_71410_x().field_71441_e) {
            LitematicaRenderer.getInstance().loadRenderers();
        }
    }

    @Inject(method={"setupTerrain"}, at={@At(value="TAIL")})
    private void onPostSetupTerrain(ActiveRenderInfo camera, ClippingHelper frustum, boolean hasForcedFrustum, int frame, boolean spectator, CallbackInfo ci) {
        LitematicaRenderer.getInstance().piecewisePrepareAndUpdate(frustum);
    }

    @Inject(method={"renderLayer"}, at={@At(value="TAIL")})
    private void onRenderLayer(RenderType renderLayer, MatrixStack matrixStack, double x, double y, double z, CallbackInfo ci) {
        if (renderLayer == RenderType.func_228639_c_()) {
            LitematicaRenderer.getInstance().piecewiseRenderSolid(matrixStack);
        } else if (renderLayer == RenderType.func_228641_d_()) {
            LitematicaRenderer.getInstance().piecewiseRenderCutoutMipped(matrixStack);
        } else if (renderLayer == RenderType.func_228643_e_()) {
            LitematicaRenderer.getInstance().piecewiseRenderCutout(matrixStack);
        } else if (renderLayer == RenderType.func_228645_f_()) {
            LitematicaRenderer.getInstance().piecewiseRenderTranslucent(matrixStack);
            LitematicaRenderer.getInstance().piecewiseRenderOverlay(matrixStack);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE_STRING", args={"ldc=blockentities"}, target="Lnet/minecraft/profiler/IProfiler;swap(Ljava/lang/String;)V")})
    private void onPostRenderEntities(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        LitematicaRenderer.getInstance().piecewiseRenderEntities(matrices, tickDelta);
    }
}

