/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkCacheSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.util.OverlayType;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkRendererSchematicVbo {
    public static int schematicRenderChunksUpdated;
    protected volatile WorldSchematic world;
    protected final WorldRendererSchematic worldRenderer;
    protected final ReentrantLock chunkRenderLock;
    protected final ReentrantLock chunkRenderDataLock;
    protected final Set<TileEntity> setBlockEntities = new HashSet<TileEntity>();
    protected final BlockPos.Mutable position;
    protected final BlockPos.Mutable chunkRelativePos;
    protected final Map<RenderType, VertexBuffer> vertexBufferBlocks;
    protected final VertexBuffer[] vertexBufferOverlay;
    protected final List<IntBoundingBox> boxes = new ArrayList<IntBoundingBox>();
    protected final EnumSet<OverlayRenderType> existingOverlays = EnumSet.noneOf(OverlayRenderType.class);
    private AxisAlignedBB boundingBox;
    protected Color4f overlayColor;
    protected boolean hasOverlay = false;
    private boolean ignoreClientWorldFluids;
    protected ChunkCacheSchematic schematicWorldView;
    protected ChunkCacheSchematic clientWorldView;
    protected ChunkRenderTaskSchematic compileTask;
    protected ChunkRenderDataSchematic chunkRenderData;
    private boolean needsUpdate;
    private boolean needsImmediateUpdate;

    public ChunkRendererSchematicVbo(WorldSchematic world, WorldRendererSchematic worldRenderer) {
        this.world = world;
        this.worldRenderer = worldRenderer;
        this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
        this.chunkRenderLock = new ReentrantLock();
        this.chunkRenderDataLock = new ReentrantLock();
        this.vertexBufferBlocks = new HashMap<RenderType, VertexBuffer>();
        this.vertexBufferOverlay = new VertexBuffer[OverlayRenderType.values().length];
        this.position = new BlockPos.Mutable();
        this.chunkRelativePos = new BlockPos.Mutable();
        for (RenderType layer : RenderType.func_228661_n_()) {
            this.vertexBufferBlocks.put(layer, new VertexBuffer(layer.func_228663_p_()));
        }
        for (int i = 0; i < OverlayRenderType.values().length; ++i) {
            this.vertexBufferOverlay[i] = new VertexBuffer(DefaultVertexFormats.field_181706_f);
        }
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public EnumSet<OverlayRenderType> getOverlayTypes() {
        return this.existingOverlays;
    }

    public VertexBuffer getBlocksVertexBufferByLayer(RenderType layer) {
        return this.vertexBufferBlocks.get(layer);
    }

    public VertexBuffer getOverlayVertexBuffer(OverlayRenderType type) {
        return this.vertexBufferOverlay[type.ordinal()];
    }

    public ChunkRenderDataSchematic getChunkRenderData() {
        return this.chunkRenderData;
    }

    public void setChunkRenderData(ChunkRenderDataSchematic data) {
        this.chunkRenderDataLock.lock();
        try {
            this.chunkRenderData = data;
        }
        finally {
            this.chunkRenderDataLock.unlock();
        }
    }

    public BlockPos getOrigin() {
        return this.position;
    }

    public AxisAlignedBB getBoundingBox() {
        if (this.boundingBox == null) {
            int x = this.position.func_177958_n();
            int y = this.position.func_177956_o();
            int z = this.position.func_177952_p();
            this.boundingBox = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + 16), (double)(z + 16));
        }
        return this.boundingBox;
    }

    public void setPosition(int x, int y, int z) {
        if (x != this.position.func_177958_n() || y != this.position.func_177956_o() || z != this.position.func_177952_p()) {
            this.clear();
            this.position.func_181079_c(x, y, z);
            this.boundingBox = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + 16), (double)(z + 16));
        }
    }

    protected double getDistanceSq() {
        Entity entity = EntityUtils.getCameraEntity();
        double x = (double)this.position.func_177958_n() + 8.0 - entity.func_226277_ct_();
        double y = (double)this.position.func_177956_o() + 8.0 - entity.func_226278_cu_();
        double z = (double)this.position.func_177952_p() + 8.0 - entity.func_226281_cx_();
        return x * x + y * y + z * z;
    }

    public void deleteGlResources() {
        this.clear();
        this.world = null;
        this.vertexBufferBlocks.values().forEach(buf -> buf.close());
        for (int i = 0; i < this.vertexBufferOverlay.length; ++i) {
            if (this.vertexBufferOverlay[i] == null) continue;
            this.vertexBufferOverlay[i].close();
        }
    }

    public void resortTransparency(ChunkRenderTaskSchematic task) {
        OverlayRenderType type;
        RenderType layerTranslucent = RenderType.func_228645_f_();
        ChunkRenderDataSchematic data = task.getChunkRenderData();
        BufferBuilderCache buffers = task.getBufferCache();
        BufferBuilder.State bufferState = data.getBlockBufferState(layerTranslucent);
        Vector3d cameraPos = task.getCameraPosSupplier().get();
        float x = (float)cameraPos.field_72450_a - (float)this.position.func_177958_n();
        float y = (float)cameraPos.field_72448_b - (float)this.position.func_177956_o();
        float z = (float)cameraPos.field_72449_c - (float)this.position.func_177952_p();
        if (bufferState != null && !data.isBlockLayerEmpty(layerTranslucent)) {
            BufferBuilder buffer = buffers.getBlockBufferByLayer(layerTranslucent);
            this.preRenderBlocks(buffer, layerTranslucent);
            buffer.func_178993_a(bufferState);
            this.postRenderBlocks(layerTranslucent, x, y, z, buffer, data);
        }
        if ((bufferState = data.getOverlayBufferState(type = OverlayRenderType.QUAD)) != null && !data.isOverlayTypeEmpty(type)) {
            BufferBuilder buffer = buffers.getOverlayBuffer(type);
            this.preRenderOverlay(buffer, type.getGlMode());
            buffer.func_178993_a(bufferState);
            this.postRenderOverlay(type, x, y, z, buffer, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildChunk(ChunkRenderTaskSchematic task) {
        ChunkRenderDataSchematic data = new ChunkRenderDataSchematic();
        task.getLock().lock();
        try {
            if (task.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                return;
            }
            task.setChunkRenderData(data);
        }
        finally {
            task.getLock().unlock();
        }
        HashSet<TileEntity> tileEntities = new HashSet<TileEntity>();
        BlockPos.Mutable posChunk = this.position;
        LayerRange range = DataManager.getRenderLayerRange();
        this.existingOverlays.clear();
        this.hasOverlay = false;
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            if (!(this.boxes.isEmpty() || this.schematicWorldView.isEmpty() && this.clientWorldView.isEmpty() || !range.intersects(new SubChunkPos(posChunk.func_177958_n() >> 4, posChunk.func_177956_o() >> 4, posChunk.func_177952_p() >> 4)))) {
                ++schematicRenderChunksUpdated;
                Vector3d cameraPos = task.getCameraPosSupplier().get();
                float x = (float)cameraPos.field_72450_a - (float)this.position.func_177958_n();
                float y = (float)cameraPos.field_72448_b - (float)this.position.func_177956_o();
                float z = (float)cameraPos.field_72449_c - (float)this.position.func_177952_p();
                HashSet<RenderType> usedLayers = new HashSet<RenderType>();
                BufferBuilderCache buffers = task.getBufferCache();
                MatrixStack matrices = new MatrixStack();
                for (IntBoundingBox box : this.boxes) {
                    if ((box = range.getClampedRenderBoundingBox(box)) == null) continue;
                    BlockPos posFrom = new BlockPos(box.minX, box.minY, box.minZ);
                    BlockPos posTo = new BlockPos(box.maxX, box.maxY, box.maxZ);
                    for (BlockPos posMutable : BlockPos.Mutable.func_218278_a((BlockPos)posFrom, (BlockPos)posTo)) {
                        matrices.func_227860_a_();
                        matrices.func_227861_a_((double)(posMutable.func_177958_n() & 0xF), (double)(posMutable.func_177956_o() & 0xF), (double)(posMutable.func_177952_p() & 0xF));
                        this.renderBlocksAndOverlay(posMutable, data, tileEntities, usedLayers, matrices, buffers);
                        matrices.func_227865_b_();
                    }
                }
                for (RenderType layerTmp : RenderType.func_228661_n_()) {
                    if (usedLayers.contains(layerTmp)) {
                        data.setBlockLayerUsed(layerTmp);
                    }
                    if (!data.isBlockLayerStarted(layerTmp)) continue;
                    this.postRenderBlocks(layerTmp, x, y, z, buffers.getBlockBufferByLayer(layerTmp), data);
                }
                if (this.hasOverlay) {
                    for (OverlayRenderType type : this.existingOverlays) {
                        if (!data.isOverlayTypeStarted(type)) continue;
                        data.setOverlayTypeUsed(type);
                        this.postRenderOverlay(type, x, y, z, buffers.getOverlayBuffer(type), data);
                    }
                }
            }
        }
        this.chunkRenderLock.lock();
        try {
            HashSet set = Sets.newHashSet(tileEntities);
            HashSet set1 = Sets.newHashSet(this.setBlockEntities);
            set.removeAll(this.setBlockEntities);
            set1.removeAll(tileEntities);
            this.setBlockEntities.clear();
            this.setBlockEntities.addAll(tileEntities);
            this.worldRenderer.updateBlockEntities(set1, set);
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        data.setTimeBuilt(this.world.func_82737_E());
    }

    protected void renderBlocksAndOverlay(BlockPos pos, ChunkRenderDataSchematic data, Set<TileEntity> tileEntities, Set<RenderType> usedLayers, MatrixStack matrices, BufferBuilderCache buffers) {
        BlockState stateSchematic = this.schematicWorldView.func_180495_p(pos);
        BlockState stateClient = this.clientWorldView.func_180495_p(pos);
        Block blockSchematic = stateSchematic.func_177230_c();
        boolean clientHasAir = stateClient.func_196958_f();
        boolean schematicHasAir = stateSchematic.func_196958_f();
        boolean missing = false;
        if (clientHasAir && schematicHasAir) {
            return;
        }
        this.overlayColor = null;
        if (clientHasAir || stateSchematic != stateClient && Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
            BufferBuilder bufferSchematic;
            RenderType layer;
            if (blockSchematic.func_235695_q_()) {
                this.addTileEntity(pos, data, tileEntities);
            }
            boolean translucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
            FluidState fluidState = stateSchematic.func_204520_s();
            if (!fluidState.func_206888_e()) {
                layer = RenderTypeLookup.func_228391_a_((FluidState)fluidState);
                bufferSchematic = buffers.getBlockBufferByLayer(layer);
                if (!data.isBlockLayerStarted(layer)) {
                    data.setBlockLayerStarted(layer);
                    this.preRenderBlocks(bufferSchematic, layer);
                }
                if (this.worldRenderer.renderFluid(this.schematicWorldView, fluidState, pos, bufferSchematic)) {
                    usedLayers.add(layer);
                }
            }
            if (stateSchematic.func_185901_i() != BlockRenderType.INVISIBLE) {
                layer = translucent ? RenderType.func_228645_f_() : RenderTypeLookup.func_228390_a_((BlockState)stateSchematic);
                bufferSchematic = buffers.getBlockBufferByLayer(layer);
                if (!data.isBlockLayerStarted(layer)) {
                    data.setBlockLayerStarted(layer);
                    this.preRenderBlocks(bufferSchematic, layer);
                }
                if (this.worldRenderer.renderBlock(this.schematicWorldView, stateSchematic, pos, matrices, bufferSchematic)) {
                    usedLayers.add(layer);
                }
                if (clientHasAir) {
                    missing = true;
                }
            }
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue()) {
            OverlayType type = this.getOverlayType(stateSchematic, stateClient);
            this.overlayColor = this.getOverlayColor(type);
            if (this.overlayColor != null) {
                this.renderOverlay(type, pos, stateSchematic, missing, data, buffers);
            }
        }
    }

    protected void renderOverlay(OverlayType type, BlockPos pos, BlockState stateSchematic, boolean missing, ChunkRenderDataSchematic data, BufferBuilderCache buffers) {
        IBakedModel bakedModel;
        BlockPos.Mutable relPos = this.getChunkRelativePosition(pos);
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES.getBooleanValue()) {
            BufferBuilder bufferOverlayQuads = buffers.getOverlayBuffer(OverlayRenderType.QUAD);
            if (!data.isOverlayTypeStarted(OverlayRenderType.QUAD)) {
                data.setOverlayTypeStarted(OverlayRenderType.QUAD);
                this.preRenderOverlay(bufferOverlayQuads, OverlayRenderType.QUAD);
            }
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                BlockPos.Mutable posMutable = new BlockPos.Mutable();
                for (int i = 0; i < 6; ++i) {
                    Direction side = PositionUtils.ALL_DIRECTIONS[i];
                    posMutable.func_181079_c(pos.func_177958_n() + side.func_82601_c(), pos.func_177956_o() + side.func_96559_d(), pos.func_177952_p() + side.func_82599_e());
                    BlockState adjStateSchematic = this.schematicWorldView.func_180495_p((BlockPos)posMutable);
                    BlockState adjStateClient = this.clientWorldView.func_180495_p((BlockPos)posMutable);
                    OverlayType typeAdj = this.getOverlayType(adjStateSchematic, adjStateClient);
                    if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                        IBakedModel bakedModel2 = this.worldRenderer.getModelForState(stateSchematic);
                        if (type.getRenderPriority() <= typeAdj.getRenderPriority() && Block.func_208061_a((VoxelShape)stateSchematic.func_196952_d((IBlockReader)this.schematicWorldView, pos), (Direction)side)) continue;
                        RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel2, stateSchematic, (BlockPos)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                        continue;
                    }
                    if (type.getRenderPriority() <= typeAdj.getRenderPriority()) continue;
                    RenderUtils.drawBlockBoxSideBatchedQuads((BlockPos)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                bakedModel = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel, stateSchematic, (BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxSidesBatchedQuads((BlockPos)relPos, (Color4f)this.overlayColor, (double)0.0, (BufferBuilder)bufferOverlayQuads);
            }
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES.getBooleanValue()) {
            BufferBuilder bufferOverlayOutlines = buffers.getOverlayBuffer(OverlayRenderType.OUTLINE);
            if (!data.isOverlayTypeStarted(OverlayRenderType.OUTLINE)) {
                data.setOverlayTypeStarted(OverlayRenderType.OUTLINE);
                this.preRenderOverlay(bufferOverlayOutlines, OverlayRenderType.OUTLINE);
            }
            this.overlayColor = new Color4f(this.overlayColor.r, this.overlayColor.g, this.overlayColor.b, 1.0f);
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                OverlayType[][][] adjTypes = new OverlayType[3][3][3];
                BlockPos.Mutable posMutable = new BlockPos.Mutable();
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int x = 0; x <= 2; ++x) {
                            if (x != 1 || y != 1 || z != 1) {
                                posMutable.func_181079_c(pos.func_177958_n() + x - 1, pos.func_177956_o() + y - 1, pos.func_177952_p() + z - 1);
                                BlockState adjStateSchematic = this.schematicWorldView.func_180495_p((BlockPos)posMutable);
                                BlockState adjStateClient = this.clientWorldView.func_180495_p((BlockPos)posMutable);
                                adjTypes[x][y][z] = this.getOverlayType(adjStateSchematic, adjStateClient);
                                continue;
                            }
                            adjTypes[x][y][z] = type;
                        }
                    }
                }
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    IBakedModel bakedModel3 = this.worldRenderer.getModelForState(stateSchematic);
                    if (stateSchematic.func_200132_m()) {
                        this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                    } else {
                        RenderUtils.drawBlockModelOutlinesBatched(bakedModel3, stateSchematic, (BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayOutlines);
                    }
                } else {
                    this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                bakedModel = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelOutlinesBatched(bakedModel, stateSchematic, (BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayOutlines);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((BlockPos)relPos, (Color4f)this.overlayColor, (double)0.0, (BufferBuilder)bufferOverlayOutlines);
            }
        }
    }

    protected BlockPos.Mutable getChunkRelativePosition(BlockPos pos) {
        return this.chunkRelativePos.func_181079_c(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
    }

    protected void renderOverlayReducedEdges(BlockPos pos, OverlayType[][][] adjTypes, OverlayType typeSelf, BufferBuilder bufferOverlayOutlines) {
        OverlayType[] neighborTypes = new OverlayType[4];
        Vector3i[] neighborPositions = new Vector3i[4];
        int lines = 0;
        for (Direction.Axis axis : fi.dy.masa.litematica.util.PositionUtils.AXES_ALL) {
            for (int corner = 0; corner < 4; ++corner) {
                Vector3i[] offsets = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, corner);
                int index = -1;
                boolean hasCurrent = false;
                for (int i = 0; i < 4; ++i) {
                    Vector3i offset = offsets[i];
                    OverlayType type = adjTypes[offset.func_177958_n() + 1][offset.func_177956_o() + 1][offset.func_177952_p() + 1];
                    if (type == OverlayType.NONE || index != -1 && type.getRenderPriority() < neighborTypes[index - 1].getRenderPriority()) continue;
                    if (index < 0 || type.getRenderPriority() > neighborTypes[index - 1].getRenderPriority()) {
                        index = 0;
                    }
                    neighborPositions[index] = new Vector3i(pos.func_177958_n() + offset.func_177958_n(), pos.func_177956_o() + offset.func_177956_o(), pos.func_177952_p() + offset.func_177952_p());
                    neighborTypes[index] = type;
                    hasCurrent |= i == 0;
                    ++index;
                }
                if (index <= 0 || !hasCurrent) continue;
                Vector3i posTmp = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                int ind = -1;
                for (int i = 0; i < index; ++i) {
                    Vector3i tmp = neighborPositions[i];
                    if (tmp.func_177958_n() > posTmp.func_177958_n() || tmp.func_177956_o() > posTmp.func_177956_o() || tmp.func_177952_p() > posTmp.func_177952_p()) continue;
                    posTmp = tmp;
                    ind = i;
                }
                if (posTmp.func_177958_n() != pos.func_177958_n() || posTmp.func_177956_o() != pos.func_177956_o() || posTmp.func_177952_p() != pos.func_177952_p()) continue;
                RenderUtils.drawBlockBoxEdgeBatchedLines((BlockPos)this.getChunkRelativePosition(pos), axis, corner, this.overlayColor, bufferOverlayOutlines);
                ++lines;
            }
        }
    }

    protected OverlayType getOverlayType(BlockState stateSchematic, BlockState stateClient) {
        if (stateSchematic == stateClient) {
            return OverlayType.NONE;
        }
        boolean clientHasAir = stateClient.func_196958_f();
        boolean schematicHasAir = stateSchematic.func_196958_f();
        if (schematicHasAir) {
            return clientHasAir || this.ignoreClientWorldFluids && stateClient.func_185904_a().func_76224_d() ? OverlayType.NONE : OverlayType.EXTRA;
        }
        if (clientHasAir || this.ignoreClientWorldFluids && stateClient.func_185904_a().func_76224_d()) {
            return OverlayType.MISSING;
        }
        if (stateSchematic.func_177230_c() != stateClient.func_177230_c()) {
            return OverlayType.WRONG_BLOCK;
        }
        return OverlayType.WRONG_STATE;
    }

    @Nullable
    protected Color4f getOverlayColor(OverlayType overlayType) {
        Color4f overlayColor = null;
        switch (overlayType) {
            case MISSING: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_MISSING.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getColor();
                break;
            }
            case EXTRA: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_EXTRA.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getColor();
                break;
            }
            case WRONG_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getColor();
                break;
            }
            case WRONG_STATE: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_STATE.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getColor();
                break;
            }
        }
        return overlayColor;
    }

    private void addTileEntity(BlockPos pos, ChunkRenderDataSchematic chunkRenderData, Set<TileEntity> blockEntities) {
        TileEntityRenderer tesr;
        TileEntity te = this.schematicWorldView.getTileEntity(pos, Chunk.CreateEntityType.CHECK);
        if (te != null && (tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te)) != null) {
            chunkRenderData.addTileEntity(te);
            if (tesr.func_188185_a(te)) {
                blockEntities.add(te);
            }
        }
    }

    private void preRenderBlocks(BufferBuilder buffer, RenderType layer) {
        buffer.func_181668_a(7, layer.func_228663_p_());
    }

    private void postRenderBlocks(RenderType layer, float x, float y, float z, BufferBuilder buffer, ChunkRenderDataSchematic chunkRenderData) {
        if (layer == RenderType.func_228645_f_() && !chunkRenderData.isBlockLayerEmpty(layer)) {
            buffer.func_181674_a(x, y, z);
            chunkRenderData.setBlockBufferState(layer, buffer.func_181672_a());
        }
        buffer.func_178977_d();
    }

    private void preRenderOverlay(BufferBuilder buffer, OverlayRenderType type) {
        this.existingOverlays.add(type);
        this.hasOverlay = true;
        buffer.func_181668_a(type.getGlMode(), DefaultVertexFormats.field_181706_f);
    }

    private void preRenderOverlay(BufferBuilder buffer, int glMode) {
        buffer.func_181668_a(glMode, DefaultVertexFormats.field_181706_f);
    }

    private void postRenderOverlay(OverlayRenderType type, float x, float y, float z, BufferBuilder buffer, ChunkRenderDataSchematic chunkRenderData) {
        if (type == OverlayRenderType.QUAD && !chunkRenderData.isOverlayTypeEmpty(type)) {
            buffer.func_181674_a(x, y, z);
            chunkRenderData.setOverlayBufferState(type, buffer.func_181672_a());
        }
        buffer.func_178977_d();
    }

    public ChunkRenderTaskSchematic makeCompileTaskChunkSchematic(Supplier<Vector3d> cameraPosSupplier) {
        this.chunkRenderLock.lock();
        ChunkRenderTaskSchematic generator = null;
        try {
            this.finishCompileTask();
            this.rebuildWorldView();
            generator = this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.REBUILD_CHUNK, cameraPosSupplier, this.getDistanceSq());
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return generator;
    }

    @Nullable
    public ChunkRenderTaskSchematic makeCompileTaskTransparencySchematic(Supplier<Vector3d> cameraPosSupplier) {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask == null || this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                    this.compileTask.finish();
                }
                this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY, cameraPosSupplier, this.getDistanceSq());
                this.compileTask.setChunkRenderData(this.chunkRenderData);
                ChunkRenderTaskSchematic chunkRenderTaskSchematic = this.compileTask;
                return chunkRenderTaskSchematic;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return null;
    }

    protected void finishCompileTask() {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
    }

    public ReentrantLock getLockCompileTask() {
        return this.chunkRenderLock;
    }

    public void clear() {
        this.finishCompileTask();
        this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
        this.needsUpdate = true;
    }

    public void setNeedsUpdate(boolean immediate) {
        if (this.needsUpdate) {
            immediate |= this.needsImmediateUpdate;
        }
        this.needsUpdate = true;
        this.needsImmediateUpdate = immediate;
    }

    public void clearNeedsUpdate() {
        this.needsUpdate = false;
        this.needsImmediateUpdate = false;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public boolean needsImmediateUpdate() {
        return this.needsUpdate && this.needsImmediateUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildWorldView() {
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            this.ignoreClientWorldFluids = Configs.Visuals.IGNORE_EXISTING_FLUIDS.getBooleanValue();
            ClientWorld worldClient = Minecraft.func_71410_x().field_71441_e;
            this.schematicWorldView = new ChunkCacheSchematic(this.world, worldClient, (BlockPos)this.position, 2);
            this.clientWorldView = new ChunkCacheSchematic((World)worldClient, worldClient, (BlockPos)this.position, 2);
            BlockPos.Mutable pos = this.position;
            SubChunkPos subChunk = new SubChunkPos(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
            this.boxes.clear();
            this.boxes.addAll(DataManager.getSchematicPlacementManager().getTouchedBoxesInSubChunk(subChunk));
        }
    }

    public static enum OverlayRenderType {
        OUTLINE(1),
        QUAD(7);

        private final int glMode;

        private OverlayRenderType(int glMode) {
            this.glMode = glMode;
        }

        public int getGlMode() {
            return this.glMode;
        }
    }
}

