/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkBase;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class TaskFillArea
extends TaskProcessChunkBase {
    protected final BlockState fillState;
    @Nullable
    protected final BlockState replaceState;
    protected final String blockString;
    protected final boolean removeEntities;
    protected int chunkCount;

    public TaskFillArea(List<Box> boxes, BlockState fillState, @Nullable BlockState replaceState, boolean removeEntities) {
        this(boxes, fillState, replaceState, removeEntities, "litematica.gui.label.task_name.fill");
    }

    protected TaskFillArea(List<Box> boxes, BlockState fillState, @Nullable BlockState replaceState, boolean removeEntities, String nameOnHud) {
        super(nameOnHud);
        this.fillState = fillState;
        this.replaceState = replaceState;
        this.removeEntities = removeEntities;
        String blockString = BlockStateParser.func_197247_a((BlockState)fillState);
        if (replaceState != null) {
            blockString = blockString + " replace " + BlockStateParser.func_197247_a((BlockState)replaceState);
        }
        this.blockString = blockString;
        this.addBoxesPerChunks(boxes);
        this.updateInfoHudLinesMissingChunks(this.requiredChunks);
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.blockString != null;
    }

    @Override
    protected boolean canProcessChunk(ChunkPos pos) {
        return this.mc.field_71439_g != null && this.areSurroundingChunksLoaded(pos, this.worldClient, 1);
    }

    @Override
    protected boolean processChunk(ChunkPos pos) {
        if (this.isClientWorld && this.chunkCount == 0) {
            this.mc.field_71439_g.func_71165_d("/gamerule sendCommandFeedback false");
        }
        for (IntBoundingBox box : this.getBoxesInChunk(pos)) {
            if (this.isClientWorld) {
                this.fillBoxCommands(box, this.removeEntities);
                continue;
            }
            this.fillBoxDirect(box, this.removeEntities);
        }
        ++this.chunkCount;
        return true;
    }

    protected void fillBoxDirect(IntBoundingBox box, boolean removeEntities) {
        if (removeEntities) {
            AxisAlignedBB aabb = new AxisAlignedBB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
            List entities = this.world.func_175674_a((Entity)this.mc.field_71439_g, aabb, EntityUtils.NOT_PLAYER);
            for (Entity entity : entities) {
                if (entity instanceof PlayerEntity) continue;
                entity.func_70106_y();
            }
        }
        WorldUtils.setShouldPreventBlockUpdates(this.world, true);
        BlockState barrier = Blocks.field_180401_cv.func_176223_P();
        BlockPos.Mutable posMutable = new BlockPos.Mutable();
        for (int z = box.minZ; z <= box.maxZ; ++z) {
            for (int x = box.minX; x <= box.maxX; ++x) {
                for (int y = box.maxY; y >= box.minY; --y) {
                    posMutable.func_181079_c(x, y, z);
                    BlockState oldState = this.world.func_180495_p((BlockPos)posMutable);
                    if ((this.replaceState != null || oldState == this.fillState) && oldState != this.replaceState) continue;
                    TileEntity te = this.world.func_175625_s((BlockPos)posMutable);
                    if (te instanceof IInventory) {
                        ((IInventory)te).func_174888_l();
                        this.world.func_180501_a((BlockPos)posMutable, barrier, 18);
                    }
                    this.world.func_180501_a((BlockPos)posMutable, this.fillState, 18);
                }
            }
        }
        WorldUtils.setShouldPreventBlockUpdates(this.world, false);
    }

    protected void fillBoxCommands(IntBoundingBox box, boolean removeEntities) {
        AxisAlignedBB aabb;
        if (removeEntities && this.world.func_175674_a((Entity)this.mc.field_71439_g, aabb = new AxisAlignedBB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1)), EntityUtils.NOT_PLAYER).size() > 0) {
            String killCmd = String.format("/kill @e[type=!player,x=%d,y=%d,z=%d,dx=%d,dy=%d,dz=%d]", box.minX, box.minY, box.minZ, box.maxX - box.minX + 1, box.maxY - box.minY + 1, box.maxZ - box.minZ + 1);
            this.mc.field_71439_g.func_71165_d(killCmd);
        }
        String fillCmd = String.format("/fill %d %d %d %d %d %d %s", box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, this.blockString);
        this.mc.field_71439_g.func_71165_d(fillCmd);
    }

    @Override
    protected void onStop() {
        this.printCompletionMessage();
        if (this.isClientWorld && this.mc.field_71439_g != null) {
            this.mc.field_71439_g.func_71165_d("/gamerule sendCommandFeedback true");
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        this.notifyListener();
    }

    protected void printCompletionMessage() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.area_filled", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.area_fill_fail", (Object[])new Object[0]);
        }
    }
}

