/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PasteNbtBehavior;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SkullItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TaskPasteSchematicPerChunkCommand
extends TaskPasteSchematicPerChunkBase {
    protected final List<IntBoundingBox> boxesInCurrentChunk = new ArrayList<IntBoundingBox>();
    private final int maxCommandsPerTick = Configs.Generic.PASTE_COMMAND_LIMIT.getIntegerValue();
    private int sentCommandsThisTick;
    private int sentCommandsTotal;
    private int currentX;
    private int currentY;
    private int currentZ;
    private int currentIndex;
    private int boxVolume;
    private int sentSetblockCommands;
    private boolean boxInProgress;

    public TaskPasteSchematicPerChunkCommand(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        super(placements, range, changedBlocksOnly);
    }

    @Override
    public boolean execute() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        ClientWorld worldClient = this.mc.field_71441_e;
        this.sentCommandsThisTick = 0;
        int processed = 0;
        int chunkAttempts = 0;
        if (this.sentCommandsTotal == 0) {
            this.mc.field_71439_g.func_71165_d("/gamerule sendCommandFeedback false");
        }
        block0: while (!this.chunks.isEmpty()) {
            ChunkPos pos = (ChunkPos)this.chunks.get(0);
            if (!this.canProcessChunk(pos, worldSchematic, worldClient)) {
                if (this.boxInProgress || chunkAttempts > 0) {
                    return false;
                }
                this.sortChunkList();
                ++chunkAttempts;
                continue;
            }
            while (!this.boxesInCurrentChunk.isEmpty()) {
                IntBoundingBox box = this.boxesInCurrentChunk.get(0);
                if (this.processBox(pos, box, worldSchematic, worldClient, this.mc.field_71439_g)) {
                    this.boxesInCurrentChunk.remove(0);
                    if (!this.boxesInCurrentChunk.isEmpty()) continue;
                    this.boxesInChunks.removeAll((Object)pos);
                    this.chunks.remove(0);
                    ++processed;
                    if (this.chunks.isEmpty()) {
                        this.finished = true;
                        return true;
                    }
                    this.sortChunkList();
                    continue block0;
                }
                if (processed > 0) {
                    this.updateInfoHudLines();
                }
                return false;
            }
        }
        if (processed > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    @Override
    protected void onChunkListSorted() {
        super.onChunkListSorted();
        this.boxesInCurrentChunk.clear();
        this.boxesInCurrentChunk.addAll(this.boxesInChunks.get(this.chunks.get(0)));
    }

    protected boolean processBox(ChunkPos pos, IntBoundingBox box, WorldSchematic worldSchematic, ClientWorld worldClient, ClientPlayerEntity player) {
        BlockPos.Mutable posMutable = new BlockPos.Mutable();
        ChunkSchematic chunkSchematic = worldSchematic.getChunkProvider().getChunk(pos.field_77276_a, pos.field_77275_b);
        Chunk chunkClient = worldClient.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
        PasteNbtBehavior nbtBehavior = (PasteNbtBehavior)Configs.Generic.PASTE_NBT_BEHAVIOR.getOptionListValue();
        if (!this.boxInProgress) {
            this.currentX = box.minX;
            this.currentY = box.minY;
            this.currentZ = box.minZ;
            this.boxVolume = (box.maxX - box.minX + 1) * (box.maxY - box.minY + 1) * (box.maxZ - box.minZ + 1);
            this.currentIndex = 0;
            this.boxInProgress = true;
        }
        while (this.currentIndex < this.boxVolume) {
            posMutable.func_181079_c(this.currentX, this.currentY, this.currentZ);
            if (++this.currentY > box.maxY) {
                this.currentY = box.minY;
                if (++this.currentX > box.maxX) {
                    this.currentX = box.minX;
                    ++this.currentZ;
                }
            }
            ++this.currentIndex;
            BlockState stateSchematic = chunkSchematic.func_180495_p((BlockPos)posMutable);
            BlockState stateClient = chunkClient.func_180495_p((BlockPos)posMutable);
            if (stateSchematic.func_196958_f() && stateClient.func_196958_f() || this.changedBlockOnly && stateClient == stateSchematic || this.replace == ReplaceBehavior.NONE && !stateClient.func_196958_f() || this.replace == ReplaceBehavior.WITH_NON_AIR && stateSchematic.func_196958_f()) continue;
            TileEntity be = worldSchematic.func_175625_s((BlockPos)posMutable);
            if (be != null && nbtBehavior != PasteNbtBehavior.NONE) {
                if (nbtBehavior == PasteNbtBehavior.PLACE_MODIFY) {
                    this.setDataViaDataModify((BlockPos)posMutable, stateSchematic, be, worldSchematic, worldClient, player);
                } else if (nbtBehavior == PasteNbtBehavior.PLACE_CLONE) {
                    this.placeBlockViaClone((BlockPos)posMutable, stateSchematic, be, worldSchematic, worldClient, player);
                } else if (nbtBehavior == PasteNbtBehavior.TELEPORT_PLACE) {
                    this.placeBlockDirectly((BlockPos)posMutable, stateSchematic, be, worldSchematic, worldClient, player);
                }
            } else {
                this.sendSetBlockCommand(posMutable.func_177958_n(), posMutable.func_177956_o(), posMutable.func_177952_p(), stateSchematic, player);
            }
            if (this.sentCommandsThisTick < this.maxCommandsPerTick) continue;
            break;
        }
        if (this.currentIndex >= this.boxVolume) {
            if (!Configs.Generic.PASTE_IGNORE_ENTITIES.getBooleanValue()) {
                this.summonEntities(box, worldSchematic, player);
            }
            this.boxInProgress = false;
            return true;
        }
        return false;
    }

    protected void summonEntities(IntBoundingBox box, WorldSchematic worldSchematic, ClientPlayerEntity player) {
        AxisAlignedBB bb = new AxisAlignedBB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
        List entities = worldSchematic.func_175674_a(null, bb, null);
        for (Entity entity : entities) {
            String id = EntityUtils.getEntityId(entity);
            if (id == null) continue;
            String strCommand = String.format(Locale.ROOT, "summon %s %f %f %f", id, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            this.sendCommand(strCommand, player);
        }
    }

    protected void sendSetBlockCommand(int x, int y, int z, BlockState state, ClientPlayerEntity player) {
        String cmdName = Configs.Generic.PASTE_COMMAND_SETBLOCK.getStringValue();
        String blockString = BlockStateParser.func_197247_a((BlockState)state);
        String strCommand = String.format("%s %d %d %d %s", cmdName, x, y, z, blockString);
        this.sendCommand(strCommand, player);
        ++this.sentSetblockCommands;
    }

    protected void setDataViaDataModify(BlockPos pos, BlockState state, TileEntity be, World schematicWorld, ClientWorld clientWorld, ClientPlayerEntity player) {
        BlockPos placementPos = TaskPasteSchematicPerChunkCommand.findEmptyNearbyPosition((World)clientWorld, player.func_233580_cy_(), 3);
        if (placementPos != null && this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            Vector3d posVec = new Vector3d((double)placementPos.func_177958_n() + 0.5, (double)placementPos.func_177956_o() + 1.0, (double)placementPos.func_177952_p() + 0.5);
            BlockRayTraceResult hitResult = new BlockRayTraceResult(posVec, Direction.UP, placementPos, false);
            this.mc.field_71442_b.func_217292_a(player, clientWorld, Hand.OFF_HAND, hitResult);
            HashSet keys = new HashSet();
            try {
                keys.addAll(be.func_189515_b(new CompoundNBT()).func_150296_c());
            }
            catch (Exception exception) {
                // empty catch block
            }
            keys.remove("id");
            keys.remove("x");
            keys.remove("y");
            keys.remove("z");
            this.sendSetBlockCommand(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state, player);
            for (String key : keys) {
                String command = String.format("data modify block %d %d %d %s set from block %d %d %d %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), key, placementPos.func_177958_n(), placementPos.func_177956_o(), placementPos.func_177952_p(), key);
                this.sendCommand(command, player);
            }
            String cmdName = Configs.Generic.PASTE_COMMAND_SETBLOCK.getStringValue();
            String command = String.format("%s %d %d %d air", cmdName, placementPos.func_177958_n(), placementPos.func_177956_o(), placementPos.func_177952_p());
            this.sendCommand(command, player);
        }
    }

    protected void placeBlockViaClone(BlockPos pos, BlockState state, TileEntity be, World schematicWorld, ClientWorld clientWorld, ClientPlayerEntity player) {
        BlockPos placementPos = TaskPasteSchematicPerChunkCommand.findEmptyNearbyPosition((World)clientWorld, player.func_233580_cy_(), 3);
        if (placementPos != null && this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            Vector3d posVec = new Vector3d((double)placementPos.func_177958_n() + 0.5, (double)placementPos.func_177956_o() + 1.0, (double)placementPos.func_177952_p() + 0.5);
            BlockRayTraceResult hitResult = new BlockRayTraceResult(posVec, Direction.UP, placementPos, false);
            this.mc.field_71442_b.func_217292_a(player, clientWorld, Hand.OFF_HAND, hitResult);
            String command = String.format("data get block %d %d %d", placementPos.func_177958_n(), placementPos.func_177956_o(), placementPos.func_177952_p());
            this.sendCommand(command, player);
            command = String.format("clone %d %d %d %d %d %d %d %d %d", placementPos.func_177958_n(), placementPos.func_177956_o(), placementPos.func_177952_p(), placementPos.func_177958_n(), placementPos.func_177956_o(), placementPos.func_177952_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.sendCommand(command, player);
            command = String.format("setblock %d %d %d air", placementPos.func_177958_n(), placementPos.func_177956_o(), placementPos.func_177952_p());
            this.sendCommand(command, player);
        }
    }

    protected void placeBlockDirectly(BlockPos pos, BlockState state, TileEntity be, World schematicWorld, ClientWorld clientWorld, ClientPlayerEntity player) {
        if (this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            player.func_226288_n_((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p());
            String command = String.format("tp @p %d %d %d", pos.func_177958_n(), pos.func_177956_o() + 2, pos.func_177952_p());
            this.sendCommand(command, player);
            Vector3d posVec = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
            BlockRayTraceResult hitResult = new BlockRayTraceResult(posVec, Direction.UP, pos, false);
            this.mc.field_71442_b.func_217292_a(player, clientWorld, Hand.OFF_HAND, hitResult);
        }
    }

    protected void sendCommand(String command, ClientPlayerEntity player) {
        this.sendCommandToServer(command, player);
        ++this.sentCommandsThisTick;
        ++this.sentCommandsTotal;
    }

    protected void sendCommandToServer(String command, ClientPlayerEntity player) {
        if (command.length() > 0 && command.charAt(0) != '/') {
            player.func_71165_d("/" + command);
        } else {
            player.func_71165_d(command);
        }
    }

    @Nullable
    public static BlockPos findEmptyNearbyPosition(World world, BlockPos centerPos, int radius) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockPos.Mutable sidePos = new BlockPos.Mutable();
        for (int y = centerPos.func_177956_o(); y <= centerPos.func_177956_o() + radius; ++y) {
            for (int z = centerPos.func_177952_p() - radius; z <= centerPos.func_177952_p() + radius; ++z) {
                for (int x = centerPos.func_177958_n() - radius; x <= centerPos.func_177958_n() + radius; ++x) {
                    pos.func_181079_c(x, y, z);
                    if (!TaskPasteSchematicPerChunkCommand.isPositionAndSidesEmpty(world, pos, sidePos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    public static boolean isPositionAndSidesEmpty(World world, BlockPos.Mutable centerPos, BlockPos.Mutable pos) {
        if (!world.func_175623_d((BlockPos)centerPos)) {
            return false;
        }
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            if (world.func_175623_d((BlockPos)pos.func_239622_a_((Vector3i)centerPos, side))) continue;
            return false;
        }
        return true;
    }

    protected boolean preparePickedStack(BlockPos pos, BlockState state, TileEntity be, World world, ClientPlayerEntity player) {
        ItemStack stack = state.func_177230_c().func_185473_a((IBlockReader)world, pos, state);
        if (!stack.func_190926_b()) {
            TaskPasteSchematicPerChunkCommand.addBlockEntityNbt(stack, be);
            player.field_71071_by.field_184439_c.set(0, (Object)stack);
            this.mc.field_71442_b.func_78761_a(stack, 45);
            return true;
        }
        return false;
    }

    public static void addBlockEntityNbt(ItemStack stack, TileEntity be) {
        CompoundNBT tag = be.func_189515_b(new CompoundNBT());
        if (stack.func_77973_b() instanceof SkullItem && tag.func_74764_b("SkullOwner")) {
            CompoundNBT ownerTag = tag.func_74775_l("SkullOwner");
            stack.func_196082_o().func_218657_a("SkullOwner", (INBT)ownerTag);
        } else {
            stack.func_77983_a("BlockEntityTag", (INBT)tag);
        }
    }

    @Override
    public void stop() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted_using_setblock", (Object[])new Object[]{this.sentSetblockCommands});
            }
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        if (this.mc.field_71439_g != null) {
            this.mc.field_71439_g.func_71165_d("/gamerule sendCommandFeedback true");
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }
}

