/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.SchematicPlacingUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class TaskPasteSchematicPerChunkDirect
extends TaskPasteSchematicPerChunkBase {
    private final ArrayListMultimap<ChunkPos, SchematicPlacement> placementsPerChunk = ArrayListMultimap.create();

    public TaskPasteSchematicPerChunkDirect(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        super(placements, range, changedBlocksOnly);
    }

    @Override
    protected void onChunkAddedForHandling(ChunkPos pos, SchematicPlacement placement) {
        super.onChunkAddedForHandling(pos, placement);
        this.placementsPerChunk.put((Object)pos, (Object)placement);
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute() || !this.mc.func_71356_B()) {
            return false;
        }
        World world = WorldUtils.getBestWorld((Minecraft)this.mc);
        return world != null && !world.field_72995_K;
    }

    @Override
    public boolean execute() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        ClientWorld worldClient = this.mc.field_71441_e;
        World world = WorldUtils.getBestWorld((Minecraft)this.mc);
        int processed = 0;
        IntegratedServer server = this.mc.func_71401_C();
        long timeStart = Util.func_211178_c();
        long vanillaTickTime = server.field_71311_j[server.func_71259_af() % 100];
        this.sortChunkList();
        for (int chunkIndex = 0; chunkIndex < this.chunks.size(); ++chunkIndex) {
            ChunkPos pos = (ChunkPos)this.chunks.get(chunkIndex);
            long currentTime = Util.func_211178_c();
            long elapsedTickTime = vanillaTickTime + (currentTime - timeStart);
            if (elapsedTickTime >= 60000000L) break;
            if (!this.canProcessChunk(pos, worldSchematic, worldClient)) continue;
            ArrayList placements = new ArrayList(this.placementsPerChunk.get((Object)pos));
            for (SchematicPlacement placement : placements) {
                if (!SchematicPlacingUtils.placeToWorldWithinChunk(world, pos, placement, this.replace, false)) continue;
                this.placementsPerChunk.remove((Object)pos, (Object)placement);
                ++processed;
            }
            if (this.placementsPerChunk.containsKey((Object)pos)) continue;
            this.chunks.remove(chunkIndex);
            --chunkIndex;
        }
        if (this.chunks.isEmpty()) {
            this.finished = true;
            return true;
        }
        if (processed > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    @Override
    public void stop() {
        if (this.finished) {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted", (Object[])new Object[0]);
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }
}

