/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.litematica.schematic.conversion.SchematicConverter;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.BlockUtils;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.FileType;
import fi.dy.masa.litematica.util.NbtUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.SchematicPlacingUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.NBTUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LitematicaSchematic {
    public static final String FILE_EXTENSION = ".litematic";
    public static final int SCHEMATIC_VERSION_1_13_2 = 5;
    public static final int MINECRAFT_DATA_VERSION_1_13_2 = 1631;
    public static final int SCHEMATIC_VERSION = 5;
    public static final int MINECRAFT_DATA_VERSION = SharedConstants.func_215069_a().getWorldVersion();
    private final Map<String, LitematicaBlockStateContainer> blockContainers = new HashMap<String, LitematicaBlockStateContainer>();
    private final Map<String, Map<BlockPos, CompoundNBT>> tileEntities = new HashMap<String, Map<BlockPos, CompoundNBT>>();
    private final Map<String, Map<BlockPos, NextTickListEntry<Block>>> pendingBlockTicks = new HashMap<String, Map<BlockPos, NextTickListEntry<Block>>>();
    private final Map<String, Map<BlockPos, NextTickListEntry<Fluid>>> pendingFluidTicks = new HashMap<String, Map<BlockPos, NextTickListEntry<Fluid>>>();
    private final Map<String, List<EntityInfo>> entities = new HashMap<String, List<EntityInfo>>();
    private final Map<String, BlockPos> subRegionPositions = new HashMap<String, BlockPos>();
    private final Map<String, BlockPos> subRegionSizes = new HashMap<String, BlockPos>();
    private final SchematicMetadata metadata = new SchematicMetadata();
    private final SchematicConverter converter;
    private int totalBlocksReadFromWorld;
    @Nullable
    private final File schematicFile;
    private final FileType schematicType;

    private LitematicaSchematic(@Nullable File file) {
        this(file, FileType.LITEMATICA_SCHEMATIC);
    }

    private LitematicaSchematic(@Nullable File file, FileType schematicType) {
        this.schematicFile = file;
        this.schematicType = schematicType;
        this.converter = SchematicConverter.createForLitematica();
    }

    @Nullable
    public File getFile() {
        return this.schematicFile;
    }

    public Vector3i getTotalSize() {
        return this.metadata.getEnclosingSize();
    }

    public int getTotalBlocksReadFromWorld() {
        return this.totalBlocksReadFromWorld;
    }

    public SchematicMetadata getMetadata() {
        return this.metadata;
    }

    public int getSubRegionCount() {
        return this.blockContainers.size();
    }

    @Nullable
    public BlockPos getSubRegionPosition(String areaName) {
        return this.subRegionPositions.get(areaName);
    }

    public Map<String, BlockPos> getAreaPositions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    public Map<String, BlockPos> getAreaSizes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionSizes.keySet()) {
            BlockPos pos = this.subRegionSizes.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    @Nullable
    public BlockPos getAreaSize(String regionName) {
        return this.subRegionSizes.get(regionName);
    }

    public Map<String, Box> getAreas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            BlockPos posEndRel = fi.dy.masa.litematica.util.PositionUtils.getRelativeEndPositionFromAreaSize((Vector3i)this.subRegionSizes.get(name));
            Box box = new Box(pos, pos.func_177971_a((Vector3i)posEndRel), name);
            builder.put((Object)name, (Object)box);
        }
        return builder.build();
    }

    @Nullable
    public static LitematicaSchematic createFromWorld(World world, AreaSelection area, SchematicSaveInfo info, String author, IStringConsumer feedback) {
        List<Box> boxes = fi.dy.masa.litematica.util.PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            feedback.setString(StringUtils.translate((String)"litematica.error.schematic.create.no_selections", (Object[])new Object[0]));
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(null);
        long time = System.currentTimeMillis();
        BlockPos origin = area.getEffectiveOrigin();
        schematic.setSubRegionPositions(boxes, origin);
        schematic.setSubRegionSizes(boxes);
        schematic.takeBlocksFromWorld(world, boxes, info);
        if (!info.ignoreEntities) {
            schematic.takeEntitiesFromWorld(world, boxes, origin);
        }
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setTimeCreated(time);
        schematic.metadata.setTimeModified(time);
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(fi.dy.masa.litematica.util.PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize((Vector3i)fi.dy.masa.litematica.util.PositionUtils.getEnclosingAreaSize(boxes));
        schematic.metadata.setTotalBlocks(schematic.totalBlocksReadFromWorld);
        return schematic;
    }

    public static LitematicaSchematic createEmptySchematic(AreaSelection area, String author) {
        List<Box> boxes = fi.dy.masa.litematica.util.PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)StringUtils.translate((String)"litematica.error.schematic.create.no_selections", (Object[])new Object[0]), (Object[])new Object[0]);
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(null);
        schematic.setSubRegionPositions(boxes, area.getEffectiveOrigin());
        schematic.setSubRegionSizes(boxes);
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(fi.dy.masa.litematica.util.PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize((Vector3i)fi.dy.masa.litematica.util.PositionUtils.getEnclosingAreaSize(boxes));
        for (Box box : boxes) {
            String regionName = box.getName();
            BlockPos size = box.getSize();
            int sizeX = Math.abs(size.func_177958_n());
            int sizeY = Math.abs(size.func_177956_o());
            int sizeZ = Math.abs(size.func_177952_p());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            schematic.blockContainers.put(regionName, container);
            schematic.tileEntities.put(regionName, new HashMap());
            schematic.entities.put(regionName, new ArrayList());
            schematic.pendingBlockTicks.put(regionName, new HashMap());
            schematic.pendingFluidTicks.put(regionName, new HashMap());
        }
        return schematic;
    }

    public void takeEntityDataFromSchematicaSchematic(SchematicaSchematic schematic, String subRegionName) {
        this.tileEntities.put(subRegionName, schematic.getTiles());
        this.entities.put(subRegionName, schematic.getEntities());
    }

    public boolean placeToWorld(World world, SchematicPlacement schematicPlacement, boolean notifyNeighbors) {
        return this.placeToWorld(world, schematicPlacement, notifyNeighbors, false);
    }

    public boolean placeToWorld(World world, SchematicPlacement schematicPlacement, boolean notifyNeighbors, boolean ignoreEntities) {
        WorldUtils.setShouldPreventBlockUpdates(world, true);
        ImmutableMap<String, SubRegionPlacement> relativePlacements = schematicPlacement.getEnabledRelativeSubRegionPlacements();
        BlockPos origin = schematicPlacement.getOrigin();
        for (String regionName : relativePlacements.keySet()) {
            SubRegionPlacement placement = (SubRegionPlacement)relativePlacements.get((Object)regionName);
            if (!placement.isEnabled()) continue;
            BlockPos regionPos = placement.getPos();
            BlockPos regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, CompoundNBT> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            Map<BlockPos, NextTickListEntry<Block>> scheduledBlockTicks = this.pendingBlockTicks.get(regionName);
            Map<BlockPos, NextTickListEntry<Fluid>> scheduledFluidTicks = this.pendingFluidTicks.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, scheduledBlockTicks, scheduledFluidTicks, notifyNeighbors);
            } else {
                Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (ignoreEntities || schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, entityList);
        }
        WorldUtils.setShouldPreventBlockUpdates(world, false);
        return true;
    }

    private boolean placeBlocksToWorld(World world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<BlockPos, CompoundNBT> tileMap, @Nullable Map<BlockPos, NextTickListEntry<Block>> scheduledBlockTicks, @Nullable Map<BlockPos, NextTickListEntry<Fluid>> scheduledFluidTicks, boolean notifyNeighbors) {
        BlockPos pos;
        int x;
        int z;
        int y;
        BlockPos posEndRelSub = fi.dy.masa.litematica.util.PositionUtils.getRelativeEndPositionFromAreaSize((Vector3i)regionSize);
        BlockPos posEndRel = posEndRelSub.func_177971_a((Vector3i)regionPos);
        BlockPos posMinRel = fi.dy.masa.litematica.util.PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = fi.dy.masa.litematica.util.PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos regionPosAbs = regionPosTransformed.func_177971_a((Vector3i)origin);
        int sizeX = Math.abs(regionSize.func_177958_n());
        int sizeY = Math.abs(regionSize.func_177956_o());
        int sizeZ = Math.abs(regionSize.func_177952_p());
        BlockState barrier = Blocks.field_180401_cv.func_176223_P();
        boolean ignoreInventories = Configs.Generic.PASTE_IGNORE_INVENTORY.getBooleanValue();
        BlockPos.Mutable posMutable = new BlockPos.Mutable();
        ReplaceBehavior replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        Rotation rotationCombined = schematicPlacement.getRotation().func_185830_a(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        int tmp = posMinRel.func_177956_o() - regionPos.func_177956_o() + regionPosTransformed.func_177956_o() + origin.func_177956_o();
        int startY = 0;
        int endY = sizeY;
        if (tmp < 0) {
            startY += 0 - tmp;
        }
        if ((tmp = posMinRel.func_177956_o() - regionPos.func_177956_o() + regionPosTransformed.func_177956_o() + origin.func_177956_o() + (endY - 1)) > 255) {
            endY -= tmp - 255;
        }
        for (y = startY; y < endY; ++y) {
            for (z = 0; z < sizeZ; ++z) {
                for (x = 0; x < sizeX; ++x) {
                    TileEntity te;
                    BlockState state = container.get(x, y, z);
                    if (state.func_177230_c() == Blocks.field_189881_dj) continue;
                    posMutable.func_181079_c(x, y, z);
                    CompoundNBT teNBT = tileMap.get(posMutable);
                    posMutable.func_181079_c(posMinRel.func_177958_n() + x - regionPos.func_177958_n(), posMinRel.func_177956_o() + y - regionPos.func_177956_o(), posMinRel.func_177952_p() + z - regionPos.func_177952_p());
                    BlockPos pos2 = fi.dy.masa.litematica.util.PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos2 = pos2.func_177971_a((Vector3i)regionPosTransformed).func_177971_a((Vector3i)origin);
                    BlockState stateOld = world.func_180495_p(pos2);
                    if (replace == ReplaceBehavior.NONE && !stateOld.func_196958_f() || replace == ReplaceBehavior.WITH_NON_AIR && state.func_196958_f()) continue;
                    if (mirrorMain != Mirror.NONE) {
                        state = state.func_185902_a(mirrorMain);
                    }
                    if (mirrorSub != Mirror.NONE) {
                        state = state.func_185902_a(mirrorSub);
                    }
                    if (rotationCombined != Rotation.NONE) {
                        state = state.func_185907_a(rotationCombined);
                    }
                    if (stateOld == state && !state.func_177230_c().func_235695_q_()) continue;
                    TileEntity teOld = world.func_175625_s(pos2);
                    if (teOld != null) {
                        if (teOld instanceof IInventory) {
                            ((IInventory)teOld).func_174888_l();
                        }
                        world.func_180501_a(pos2, barrier, 20);
                    }
                    if (!world.func_180501_a(pos2, state, 18) || teNBT == null || (te = world.func_175625_s(pos2)) == null) continue;
                    teNBT = teNBT.func_74737_b();
                    teNBT.func_74768_a("x", pos2.func_177958_n());
                    teNBT.func_74768_a("y", pos2.func_177956_o());
                    teNBT.func_74768_a("z", pos2.func_177952_p());
                    if (ignoreInventories) {
                        teNBT.func_82580_o("Items");
                    }
                    try {
                        te.func_230337_a_(state, teNBT);
                        if (ignoreInventories && te instanceof IInventory) {
                            ((IInventory)te).func_174888_l();
                        }
                        if (mirrorMain != Mirror.NONE) {
                            te.func_189668_a(mirrorMain);
                        }
                        if (mirrorSub != Mirror.NONE) {
                            te.func_189668_a(mirrorSub);
                        }
                        if (rotationCombined == Rotation.NONE) continue;
                        te.func_189667_a(rotationCombined);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos2);
                    }
                }
            }
        }
        if (notifyNeighbors) {
            for (y = 0; y < sizeY; ++y) {
                for (z = 0; z < sizeZ; ++z) {
                    for (x = 0; x < sizeX; ++x) {
                        posMutable.func_181079_c(posMinRel.func_177958_n() + x - regionPos.func_177958_n(), posMinRel.func_177956_o() + y - regionPos.func_177956_o(), posMinRel.func_177952_p() + z - regionPos.func_177952_p());
                        pos = fi.dy.masa.litematica.util.PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement).func_177971_a((Vector3i)origin);
                        world.func_230547_a_(pos, world.func_180495_p(pos).func_177230_c());
                    }
                }
            }
        }
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            if (scheduledBlockTicks != null && !scheduledBlockTicks.isEmpty()) {
                for (Map.Entry<BlockPos, NextTickListEntry<Block>> entry : scheduledBlockTicks.entrySet()) {
                    pos = entry.getKey().func_177971_a((Vector3i)regionPosAbs);
                    NextTickListEntry<Block> tick = entry.getValue();
                    serverWorld.func_205220_G_().func_205362_a(pos, tick.func_151351_a(), (int)tick.field_235017_b_, tick.field_82754_f);
                }
            }
            if (scheduledFluidTicks != null && !scheduledFluidTicks.isEmpty()) {
                for (Map.Entry<BlockPos, NextTickListEntry<Fluid>> entry : scheduledFluidTicks.entrySet()) {
                    pos = entry.getKey().func_177971_a((Vector3i)regionPosAbs);
                    BlockState state = world.func_180495_p(pos);
                    if (state.func_204520_s().func_206888_e()) continue;
                    NextTickListEntry<Fluid> tick = entry.getValue();
                    serverWorld.func_205219_F_().func_205362_a(pos, tick.func_151351_a(), (int)tick.field_235017_b_, tick.field_82754_f);
                }
            }
        }
        return true;
    }

    private void placeEntitiesToWorld(World world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList) {
        BlockPos regionPosRelTransformed = fi.dy.masa.litematica.util.PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.func_177958_n() + origin.func_177958_n();
        int offY = regionPosRelTransformed.func_177956_o() + origin.func_177956_o();
        int offZ = regionPosRelTransformed.func_177952_p() + origin.func_177952_p();
        Rotation rotationCombined = schematicPlacement.getRotation().func_185830_a(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (EntityInfo info : entityList) {
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            Vector3d pos = info.posVec;
            pos = fi.dy.masa.litematica.util.PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = fi.dy.masa.litematica.util.PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.field_72450_a + (double)offX;
            double y = pos.field_72448_b + (double)offY;
            double z = pos.field_72449_c + (double)offZ;
            SchematicPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    private void takeEntitiesFromWorld(World world, List<Box> boxes, BlockPos origin) {
        for (Box box : boxes) {
            AxisAlignedBB bb = fi.dy.masa.litematica.util.PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2());
            BlockPos regionPosAbs = box.getPos1();
            ArrayList<EntityInfo> list = new ArrayList<EntityInfo>();
            List entities = world.func_175674_a((Entity)null, bb, null);
            for (Entity entity : entities) {
                CompoundNBT tag;
                if (!entity.func_70039_c(tag = new CompoundNBT())) continue;
                Vector3d posVec = new Vector3d(entity.func_226277_ct_() - (double)regionPosAbs.func_177958_n(), entity.func_226278_cu_() - (double)regionPosAbs.func_177956_o(), entity.func_226281_cx_() - (double)regionPosAbs.func_177952_p());
                NBTUtils.writeEntityPositionToTag((Vector3d)posVec, (CompoundNBT)tag);
                list.add(new EntityInfo(posVec, tag));
            }
            this.entities.put(box.getName(), list);
        }
    }

    public void takeEntitiesFromWorldWithinChunk(World world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, Set<UUID> existingEntities, BlockPos origin) {
        for (Map.Entry entry : volumes.entrySet()) {
            String regionName = (String)entry.getKey();
            List<EntityInfo> list = this.entities.get(regionName);
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null || list == null) continue;
            AxisAlignedBB bb = fi.dy.masa.litematica.util.PositionUtils.createAABBFrom((IntBoundingBox)entry.getValue());
            List entities = world.func_175674_a((Entity)null, bb, null);
            BlockPos regionPosAbs = box.getPos1();
            for (Entity entity : entities) {
                CompoundNBT tag;
                UUID uuid = entity.func_110124_au();
                if (existingEntities.contains(uuid) || !entity.func_70039_c(tag = new CompoundNBT())) continue;
                Vector3d posVec = new Vector3d(entity.func_226277_ct_() - (double)regionPosAbs.func_177958_n(), entity.func_226278_cu_() - (double)regionPosAbs.func_177956_o(), entity.func_226281_cx_() - (double)regionPosAbs.func_177952_p());
                NBTUtils.writeEntityPositionToTag((Vector3d)posVec, (CompoundNBT)tag);
                list.add(new EntityInfo(posVec, tag));
                existingEntities.add(uuid);
            }
        }
    }

    private void takeBlocksFromWorld(World world, List<Box> boxes, SchematicSaveInfo info) {
        BlockPos.Mutable posMutable = new BlockPos.Mutable(0, 0, 0);
        for (Box box : boxes) {
            BlockPos size = box.getSize();
            int sizeX = Math.abs(size.func_177958_n());
            int sizeY = Math.abs(size.func_177956_o());
            int sizeZ = Math.abs(size.func_177952_p());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            HashMap<BlockPos, CompoundNBT> tileEntityMap = new HashMap<BlockPos, CompoundNBT>();
            HashMap blockTickMap = new HashMap();
            HashMap fluidTickMap = new HashMap();
            BlockPos minCorner = fi.dy.masa.litematica.util.PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int startX = minCorner.func_177958_n();
            int startY = minCorner.func_177956_o();
            int startZ = minCorner.func_177952_p();
            boolean visibleOnly = info.visibleOnly;
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        TileEntity te;
                        posMutable.func_181079_c(x + startX, y + startY, z + startZ);
                        if (visibleOnly && !LitematicaSchematic.isExposed(world, (BlockPos)posMutable)) continue;
                        BlockState state = world.func_180495_p((BlockPos)posMutable);
                        container.set(x, y, z, state);
                        if (!state.func_196958_f()) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.func_177230_c().func_235695_q_() || (te = world.func_175625_s((BlockPos)posMutable)) == null) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundNBT tag = te.func_189515_b(new CompoundNBT());
                        NBTUtils.writeBlockPosToTag((Vector3i)pos, (CompoundNBT)tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (world instanceof ServerWorld) {
                List fluidTicks;
                IntBoundingBox tickBox = IntBoundingBox.createProper((int)startX, (int)startY, (int)startZ, (int)(startX + sizeX), (int)(startY + sizeY), (int)(startZ + sizeZ));
                List blockTicks = ((ServerWorld)world).func_205220_G_().func_205366_a(tickBox.toVanillaBox(), false, false);
                if (blockTicks != null) {
                    this.getPendingTicksFromWorld(blockTickMap, blockTicks, minCorner, startY, tickBox.maxY, world.func_82737_E());
                }
                if ((fluidTicks = ((ServerWorld)world).func_205219_F_().func_205366_a(tickBox.toVanillaBox(), false, false)) != null) {
                    this.getPendingTicksFromWorld(fluidTickMap, fluidTicks, minCorner, startY, tickBox.maxY, world.func_82737_E());
                }
            }
            this.blockContainers.put(box.getName(), container);
            this.tileEntities.put(box.getName(), tileEntityMap);
            this.pendingBlockTicks.put(box.getName(), blockTickMap);
            this.pendingFluidTicks.put(box.getName(), fluidTickMap);
        }
    }

    private <T> void getPendingTicksFromWorld(Map<BlockPos, NextTickListEntry<T>> map, List<NextTickListEntry<T>> list, BlockPos minCorner, int startY, int maxY, long currentTime) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            NextTickListEntry<T> entry = list.get(i);
            if (entry.field_180282_a.func_177956_o() < startY || entry.field_180282_a.func_177956_o() >= maxY) continue;
            BlockPos posRelative = new BlockPos(entry.field_180282_a.func_177958_n() - minCorner.func_177958_n(), entry.field_180282_a.func_177956_o() - minCorner.func_177956_o(), entry.field_180282_a.func_177952_p() - minCorner.func_177952_p());
            NextTickListEntry newEntry = new NextTickListEntry(posRelative, entry.func_151351_a(), entry.field_235017_b_ - currentTime, entry.field_82754_f);
            map.put(posRelative, newEntry);
        }
    }

    public static boolean isExposed(World world, BlockPos pos) {
        for (Direction dir : PositionUtils.ALL_DIRECTIONS) {
            BlockPos posAdj = pos.func_177972_a(dir);
            BlockState stateAdj = world.func_180495_p(posAdj);
            if (stateAdj.func_200132_m() && stateAdj.func_224755_d((IBlockReader)world, posAdj, dir)) continue;
            return true;
        }
        return false;
    }

    public void takeBlocksFromWorldWithinChunk(World world, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, SchematicSaveInfo info) {
        BlockPos.Mutable posMutable = new BlockPos.Mutable(0, 0, 0);
        for (Map.Entry volumeEntry : volumes.entrySet()) {
            List fluidTicks;
            String regionName = (String)volumeEntry.getKey();
            IntBoundingBox bb = (IntBoundingBox)volumeEntry.getValue();
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null) {
                Litematica.logger.error("null Box for sub-region '{}' while trying to save chunk-wise schematic", (Object)regionName);
                continue;
            }
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, CompoundNBT> tileEntityMap = this.tileEntities.get(regionName);
            Map blockTickMap = this.pendingBlockTicks.get(regionName);
            Map fluidTickMap = this.pendingFluidTicks.get(regionName);
            if (container == null || tileEntityMap == null || blockTickMap == null || fluidTickMap == null) {
                Litematica.logger.error("null map(s) for sub-region '{}' while trying to save chunk-wise schematic", (Object)regionName);
                continue;
            }
            BlockPos minCorner = fi.dy.masa.litematica.util.PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int offsetX = minCorner.func_177958_n();
            int offsetY = minCorner.func_177956_o();
            int offsetZ = minCorner.func_177952_p();
            int startX = bb.minX - minCorner.func_177958_n();
            int startY = bb.minY - minCorner.func_177956_o();
            int startZ = bb.minZ - minCorner.func_177952_p();
            int endX = startX + (bb.maxX - bb.minX);
            int endY = startY + (bb.maxY - bb.minY);
            int endZ = startZ + (bb.maxZ - bb.minZ);
            boolean visibleOnly = info.visibleOnly;
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        TileEntity te;
                        posMutable.func_181079_c(x + offsetX, y + offsetY, z + offsetZ);
                        if (visibleOnly && !LitematicaSchematic.isExposed(world, (BlockPos)posMutable)) continue;
                        BlockState state = world.func_180495_p((BlockPos)posMutable);
                        container.set(x, y, z, state);
                        if (!state.func_196958_f()) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.func_177230_c().func_235695_q_() || (te = world.func_175625_s((BlockPos)posMutable)) == null) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundNBT tag = te.func_189515_b(new CompoundNBT());
                        NBTUtils.writeBlockPosToTag((Vector3i)pos, (CompoundNBT)tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (!(world instanceof ServerWorld)) continue;
            IntBoundingBox tickBox = IntBoundingBox.createProper((int)(offsetX + startX), (int)(offsetY + startY), (int)(offsetZ + startZ), (int)(offsetX + endX + 1), (int)(offsetY + endY + 1), (int)(offsetZ + endZ + 1));
            List blockTicks = ((ServerWorld)world).func_205220_G_().func_205366_a(tickBox.toVanillaBox(), false, false);
            if (blockTicks != null) {
                this.getPendingTicksFromWorld(blockTickMap, blockTicks, minCorner, startY, tickBox.maxY, world.func_82737_E());
            }
            if ((fluidTicks = ((ServerWorld)world).func_205219_F_().func_205366_a(tickBox.toVanillaBox(), false, false)) == null) continue;
            this.getPendingTicksFromWorld(fluidTickMap, fluidTicks, minCorner, startY, tickBox.maxY, world.func_82737_E());
        }
    }

    private void setSubRegionPositions(List<Box> boxes, BlockPos areaOrigin) {
        for (Box box : boxes) {
            this.subRegionPositions.put(box.getName(), box.getPos1().func_177973_b((Vector3i)areaOrigin));
        }
    }

    private void setSubRegionSizes(List<Box> boxes) {
        for (Box box : boxes) {
            this.subRegionSizes.put(box.getName(), box.getSize());
        }
    }

    @Nullable
    public LitematicaBlockStateContainer getSubRegionContainer(String regionName) {
        return this.blockContainers.get(regionName);
    }

    @Nullable
    public Map<BlockPos, CompoundNBT> getBlockEntityMapForRegion(String regionName) {
        return this.tileEntities.get(regionName);
    }

    @Nullable
    public List<EntityInfo> getEntityListForRegion(String regionName) {
        return this.entities.get(regionName);
    }

    private CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("Version", 5);
        nbt.func_74768_a("MinecraftDataVersion", MINECRAFT_DATA_VERSION);
        nbt.func_218657_a("Metadata", (INBT)this.metadata.writeToNBT());
        nbt.func_218657_a("Regions", (INBT)this.writeSubRegionsToNBT());
        return nbt;
    }

    private CompoundNBT writeSubRegionsToNBT() {
        CompoundNBT wrapper = new CompoundNBT();
        if (!this.blockContainers.isEmpty()) {
            for (String regionName : this.blockContainers.keySet()) {
                LitematicaBlockStateContainer blockContainer = this.blockContainers.get(regionName);
                Map<BlockPos, CompoundNBT> tileMap = this.tileEntities.get(regionName);
                List<EntityInfo> entityList = this.entities.get(regionName);
                Map pendingBlockTicks = this.pendingBlockTicks.get(regionName);
                Map pendingFluidTicks = this.pendingFluidTicks.get(regionName);
                CompoundNBT tag = new CompoundNBT();
                tag.func_218657_a("BlockStatePalette", (INBT)blockContainer.getPalette().writeToNBT());
                tag.func_218657_a("BlockStates", (INBT)new LongArrayNBT(blockContainer.getBackingLongArray()));
                tag.func_218657_a("TileEntities", (INBT)this.writeTileEntitiesToNBT(tileMap));
                if (pendingBlockTicks != null) {
                    tag.func_218657_a("PendingBlockTicks", (INBT)this.writePendingTicksToNBT(pendingBlockTicks));
                }
                if (pendingFluidTicks != null) {
                    tag.func_218657_a("PendingFluidTicks", (INBT)this.writePendingTicksToNBT(pendingFluidTicks));
                }
                if (entityList != null) {
                    tag.func_218657_a("Entities", (INBT)this.writeEntitiesToNBT(entityList));
                }
                BlockPos pos = this.subRegionPositions.get(regionName);
                tag.func_218657_a("Position", (INBT)NBTUtils.createBlockPosTag((Vector3i)pos));
                pos = this.subRegionSizes.get(regionName);
                tag.func_218657_a("Size", (INBT)NBTUtils.createBlockPosTag((Vector3i)pos));
                wrapper.func_218657_a(regionName, (INBT)tag);
            }
        }
        return wrapper;
    }

    private ListNBT writeEntitiesToNBT(List<EntityInfo> entityList) {
        ListNBT tagList = new ListNBT();
        if (!entityList.isEmpty()) {
            for (EntityInfo info : entityList) {
                tagList.add((Object)info.nbt);
            }
        }
        return tagList;
    }

    private <T> ListNBT writePendingTicksToNBT(Map<BlockPos, NextTickListEntry<T>> tickMap) {
        ListNBT tagList = new ListNBT();
        if (!tickMap.isEmpty()) {
            for (NextTickListEntry<T> entry : tickMap.values()) {
                String tagName;
                ResourceLocation rl;
                Object target = entry.func_151351_a();
                if (target instanceof Block) {
                    rl = Registry.field_212618_g.func_177774_c((Object)((Block)target));
                    tagName = "Block";
                } else {
                    rl = Registry.field_212619_h.func_177774_c((Object)((Fluid)target));
                    tagName = "Fluid";
                }
                if (rl == null) continue;
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a(tagName, rl.toString());
                tag.func_74768_a("Priority", entry.field_82754_f.func_205398_a());
                tag.func_74768_a("Time", (int)entry.field_235017_b_);
                tag.func_74768_a("x", entry.field_180282_a.func_177958_n());
                tag.func_74768_a("y", entry.field_180282_a.func_177956_o());
                tag.func_74768_a("z", entry.field_180282_a.func_177952_p());
                tagList.add((Object)tag);
            }
        }
        return tagList;
    }

    private ListNBT writeTileEntitiesToNBT(Map<BlockPos, CompoundNBT> tileMap) {
        ListNBT tagList = new ListNBT();
        if (!tileMap.isEmpty()) {
            for (CompoundNBT tag : tileMap.values()) {
                tagList.add((Object)tag);
            }
        }
        return tagList;
    }

    private boolean readFromNBT(CompoundNBT nbt) {
        this.blockContainers.clear();
        this.tileEntities.clear();
        this.entities.clear();
        this.pendingBlockTicks.clear();
        this.subRegionPositions.clear();
        this.subRegionSizes.clear();
        if (nbt.func_150297_b("Version", 3)) {
            int version = nbt.func_74762_e("Version");
            int minecraftDataVersion = nbt.func_74762_e("MinecraftDataVersion");
            if (version >= 1 && version <= 5) {
                this.metadata.readFromNBT(nbt.func_74775_l("Metadata"));
                this.readSubRegionsFromNBT(nbt.func_74775_l("Regions"), version, minecraftDataVersion);
                return true;
            }
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_load.unsupported_schematic_version", (Object[])new Object[]{version});
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_load.no_schematic_version_information", (Object[])new Object[0]);
        }
        return false;
    }

    private void readSubRegionsFromNBT(CompoundNBT tag, int version, int minecraftDataVersion) {
        for (String regionName : tag.func_150296_c()) {
            ListNBT list;
            if (tag.func_74781_a(regionName).func_74732_a() != 10) continue;
            CompoundNBT regionTag = tag.func_74775_l(regionName);
            BlockPos regionPos = NBTUtils.readBlockPos((CompoundNBT)regionTag.func_74775_l("Position"));
            BlockPos regionSize = NBTUtils.readBlockPos((CompoundNBT)regionTag.func_74775_l("Size"));
            Map<BlockPos, CompoundNBT> tiles = null;
            if (regionPos == null || regionSize == null) continue;
            this.subRegionPositions.put(regionName, regionPos);
            this.subRegionSizes.put(regionName, regionSize);
            if (version >= 2) {
                tiles = this.readTileEntitiesFromNBT(regionTag.func_150295_c("TileEntities", 10));
                this.tileEntities.put(regionName, tiles);
                this.entities.put(regionName, this.readEntitiesFromNBT(regionTag.func_150295_c("Entities", 10)));
            } else if (version == 1) {
                tiles = this.readTileEntitiesFromNBT_v1(regionTag.func_150295_c("TileEntities", 10));
                this.tileEntities.put(regionName, tiles);
                this.entities.put(regionName, this.readEntitiesFromNBT_v1(regionTag.func_150295_c("Entities", 10)));
            }
            if (version >= 3) {
                list = regionTag.func_150295_c("PendingBlockTicks", 10);
                this.pendingBlockTicks.put(regionName, this.readPendingTicksFromNBT(list, Blocks.field_150350_a));
            }
            if (version >= 5) {
                list = regionTag.func_150295_c("PendingFluidTicks", 10);
                this.pendingFluidTicks.put(regionName, this.readPendingTicksFromNBT(list, Fluids.field_204541_a));
            }
            if (!regionTag.func_150297_b("BlockStates", 12) || !regionTag.func_150297_b("BlockStatePalette", 9)) continue;
            ListNBT palette = regionTag.func_150295_c("BlockStatePalette", 10);
            long[] blockStateArr = regionTag.func_197645_o("BlockStates");
            BlockPos posEndRel = fi.dy.masa.litematica.util.PositionUtils.getRelativeEndPositionFromAreaSize((Vector3i)regionSize).func_177971_a((Vector3i)regionPos);
            BlockPos posMin = fi.dy.masa.litematica.util.PositionUtils.getMinCorner(regionPos, posEndRel);
            BlockPos posMax = fi.dy.masa.litematica.util.PositionUtils.getMaxCorner(regionPos, posEndRel);
            BlockPos size = posMax.func_177973_b((Vector3i)posMin).func_177982_a(1, 1, 1);
            palette = this.convertBlockStatePalette_1_12_to_1_13_2(palette, version, minecraftDataVersion);
            LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createFrom(palette, blockStateArr, size);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                this.postProcessContainerIfNeeded(palette, container, tiles);
            }
            this.blockContainers.put(regionName, container);
        }
    }

    public static boolean isSizeValid(@Nullable Vector3i size) {
        return size != null && size.func_177958_n() > 0 && size.func_177956_o() > 0 && size.func_177952_p() > 0;
    }

    @Nullable
    private static Vector3i readSizeFromTagImpl(CompoundNBT tag) {
        ListNBT tagList;
        if (tag.func_150297_b("size", 9) && (tagList = tag.func_150295_c("size", 3)).size() == 3) {
            return new Vector3i(tagList.func_186858_c(0), tagList.func_186858_c(1), tagList.func_186858_c(2));
        }
        return null;
    }

    @Nullable
    public static BlockPos readBlockPosFromListTag(CompoundNBT tag, String tagName) {
        ListNBT tagList;
        if (tag.func_150297_b(tagName, 9) && (tagList = tag.func_150295_c(tagName, 3)).size() == 3) {
            return new BlockPos(tagList.func_186858_c(0), tagList.func_186858_c(1), tagList.func_186858_c(2));
        }
        return null;
    }

    protected boolean readPaletteFromLitematicaFormatTag(ListNBT tagList, ILitematicaBlockStatePalette palette) {
        int size = tagList.size();
        ArrayList<BlockState> list = new ArrayList<BlockState>(size);
        for (int id = 0; id < size; ++id) {
            CompoundNBT tag = tagList.func_150305_b(id);
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)tag);
            list.add(state);
        }
        return palette.setMapping(list);
    }

    public static boolean isValidSpongeSchematic(CompoundNBT tag) {
        if (tag.func_150297_b("Width", 99) && tag.func_150297_b("Height", 99) && tag.func_150297_b("Length", 99) && tag.func_150297_b("Version", 3) && tag.func_150297_b("Palette", 10) && tag.func_150297_b("BlockData", 7)) {
            return LitematicaSchematic.isSizeValid(LitematicaSchematic.readSizeFromTagSponge(tag));
        }
        return false;
    }

    public static Vector3i readSizeFromTagSponge(CompoundNBT tag) {
        return new Vector3i(tag.func_74762_e("Width"), tag.func_74762_e("Height"), tag.func_74762_e("Length"));
    }

    protected boolean readSpongePaletteFromTag(CompoundNBT tag, ILitematicaBlockStatePalette palette) {
        int size = tag.func_150296_c().size();
        ArrayList<BlockState> list = new ArrayList<BlockState>(size);
        BlockState air = Blocks.field_150350_a.func_176223_P();
        for (int i = 0; i < size; ++i) {
            list.add(air);
        }
        for (String key : tag.func_150296_c()) {
            BlockState state;
            int id = tag.func_74762_e(key);
            Optional<BlockState> stateOptional = BlockUtils.getBlockStateFromString(key);
            if (stateOptional.isPresent()) {
                state = stateOptional.get();
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)("Unknown block in the Sponge schematic palette: '" + key + "'"), (Object[])new Object[0]);
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            if (id < 0 || id >= size) {
                String msg = "Invalid ID in the Sponge schematic palette: '" + id + "'";
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
                Litematica.logger.error(msg);
                return false;
            }
            list.set(id, state);
        }
        return palette.setMapping(list);
    }

    protected boolean readSpongeBlocksFromTag(CompoundNBT tag, String schematicName, Vector3i size) {
        if (tag.func_150297_b("Palette", 10) && tag.func_150297_b("BlockData", 7)) {
            CompoundNBT paletteTag = tag.func_74775_l("Palette");
            byte[] blockData = tag.func_74770_j("BlockData");
            int paletteSize = paletteTag.func_150296_c().size();
            LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createContainer(paletteSize, blockData, size);
            if (container == null) {
                String msg = "Failed to read blocks from Sponge schematic";
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
                Litematica.logger.error(msg);
                return false;
            }
            this.blockContainers.put(schematicName, container);
            return this.readSpongePaletteFromTag(paletteTag, container.getPalette());
        }
        return false;
    }

    protected Map<BlockPos, CompoundNBT> readSpongeBlockEntitiesFromTag(CompoundNBT tag) {
        HashMap<BlockPos, CompoundNBT> blockEntities = new HashMap<BlockPos, CompoundNBT>();
        int version = tag.func_74762_e("Version");
        String tagName = version == 1 ? "TileEntities" : "BlockEntities";
        ListNBT tagList = tag.func_150295_c(tagName, 10);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT beTag = tagList.func_150305_b(i);
            BlockPos pos = NbtUtils.readBlockPosFromArrayTag(beTag, "Pos");
            if (pos == null || beTag.isEmpty()) continue;
            beTag.func_74778_a("id", beTag.func_74779_i("Id"));
            beTag.func_82580_o("Id");
            beTag.func_82580_o("Pos");
            if (version == 1) {
                beTag.func_82580_o("ContentVersion");
            }
            blockEntities.put(pos, beTag);
        }
        return blockEntities;
    }

    protected List<EntityInfo> readSpongeEntitiesFromTag(CompoundNBT tag) {
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>();
        ListNBT tagList = tag.func_150295_c("Entities", 10);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT entityData = tagList.func_150305_b(i);
            Vector3d pos = NbtUtils.readVec3dFromListTag(entityData);
            if (pos == null || entityData.isEmpty()) continue;
            entityData.func_74778_a("id", entityData.func_74779_i("Id"));
            entityData.func_82580_o("Id");
            entities.add(new EntityInfo(pos, entityData));
        }
        return entities;
    }

    public boolean readFromSpongeSchematic(String name, CompoundNBT tag) {
        if (!LitematicaSchematic.isValidSpongeSchematic(tag)) {
            return false;
        }
        Vector3i size = LitematicaSchematic.readSizeFromTagSponge(tag);
        if (!this.readSpongeBlocksFromTag(tag, name, size)) {
            return false;
        }
        this.tileEntities.put(name, this.readSpongeBlockEntitiesFromTag(tag));
        this.entities.put(name, this.readSpongeEntitiesFromTag(tag));
        if (tag.func_150297_b("author", 8)) {
            this.getMetadata().setAuthor(tag.func_74779_i("author"));
        }
        this.subRegionPositions.put(name, BlockPos.field_177992_a);
        this.subRegionSizes.put(name, new BlockPos(size));
        this.metadata.setName(name);
        this.metadata.setRegionCount(1);
        this.metadata.setTotalVolume(size.func_177958_n() * size.func_177956_o() * size.func_177952_p());
        this.metadata.setEnclosingSize(size);
        this.metadata.setTimeCreated(System.currentTimeMillis());
        this.metadata.setTimeModified(this.metadata.getTimeCreated());
        this.metadata.setTotalBlocks(this.totalBlocksReadFromWorld);
        return true;
    }

    public boolean readFromVanillaStructure(String name, CompoundNBT tag) {
        Vector3i size = LitematicaSchematic.readSizeFromTagImpl(tag);
        if (tag.func_150297_b("palette", 9) && tag.func_150297_b("blocks", 9) && LitematicaSchematic.isSizeValid(size)) {
            ListNBT paletteTag = tag.func_150295_c("palette", 10);
            HashMap<BlockPos, CompoundNBT> tileMap = new HashMap<BlockPos, CompoundNBT>();
            this.tileEntities.put(name, tileMap);
            BlockState air = Blocks.field_150350_a.func_176223_P();
            int paletteSize = paletteTag.size();
            ArrayList<BlockState> list = new ArrayList<BlockState>(paletteSize);
            for (int id = 0; id < paletteSize; ++id) {
                CompoundNBT t = paletteTag.func_150305_b(id);
                BlockState state = NBTUtil.func_190008_d((CompoundNBT)t);
                list.add(state);
            }
            BlockState zeroState = (BlockState)list.get(0);
            int airId = -1;
            for (int i = 0; i < paletteSize; ++i) {
                if (list.get(i) != air) continue;
                airId = i;
                break;
            }
            if (airId != 0) {
                if (airId == -1) {
                    list.add(0, air);
                    ++paletteSize;
                } else {
                    list.set(0, air);
                    list.set(airId, zeroState);
                }
            }
            int bits = Math.max(2, 32 - Integer.numberOfLeadingZeros(paletteSize - 1));
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(size.func_177958_n(), size.func_177956_o(), size.func_177952_p(), bits, null);
            ILitematicaBlockStatePalette palette = container.getPalette();
            palette.setMapping(list);
            this.blockContainers.put(name, container);
            if (tag.func_150297_b("author", 8)) {
                this.getMetadata().setAuthor(tag.func_74779_i("author"));
            }
            this.subRegionPositions.put(name, BlockPos.field_177992_a);
            this.subRegionSizes.put(name, new BlockPos(size));
            this.metadata.setName(name);
            this.metadata.setRegionCount(1);
            this.metadata.setTotalVolume(size.func_177958_n() * size.func_177956_o() * size.func_177952_p());
            this.metadata.setEnclosingSize(size);
            this.metadata.setTimeCreated(System.currentTimeMillis());
            this.metadata.setTimeModified(this.metadata.getTimeCreated());
            ListNBT blockList = tag.func_150295_c("blocks", 10);
            int count = blockList.size();
            int totalBlocks = 0;
            for (int i = 0; i < count; ++i) {
                CompoundNBT blockTag = blockList.func_150305_b(i);
                BlockPos pos = LitematicaSchematic.readBlockPosFromListTag(blockTag, "pos");
                if (pos == null) {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"Failed to read block position for vanilla structure", (Object[])new Object[0]);
                    return false;
                }
                int id = blockTag.func_74762_e("state");
                BlockState state = airId == -1 ? palette.getBlockState(id + 1) : (airId != 0 ? (id == 0 ? zeroState : (id == airId ? air : palette.getBlockState(id))) : palette.getBlockState(id));
                if (state == null) {
                    state = air;
                } else if (state != air) {
                    ++totalBlocks;
                }
                container.set(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state);
                if (!blockTag.func_150297_b("nbt", 10)) continue;
                tileMap.put(pos, blockTag.func_74775_l("nbt"));
            }
            this.metadata.setTotalBlocks(totalBlocks);
            this.entities.put(name, this.readEntitiesFromVanillaStructure(tag));
            return true;
        }
        return false;
    }

    protected List<EntityInfo> readEntitiesFromVanillaStructure(CompoundNBT tag) {
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>();
        ListNBT tagList = tag.func_150295_c("entities", 10);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT entityData = tagList.func_150305_b(i);
            Vector3d pos = LitematicaSchematic.readVector3dFromListTag(entityData, "pos");
            if (pos == null || !entityData.func_150297_b("nbt", 10)) continue;
            entities.add(new EntityInfo(pos, entityData.func_74775_l("nbt")));
        }
        return entities;
    }

    @Nullable
    public static Vector3d readVector3dFromListTag(@Nullable CompoundNBT tag, String tagName) {
        ListNBT tagList;
        if (tag != null && tag.func_150297_b(tagName, 9) && (tagList = tag.func_150295_c(tagName, 6)).func_230528_d__() == 6 && tagList.size() == 3) {
            return new Vector3d(tagList.func_150309_d(0), tagList.func_150309_d(1), tagList.func_150309_d(2));
        }
        return null;
    }

    private void postProcessContainerIfNeeded(ListNBT palette, LitematicaBlockStateContainer container, @Nullable Map<BlockPos, CompoundNBT> tiles) {
        List<BlockState> states = LitematicaSchematic.getStatesFromPaletteTag(palette);
        if (this.converter.createPostProcessStateFilter(states)) {
            IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> postProcessingFilter = this.converter.getPostProcessStateFilter();
            SchematicConverter.postProcessBlocks(container, tiles, postProcessingFilter);
        }
    }

    public static List<BlockState> getStatesFromPaletteTag(ListNBT palette) {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        int size = palette.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT tag = palette.func_150305_b(i);
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            states.add(state);
        }
        return states;
    }

    private ListNBT convertBlockStatePalette_1_12_to_1_13_2(ListNBT oldPalette, int version, int minecraftDataVersion) {
        if (version < 5 || minecraftDataVersion < 1631 && minecraftDataVersion > 0) {
            ListNBT newPalette = new ListNBT();
            int count = oldPalette.size();
            for (int i = 0; i < count; ++i) {
                newPalette.add((Object)SchematicConversionMaps.get_1_13_2_StateTagFor_1_12_Tag(oldPalette.func_150305_b(i)));
            }
            return newPalette;
        }
        return oldPalette;
    }

    private List<EntityInfo> readEntitiesFromNBT(ListNBT tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT entityData = tagList.func_150305_b(i);
            Vector3d posVec = NBTUtils.readEntityPositionFromTag((CompoundNBT)entityData);
            if (posVec == null || entityData.isEmpty()) continue;
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, CompoundNBT> readTileEntitiesFromNBT(ListNBT tagList) {
        HashMap<BlockPos, CompoundNBT> tileMap = new HashMap<BlockPos, CompoundNBT>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            BlockPos pos = NBTUtils.readBlockPos((CompoundNBT)tag);
            if (pos == null || tag.isEmpty()) continue;
            tileMap.put(pos, tag);
        }
        return tileMap;
    }

    private <T> Map<BlockPos, NextTickListEntry<T>> readPendingTicksFromNBT(ListNBT tagList, T clazz) {
        HashMap<BlockPos, NextTickListEntry<T>> tickMap = new HashMap<BlockPos, NextTickListEntry<T>>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            if (!tag.func_150297_b("Time", 99)) continue;
            Object target = null;
            try {
                if (clazz instanceof Block && tag.func_150297_b("Block", 8) ? (target = Registry.field_212618_g.func_82594_a(new ResourceLocation(tag.func_74779_i("Block")))) == null || target == Blocks.field_150350_a : clazz instanceof Fluid && tag.func_150297_b("Fluid", 8) && ((target = Registry.field_212619_h.func_82594_a(new ResourceLocation(tag.func_74779_i("Fluid")))) == null || target == Fluids.field_204541_a)) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target == null) continue;
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            int scheduledTime = tag.func_74762_e("Time");
            TickPriority priority = TickPriority.func_205397_a((int)tag.func_74762_e("Priority"));
            NextTickListEntry entry = new NextTickListEntry(pos, target, (long)scheduledTime, priority);
            tickMap.put(pos, entry);
        }
        return tickMap;
    }

    private List<EntityInfo> readEntitiesFromNBT_v1(ListNBT tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            Vector3d posVec = NBTUtils.readVec3d((CompoundNBT)tag);
            CompoundNBT entityData = tag.func_74775_l("EntityData");
            if (posVec == null || entityData.isEmpty()) continue;
            NBTUtils.writeEntityPositionToTag((Vector3d)posVec, (CompoundNBT)entityData);
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, CompoundNBT> readTileEntitiesFromNBT_v1(ListNBT tagList) {
        HashMap<BlockPos, CompoundNBT> tileMap = new HashMap<BlockPos, CompoundNBT>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            CompoundNBT tileNbt = tag.func_74775_l("TileNBT");
            BlockPos pos = NBTUtils.readBlockPos((CompoundNBT)tag);
            if (pos == null || tileNbt.isEmpty()) continue;
            NBTUtils.writeBlockPosToTag((Vector3i)pos, (CompoundNBT)tileNbt);
            tileMap.put(pos, tileNbt);
        }
        return tileMap;
    }

    public boolean writeToFile(File dir, String fileNameIn, boolean override) {
        String fileName = fileNameIn;
        if (!fileName.endsWith(FILE_EXTENSION)) {
            fileName = fileName + FILE_EXTENSION;
        }
        File fileSchematic = new File(dir, fileName);
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()});
                return false;
            }
            if (!override && fileSchematic.exists()) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.exists", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
                return false;
            }
            FileOutputStream os = new FileOutputStream(fileSchematic);
            CompressedStreamTools.func_74799_a((CompoundNBT)this.writeToNBT(), (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.exception", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
            Litematica.logger.error(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.exception", (Object[])new Object[]{fileSchematic.getAbsolutePath()}), (Throwable)e);
            Litematica.logger.error(e.getMessage());
            return false;
        }
    }

    public boolean readFromFile() {
        return this.readFromFile(this.schematicType);
    }

    private boolean readFromFile(FileType schematicType) {
        try {
            CompoundNBT nbt = LitematicaSchematic.readNbtFromFile(this.schematicFile);
            if (nbt != null) {
                if (schematicType == FileType.SPONGE_SCHEMATIC) {
                    String name = FileUtils.getNameWithoutExtension((String)this.schematicFile.getName()) + " (Converted Structure)";
                    return this.readFromSpongeSchematic(name, nbt);
                }
                if (schematicType == FileType.VANILLA_STRUCTURE) {
                    String name = FileUtils.getNameWithoutExtension((String)this.schematicFile.getName()) + " (Converted Structure)";
                    return this.readFromVanillaStructure(name, nbt);
                }
                if (schematicType == FileType.LITEMATICA_SCHEMATIC) {
                    return this.readFromNBT(nbt);
                }
            }
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.exception", (Object[])new Object[]{this.schematicFile.getAbsolutePath()});
            Litematica.logger.error((Object)e);
        }
        return false;
    }

    public static CompoundNBT readNbtFromFile(File file) {
        if (file == null) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.no_file", (Object[])new Object[0]);
            return null;
        }
        if (!file.exists() || !file.canRead()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.cant_read", (Object[])new Object[]{file.getAbsolutePath()});
            return null;
        }
        return NbtUtils.readNbtFromFile(file);
    }

    public static File fileFromDirAndName(File dir, String fileName, FileType schematicType) {
        if (!fileName.endsWith(FILE_EXTENSION) && schematicType == FileType.LITEMATICA_SCHEMATIC) {
            fileName = fileName + FILE_EXTENSION;
        }
        return new File(dir, fileName);
    }

    @Nullable
    public static SchematicMetadata readMetadataFromFile(File dir, String fileName) {
        CompoundNBT nbt = LitematicaSchematic.readNbtFromFile(LitematicaSchematic.fileFromDirAndName(dir, fileName, FileType.LITEMATICA_SCHEMATIC));
        if (nbt != null) {
            int version;
            SchematicMetadata metadata = new SchematicMetadata();
            if (nbt.func_150297_b("Version", 3) && (version = nbt.func_74762_e("Version")) >= 1 && version <= 5) {
                metadata.readFromNBT(nbt.func_74775_l("Metadata"));
                return metadata;
            }
        }
        return null;
    }

    @Nullable
    public static LitematicaSchematic createFromFile(File dir, String fileName) {
        return LitematicaSchematic.createFromFile(dir, fileName, FileType.LITEMATICA_SCHEMATIC);
    }

    @Nullable
    public static LitematicaSchematic createFromFile(File dir, String fileName, FileType schematicType) {
        File file = LitematicaSchematic.fileFromDirAndName(dir, fileName, schematicType);
        LitematicaSchematic schematic = new LitematicaSchematic(file, schematicType);
        return schematic.readFromFile(schematicType) ? schematic : null;
    }

    public static class SchematicSaveInfo {
        public final boolean visibleOnly;
        public final boolean ignoreEntities;
        public final boolean fromSchematicWorld;

        public SchematicSaveInfo(boolean visibleOnly, boolean ignoreEntities) {
            this(visibleOnly, ignoreEntities, false);
        }

        public SchematicSaveInfo(boolean visibleOnly, boolean ignoreEntities, boolean fromSchematicWorld) {
            this.visibleOnly = visibleOnly;
            this.ignoreEntities = ignoreEntities;
            this.fromSchematicWorld = fromSchematicWorld;
        }
    }

    public static class EntityInfo {
        public final Vector3d posVec;
        public final CompoundNBT nbt;

        public EntityInfo(Vector3d posVec, CompoundNBT nbt) {
            this.posVec = posVec;
            this.nbt = nbt;
        }
    }
}

