/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConverter;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.NbtUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.NBTUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class SchematicaSchematic {
    public static final String FILE_EXTENSION = ".schematic";
    private final SchematicConverter converter;
    private final BlockState[] palette = new BlockState[65536];
    private LitematicaBlockStateContainer blocks;
    private Map<BlockPos, CompoundNBT> tiles = new HashMap<BlockPos, CompoundNBT>();
    private List<CompoundNBT> entities = new ArrayList<CompoundNBT>();
    private Vector3i size = Vector3i.field_177959_e;
    private String fileName;
    private IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> postProcessingFilter;
    private boolean needsConversionPostProcessing;

    private SchematicaSchematic() {
        this.converter = SchematicConverter.createForSchematica();
    }

    public Vector3i getSize() {
        return this.size;
    }

    public Map<BlockPos, CompoundNBT> getTiles() {
        return this.tiles;
    }

    public List<LitematicaSchematic.EntityInfo> getEntities() {
        ArrayList<LitematicaSchematic.EntityInfo> entityList = new ArrayList<LitematicaSchematic.EntityInfo>();
        int size = this.entities.size();
        for (int i = 0; i < size; ++i) {
            CompoundNBT entityData = this.entities.get(i);
            Vector3d posVec = NBTUtils.readEntityPositionFromTag((CompoundNBT)entityData);
            if (posVec == null || entityData.isEmpty()) continue;
            entityList.add(new LitematicaSchematic.EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    public void placeSchematicToWorld(World world, BlockPos posStart, PlacementSettings placement, int setBlockStateFlags) {
        int width = this.size.func_177958_n();
        int height = this.size.func_177956_o();
        int length = this.size.func_177952_p();
        int numBlocks = width * height * length;
        if (this.blocks != null && numBlocks > 0 && this.blocks.getSize().equals((Object)this.size)) {
            int x;
            int z;
            int y;
            Rotation rotation = placement.func_186215_c();
            Mirror mirror = placement.func_186212_b();
            for (y = 0; y < height; ++y) {
                for (z = 0; z < length; ++z) {
                    for (x = 0; x < width; ++x) {
                        TileEntity te;
                        BlockState state = this.blocks.get(x, y, z);
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundNBT teNBT = this.tiles.get(pos);
                        pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vector3i)posStart);
                        state = state.func_185902_a(mirror);
                        state = state.func_185907_a(rotation);
                        if (teNBT != null && (te = world.func_175625_s(pos)) != null) {
                            if (te instanceof IInventory) {
                                ((IInventory)te).func_174888_l();
                            }
                            world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 20);
                        }
                        if (!world.func_180501_a(pos, state, setBlockStateFlags) || teNBT == null || (te = world.func_175625_s(pos)) == null) continue;
                        teNBT.func_74768_a("x", pos.func_177958_n());
                        teNBT.func_74768_a("y", pos.func_177956_o());
                        teNBT.func_74768_a("z", pos.func_177952_p());
                        try {
                            te.func_230337_a_(state, teNBT);
                            te.func_189668_a(mirror);
                            te.func_189667_a(rotation);
                            continue;
                        }
                        catch (Exception e) {
                            Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                        }
                    }
                }
            }
            if ((setBlockStateFlags & 1) != 0) {
                for (y = 0; y < height; ++y) {
                    for (z = 0; z < length; ++z) {
                        for (x = 0; x < width; ++x) {
                            TileEntity te;
                            BlockPos pos = new BlockPos(x, y, z);
                            CompoundNBT teNBT = this.tiles.get(pos);
                            pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vector3i)posStart);
                            world.func_230547_a_(pos, world.func_180495_p(pos).func_177230_c());
                            if (teNBT == null || (te = world.func_175625_s(pos)) == null) continue;
                            te.func_70296_d();
                        }
                    }
                }
            }
            if (!placement.func_186221_e()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    public void placeSchematicDirectlyToChunks(World world, BlockPos posStart, PlacementSettings placement) {
        int width = this.size.func_177958_n();
        int height = this.size.func_177956_o();
        int length = this.size.func_177952_p();
        int numBlocks = width * height * length;
        BlockPos posEnd = posStart.func_177971_a(this.size).func_177982_a(-1, -1, -1);
        if (this.blocks != null && numBlocks > 0 && this.blocks.getSize().equals((Object)this.size) && PositionUtils.arePositionsWithinWorld(world, posStart, posEnd)) {
            BlockPos posMin = PositionUtils.getMinCorner(posStart, posEnd);
            BlockPos posMax = PositionUtils.getMaxCorner(posStart, posEnd);
            Rotation rotation = placement.func_186215_c();
            Mirror mirror = placement.func_186212_b();
            int cxStart = posMin.func_177958_n() >> 4;
            int czStart = posMin.func_177952_p() >> 4;
            int cxEnd = posMax.func_177958_n() >> 4;
            int czEnd = posMax.func_177952_p() >> 4;
            BlockPos.Mutable posMutable = new BlockPos.Mutable();
            for (int cz = czStart; cz <= czEnd; ++cz) {
                for (int cx = cxStart; cx <= cxEnd; ++cx) {
                    int xMinChunk = Math.max(cx << 4, posMin.func_177958_n());
                    int zMinChunk = Math.max(cz << 4, posMin.func_177952_p());
                    int xMaxChunk = Math.min((cx << 4) + 15, posMax.func_177958_n());
                    int zMaxChunk = Math.min((cz << 4) + 15, posMax.func_177952_p());
                    Chunk chunk = world.func_212866_a_(cx, cz);
                    if (chunk == null) continue;
                    int y = posMin.func_177956_o();
                    for (int ySrc = 0; ySrc < height; ++ySrc) {
                        int z = zMinChunk;
                        int zSrc = zMinChunk - posStart.func_177952_p();
                        while (z <= zMaxChunk) {
                            int x = xMinChunk;
                            int xSrc = xMinChunk - posStart.func_177958_n();
                            while (x <= xMaxChunk) {
                                TileEntity te;
                                BlockState state = this.blocks.get(xSrc, ySrc, zSrc);
                                posMutable.func_181079_c(xSrc, ySrc, zSrc);
                                CompoundNBT teNBT = this.tiles.get(posMutable);
                                BlockPos pos = new BlockPos(x, y, z);
                                if (teNBT != null && (te = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK)) != null) {
                                    if (te instanceof IInventory) {
                                        ((IInventory)te).func_174888_l();
                                    }
                                    world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 20);
                                }
                                chunk.func_177436_a(pos, state, false);
                                if (teNBT != null && (te = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK)) != null) {
                                    teNBT.func_74768_a("x", pos.func_177958_n());
                                    teNBT.func_74768_a("y", pos.func_177956_o());
                                    teNBT.func_74768_a("z", pos.func_177952_p());
                                    try {
                                        te.func_230337_a_(state, teNBT);
                                        te.func_189668_a(mirror);
                                        te.func_189667_a(rotation);
                                    }
                                    catch (Exception e) {
                                        Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                                    }
                                }
                                ++x;
                                ++xSrc;
                            }
                            ++z;
                            ++zSrc;
                        }
                        ++y;
                    }
                }
            }
            if (!placement.func_186221_e()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    private void addEntitiesToWorld(World world, BlockPos posStart, PlacementSettings placement) {
        Mirror mirror = placement.func_186212_b();
        Rotation rotation = placement.func_186215_c();
        for (CompoundNBT tag : this.entities) {
            Vector3d relativePos = NBTUtils.readEntityPositionFromTag((CompoundNBT)tag);
            Vector3d transformedRelativePos = PositionUtils.getTransformedPosition(relativePos, mirror, rotation);
            Vector3d realPos = transformedRelativePos.func_72441_c((double)posStart.func_177958_n(), (double)posStart.func_177956_o(), (double)posStart.func_177952_p());
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(tag, world);
            if (entity == null) continue;
            float rotationYaw = entity.func_184217_a(mirror);
            entity.func_70012_b(realPos.field_72450_a, realPos.field_72448_b, realPos.field_72449_c, rotationYaw += entity.field_70177_z - entity.func_184229_a(rotation), entity.field_70125_A);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    public Map<BlockPos, String> getDataStructureBlocks(BlockPos posStart, PlacementSettings placement) {
        HashMap<BlockPos, String> map = new HashMap<BlockPos, String>();
        for (Map.Entry<BlockPos, CompoundNBT> entry : this.tiles.entrySet()) {
            CompoundNBT tag = entry.getValue();
            if (!tag.func_74779_i("id").equals("minecraft:structure_block") || StructureMode.valueOf((String)tag.func_74779_i("mode")) != StructureMode.DATA) continue;
            BlockPos pos = entry.getKey();
            pos = Template.func_186266_a((PlacementSettings)placement, (BlockPos)pos).func_177971_a((Vector3i)posStart);
            map.put(pos, tag.func_74779_i("metadata"));
        }
        return map;
    }

    private void readBlocksFromWorld(World world, BlockPos posStart, BlockPos size) {
        int startX = posStart.func_177958_n();
        int startY = posStart.func_177956_o();
        int startZ = posStart.func_177952_p();
        int endX = startX + size.func_177958_n();
        int endY = startY + size.func_177956_o();
        int endZ = startZ + size.func_177952_p();
        BlockPos.Mutable posMutable = new BlockPos.Mutable(0, 0, 0);
        this.blocks = new LitematicaBlockStateContainer(size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
        this.tiles.clear();
        this.size = size;
        for (int y = startY; y < endY; ++y) {
            for (int z = startZ; z < endZ; ++z) {
                for (int x = startX; x < endX; ++x) {
                    int relX = x - startX;
                    int relY = y - startY;
                    int relZ = z - startZ;
                    posMutable.func_181079_c(x, y, z);
                    BlockState state = world.func_180495_p((BlockPos)posMutable);
                    this.blocks.set(relX, relY, relZ, state);
                    TileEntity te = world.func_175625_s((BlockPos)posMutable);
                    if (te == null) continue;
                    try {
                        CompoundNBT nbt = te.func_189515_b(new CompoundNBT());
                        nbt.func_74768_a("x", relX);
                        nbt.func_74768_a("y", relY);
                        nbt.func_74768_a("z", relZ);
                        this.tiles.put(new BlockPos(relX, relY, relZ), nbt);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("SchematicaSchematic: Exception while trying to store TileEntity data for block '{}' at {}", (Object)state, (Object)posMutable.toString(), (Object)e);
                    }
                }
            }
        }
    }

    private void readEntitiesFromWorld(World world, BlockPos posStart, BlockPos size) {
        this.entities.clear();
        List entities = world.func_72839_b((Entity)null, new AxisAlignedBB(posStart, posStart.func_177971_a((Vector3i)size)));
        for (Entity entity : entities) {
            CompoundNBT tag;
            if (!entity.func_70039_c(tag = new CompoundNBT())) continue;
            Vector3d pos = new Vector3d(entity.func_226277_ct_() - (double)posStart.func_177958_n(), entity.func_226278_cu_() - (double)posStart.func_177956_o(), entity.func_226281_cx_() - (double)posStart.func_177952_p());
            NBTUtils.writeEntityPositionToTag((Vector3d)pos, (CompoundNBT)tag);
            this.entities.add(tag);
        }
    }

    public static SchematicaSchematic createFromWorld(World world, BlockPos posStart, BlockPos size, boolean ignoreEntities) {
        SchematicaSchematic schematic = new SchematicaSchematic();
        schematic.readBlocksFromWorld(world, posStart, size);
        if (!ignoreEntities) {
            schematic.readEntitiesFromWorld(world, posStart, size);
        }
        return schematic;
    }

    @Nullable
    public static SchematicaSchematic createFromFile(File file) {
        SchematicaSchematic schematic = new SchematicaSchematic();
        if (schematic.readFromFile(file)) {
            return schematic;
        }
        return null;
    }

    public boolean readFromNBT(CompoundNBT nbt) {
        if (this.readBlocksFromNBT(nbt)) {
            this.readEntitiesFromNBT(nbt);
            this.readTileEntitiesFromNBT(nbt);
            try {
                this.postProcessBlocks();
            }
            catch (Exception e) {
                Litematica.logger.error("SchematicaSchematic: Exception while post-processing blocks for '{}'", (Object)this.fileName, (Object)e);
            }
            return true;
        }
        Litematica.logger.error("SchematicaSchematic: Missing block data in the schematic '{}'", (Object)this.fileName);
        return false;
    }

    private boolean readPaletteFromNBT(CompoundNBT nbt) {
        Arrays.fill(this.palette, Blocks.field_150350_a.func_176223_P());
        if (nbt.func_150297_b("SchematicaMapping", 10)) {
            CompoundNBT tag = nbt.func_74775_l("SchematicaMapping");
            Set keys = tag.func_150296_c();
            for (String key : keys) {
                String str;
                short id = tag.func_74765_d(key);
                if (id < 0 || id >= 4096) {
                    str = String.format("SchematicaSchematic: Invalid ID '%d' in SchematicaMapping for block '%s', range: 0 - 4095", id, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                    Litematica.logger.warn(str);
                    return false;
                }
                if (this.converter.getConvertedStatesForBlock(id, key, this.palette)) continue;
                str = String.format("SchematicaSchematic: Missing/non-existing block '%s' in SchematicaMapping", key);
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                Litematica.logger.warn(str);
            }
        } else if (nbt.func_150297_b("BlockIDs", 10)) {
            CompoundNBT tag = nbt.func_74775_l("BlockIDs");
            Set keys = tag.func_150296_c();
            for (String idStr : keys) {
                String str;
                int id;
                String key = tag.func_74779_i(idStr);
                try {
                    id = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    String str2 = String.format("SchematicaSchematic: Invalid ID '%d' (not a number) in MCEdit2 palette for block '%s'", idStr, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str2, (Object[])new Object[0]);
                    Litematica.logger.warn(str2);
                    return false;
                }
                if (id < 0 || id >= 4096) {
                    str = String.format("SchematicaSchematic: Invalid ID '%d' in MCEdit2 palette for block '%s', range: 0 - 4095", id, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                    Litematica.logger.warn(str);
                    return false;
                }
                if (this.converter.getConvertedStatesForBlock(id, key, this.palette)) continue;
                str = String.format("SchematicaSchematic: Missing/non-existing block '%s' in MCEdit2 palette", key);
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                Litematica.logger.warn(str);
            }
        } else {
            this.converter.getVanillaBlockPalette(this.palette);
        }
        if (this.converter.createPostProcessStateFilter(this.palette)) {
            this.postProcessingFilter = this.converter.getPostProcessStateFilter();
            this.needsConversionPostProcessing = true;
        }
        return true;
    }

    private boolean readBlocksFromNBT(CompoundNBT nbt) {
        int z;
        int y;
        int x;
        BlockState state;
        byte addValue;
        int expectedAddLength;
        if (!(nbt.func_150297_b("Blocks", 7) && nbt.func_150297_b("Data", 7) && nbt.func_150297_b("Width", 2) && nbt.func_150297_b("Height", 2) && nbt.func_150297_b("Length", 2))) {
            return false;
        }
        short sizeX = nbt.func_74765_d("Width");
        short sizeY = nbt.func_74765_d("Height");
        short sizeZ = nbt.func_74765_d("Length");
        byte[] blockIdsByte = nbt.func_74770_j("Blocks");
        byte[] metaArr = nbt.func_74770_j("Data");
        int numBlocks = blockIdsByte.length;
        int layerSize = sizeX * sizeZ;
        if (numBlocks != sizeX * sizeY * sizeZ) {
            String str = String.format("SchematicaSchematic: Mismatched block array size compared to the width/height/length,\nblocks: %d, W x H x L: %d x %d x %d", numBlocks, (int)sizeX, (int)sizeY, (int)sizeZ);
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
            return false;
        }
        if (numBlocks != metaArr.length) {
            String str = String.format("SchematicaSchematic: Mismatched block ID and metadata array sizes, blocks: %d, meta: %d", numBlocks, metaArr.length);
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
            return false;
        }
        if (!this.readPaletteFromNBT(nbt)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"SchematicaSchematic: Failed to read the block palette", (Object[])new Object[0]);
            return false;
        }
        this.size = new Vector3i((int)sizeX, (int)sizeY, (int)sizeZ);
        this.blocks = new LitematicaBlockStateContainer(sizeX, (int)sizeY, sizeZ);
        if (nbt.func_150297_b("Add", 7)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"SchematicaSchematic: Old Schematica format detected, not currently implemented...", (Object[])new Object[0]);
            return false;
        }
        byte[] add = null;
        if (nbt.func_150297_b("AddBlocks", 7) && (add = nbt.func_74770_j("AddBlocks")).length != (expectedAddLength = (int)Math.ceil((double)blockIdsByte.length / 2.0))) {
            String str = String.format("SchematicaSchematic: Add array size mismatch, blocks: %d, add: %d, expected add: %d", numBlocks, add.length, expectedAddLength);
            if (add.length < expectedAddLength) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                return false;
            }
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)str, (Object[])new Object[0]);
        }
        int loopMax = numBlocks % 2 == 0 ? numBlocks - 1 : numBlocks - 2;
        int bi = 0;
        int ai = 0;
        while (bi < loopMax) {
            addValue = add != null ? add[ai] : (byte)0;
            int byteId = blockIdsByte[bi] & 0xFF;
            state = this.palette[(addValue & 0xF0) << 8 | byteId << 4 | metaArr[bi]];
            x = bi % sizeX;
            y = bi / layerSize;
            z = bi % layerSize / sizeX;
            this.blocks.set(x, y, z, state);
            x = (bi + 1) % sizeX;
            y = (bi + 1) / layerSize;
            z = (bi + 1) % layerSize / sizeX;
            byteId = blockIdsByte[bi + 1] & 0xFF;
            state = this.palette[(addValue & 0xF) << 12 | byteId << 4 | metaArr[bi + 1]];
            this.blocks.set(x, y, z, state);
            bi += 2;
            ++ai;
        }
        if (numBlocks % 2 != 0) {
            addValue = add != null ? add[ai] : (byte)0;
            int byteId = blockIdsByte[bi] & 0xFF;
            state = this.palette[(addValue & 0xF0) << 8 | byteId << 4 | metaArr[bi]];
            x = bi % sizeX;
            y = bi / layerSize;
            z = bi % layerSize / sizeX;
            this.blocks.set(x, y, z, state);
        }
        return true;
    }

    private void postProcessBlocks() {
        if (this.needsConversionPostProcessing) {
            SchematicConverter.postProcessBlocks(this.blocks, this.tiles, this.postProcessingFilter);
        }
    }

    private void readEntitiesFromNBT(CompoundNBT nbt) {
        this.entities.clear();
        ListNBT tagList = nbt.func_150295_c("Entities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            this.entities.add(tagList.func_150305_b(i));
        }
    }

    private void readTileEntitiesFromNBT(CompoundNBT nbt) {
        this.tiles.clear();
        ListNBT tagList = nbt.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            Vector3i size = this.blocks.getSize();
            if (pos.func_177958_n() < 0 || pos.func_177958_n() >= size.func_177958_n() || pos.func_177956_o() < 0 || pos.func_177956_o() >= size.func_177956_o() || pos.func_177952_p() < 0 || pos.func_177952_p() >= size.func_177952_p()) continue;
            tag = this.converter.fixTileEntityNBT(tag, this.blocks.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            this.tiles.put(pos, tag);
        }
    }

    public boolean readFromFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            this.fileName = file.getName();
            try {
                CompoundNBT nbt = NbtUtils.readNbtFromFile(file);
                return this.readFromNBT(nbt);
            }
            catch (Exception e) {
                Litematica.logger.error("SchematicaSchematic: Failed to read Schematic data from file '{}'", (Object)file.getAbsolutePath());
            }
        }
        return false;
    }
}

