/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.schematic.conversion.IBlockReaderWithData;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class WallStateFixer
implements SchematicConversionFixers.IStateFixer {
    public static final WallStateFixer INSTANCE = new WallStateFixer();
    private static final VoxelShape SHAPE_PILLAR = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    @Override
    public BlockState fixState(IBlockReaderWithData reader, BlockState state, BlockPos pos) {
        IBlockReaderWithData world = reader;
        FluidState fluidState = state.func_204520_s();
        BlockPos posNorth = pos.func_177978_c();
        BlockPos posEast = pos.func_177974_f();
        BlockPos posSouth = pos.func_177968_d();
        BlockPos posWest = pos.func_177976_e();
        BlockPos posUp = pos.func_177984_a();
        BlockState stateNorth = world.func_180495_p(posNorth);
        BlockState stateEast = world.func_180495_p(posEast);
        BlockState stateSouth = world.func_180495_p(posSouth);
        BlockState stateWest = world.func_180495_p(posWest);
        BlockState stateUp = world.func_180495_p(posUp);
        boolean connectNorth = this.shouldConnectTo(stateNorth, stateNorth.func_224755_d((IBlockReader)world, posNorth, Direction.SOUTH), Direction.SOUTH);
        boolean connectEast = this.shouldConnectTo(stateEast, stateEast.func_224755_d((IBlockReader)world, posEast, Direction.WEST), Direction.WEST);
        boolean connectSouth = this.shouldConnectTo(stateSouth, stateSouth.func_224755_d((IBlockReader)world, posSouth, Direction.NORTH), Direction.NORTH);
        boolean connectWest = this.shouldConnectTo(stateWest, stateWest.func_224755_d((IBlockReader)world, posWest, Direction.EAST), Direction.EAST);
        BlockState baseState = (BlockState)state.func_177230_c().func_176223_P().func_206870_a((Property)WallBlock.field_235616_f_, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        return this.getWallStateWithConnections(world, baseState, posUp, stateUp, connectNorth, connectEast, connectSouth, connectWest);
    }

    private BlockState getWallStateWithConnections(IBlockReader worldView, BlockState baseState, BlockPos pos, BlockState stateUp, boolean canConnectNorth, boolean canConnectEast, boolean canConnectSouth, boolean canConnectWest) {
        VoxelShape shapeAbove = stateUp.func_196952_d(worldView, pos).func_212434_a(Direction.DOWN);
        BlockState stateWithSides = this.getWallSideConnections(baseState, canConnectNorth, canConnectEast, canConnectSouth, canConnectWest, shapeAbove);
        return (BlockState)stateWithSides.func_206870_a((Property)WallBlock.field_176256_a, (Comparable)Boolean.valueOf(this.shouldConnectUp(stateWithSides, stateUp, shapeAbove)));
    }

    private BlockState getWallSideConnections(BlockState blockState, boolean canConnectNorth, boolean canConnectEast, boolean canConnectSouth, boolean canConnectWest, VoxelShape shapeAbove) {
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)WallBlock.field_235613_c_, (Comparable)this.getConnectionShape(canConnectNorth, shapeAbove, SHAPE_NORTH))).func_206870_a((Property)WallBlock.field_235612_b_, (Comparable)this.getConnectionShape(canConnectEast, shapeAbove, SHAPE_EAST))).func_206870_a((Property)WallBlock.field_235614_d_, (Comparable)this.getConnectionShape(canConnectSouth, shapeAbove, SHAPE_SOUTH))).func_206870_a((Property)WallBlock.field_235615_e_, (Comparable)this.getConnectionShape(canConnectWest, shapeAbove, SHAPE_WEST));
    }

    private boolean shouldConnectTo(BlockState state, boolean faceFullSquare, Direction side) {
        Block block = state.func_177230_c();
        return state.func_235714_a_((ITag)BlockTags.field_219757_z) || !Block.func_220073_a((Block)block) && faceFullSquare || block instanceof PaneBlock || block instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)state, (Direction)side);
    }

    private boolean shouldConnectUp(BlockState blockState, BlockState stateUp, VoxelShape shapeAbove) {
        boolean inTallLine;
        boolean isPillarOrWallEnd;
        boolean isUpConnectedWallAbove;
        boolean bl = isUpConnectedWallAbove = stateUp.func_177230_c() instanceof WallBlock && (Boolean)stateUp.func_177229_b((Property)WallBlock.field_176256_a) != false;
        if (isUpConnectedWallAbove) {
            return true;
        }
        WallHeight shapeNorth = (WallHeight)blockState.func_177229_b((Property)WallBlock.field_235613_c_);
        WallHeight shapeSouth = (WallHeight)blockState.func_177229_b((Property)WallBlock.field_235614_d_);
        WallHeight shapeEast = (WallHeight)blockState.func_177229_b((Property)WallBlock.field_235612_b_);
        WallHeight shapeWest = (WallHeight)blockState.func_177229_b((Property)WallBlock.field_235615_e_);
        boolean unconnectedNorth = shapeNorth == WallHeight.NONE;
        boolean unconnectedSouth = shapeSouth == WallHeight.NONE;
        boolean unconnectedEast = shapeEast == WallHeight.NONE;
        boolean unconnectedWest = shapeWest == WallHeight.NONE;
        boolean bl2 = isPillarOrWallEnd = unconnectedNorth && unconnectedSouth && unconnectedWest && unconnectedEast || unconnectedNorth != unconnectedSouth || unconnectedWest != unconnectedEast;
        if (isPillarOrWallEnd) {
            return true;
        }
        boolean bl3 = inTallLine = shapeNorth == WallHeight.TALL && shapeSouth == WallHeight.TALL || shapeEast == WallHeight.TALL && shapeWest == WallHeight.TALL;
        if (inTallLine) {
            return false;
        }
        return stateUp.func_177230_c().func_203417_a((ITag)BlockTags.field_232877_ar_) || this.shapesDoNotIntersect(shapeAbove, SHAPE_PILLAR);
    }

    private WallHeight getConnectionShape(boolean canConnect, VoxelShape shapeAbove, VoxelShape shapeSideClearance) {
        if (canConnect) {
            return this.shapesDoNotIntersect(shapeAbove, shapeSideClearance) ? WallHeight.TALL : WallHeight.LOW;
        }
        return WallHeight.NONE;
    }

    private boolean shapesDoNotIntersect(VoxelShape voxelShape, VoxelShape voxelShape2) {
        return !VoxelShapes.func_197879_c((VoxelShape)voxelShape2, (VoxelShape)voxelShape, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    }
}

