/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.selection;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class Box {
    @Nullable
    private BlockPos pos1;
    @Nullable
    private BlockPos pos2;
    private BlockPos size = BlockPos.field_177992_a;
    private String name = "Unnamed";
    private PositionUtils.Corner selectedCorner = PositionUtils.Corner.NONE;

    public Box() {
        this.pos1 = BlockPos.field_177992_a;
        this.pos2 = BlockPos.field_177992_a;
        this.updateSize();
    }

    public Box(@Nullable BlockPos pos1, @Nullable BlockPos pos2, String name) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.name = name;
        this.updateSize();
    }

    public Box copy() {
        Box box = new Box(this.pos1, this.pos2, this.name);
        box.setSelectedCorner(this.selectedCorner);
        return box;
    }

    @Nullable
    public BlockPos getPos1() {
        return this.pos1;
    }

    @Nullable
    public BlockPos getPos2() {
        return this.pos2;
    }

    public BlockPos getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public PositionUtils.Corner getSelectedCorner() {
        return this.selectedCorner;
    }

    public void setPos1(@Nullable BlockPos pos) {
        this.pos1 = pos;
        this.updateSize();
    }

    public void setPos2(@Nullable BlockPos pos) {
        this.pos2 = pos;
        this.updateSize();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSelectedCorner(PositionUtils.Corner corner) {
        this.selectedCorner = corner;
    }

    private void updateSize() {
        this.size = this.pos1 != null && this.pos2 != null ? PositionUtils.getAreaSizeFromRelativeEndPosition(this.pos2.func_177973_b((Vector3i)this.pos1)) : (this.pos1 == null && this.pos2 == null ? BlockPos.field_177992_a : new BlockPos(1, 1, 1));
    }

    public BlockPos getPosition(PositionUtils.Corner corner) {
        return corner == PositionUtils.Corner.CORNER_1 ? this.getPos1() : this.getPos2();
    }

    public int getCoordinate(PositionUtils.Corner corner, PositionUtils.CoordinateType type) {
        BlockPos pos = this.getPosition(corner);
        switch (type) {
            case X: {
                return pos.func_177958_n();
            }
            case Y: {
                return pos.func_177956_o();
            }
            case Z: {
                return pos.func_177952_p();
            }
        }
        return 0;
    }

    protected void setPosition(BlockPos pos, PositionUtils.Corner corner) {
        if (corner == PositionUtils.Corner.CORNER_1) {
            this.setPos1(pos);
        } else if (corner == PositionUtils.Corner.CORNER_2) {
            this.setPos2(pos);
        }
    }

    public void setCoordinate(int value, PositionUtils.Corner corner, PositionUtils.CoordinateType type) {
        BlockPos pos = this.getPosition(corner);
        pos = PositionUtils.getModifiedPosition(pos, value, type);
        this.setPosition(pos, corner);
    }

    @Nullable
    public static Box fromJson(JsonObject obj) {
        if (JsonUtils.hasString((JsonObject)obj, (String)"name")) {
            BlockPos pos1 = JsonUtils.blockPosFromJson((JsonObject)obj, (String)"pos1");
            BlockPos pos2 = JsonUtils.blockPosFromJson((JsonObject)obj, (String)"pos2");
            if (pos1 != null || pos2 != null) {
                Box box = new Box();
                box.setName(obj.get("name").getAsString());
                if (pos1 != null) {
                    box.setPos1(pos1);
                }
                if (pos2 != null) {
                    box.setPos2(pos2);
                }
                return box;
            }
        }
        return null;
    }

    @Nullable
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (this.pos1 != null) {
            obj.add("pos1", (JsonElement)JsonUtils.blockPosToJson((BlockPos)this.pos1));
        }
        if (this.pos2 != null) {
            obj.add("pos2", (JsonElement)JsonUtils.blockPosToJson((BlockPos)this.pos2));
        }
        obj.add("name", (JsonElement)new JsonPrimitive(this.name));
        return this.pos1 != null || this.pos2 != null ? obj : null;
    }
}

