/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class NbtUtils {
    @Nullable
    public static BlockPos readBlockPosFromArrayTag(CompoundNBT tag, String tagName) {
        int[] pos;
        if (tag.func_150297_b(tagName, 11) && (pos = tag.func_74759_k("Pos")).length == 3) {
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static Vector3d readVec3dFromListTag(@Nullable CompoundNBT tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static Vector3d readVec3dFromListTag(@Nullable CompoundNBT tag, String tagName) {
        ListNBT tagList;
        if (tag != null && tag.func_150297_b(tagName, 9) && (tagList = tag.func_150295_c(tagName, 6)).func_230528_d__() == 6 && tagList.size() == 3) {
            return new Vector3d(tagList.func_150309_d(0), tagList.func_150309_d(1), tagList.func_150309_d(2));
        }
        return null;
    }

    @Nullable
    public static CompoundNBT readNbtFromFile(File file) {
        FileInputStream is;
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to read NBT data from file '{}' (failed to create the input stream)", (Object)file.getAbsolutePath());
            return null;
        }
        CompoundNBT nbt = null;
        if (is != null) {
            try {
                nbt = CompressedStreamTools.func_74796_a((InputStream)is);
            }
            catch (Exception e) {
                try {
                    is.close();
                    is = new FileInputStream(file);
                    nbt = CompressedStreamTools.func_74794_a((DataInput)new DataInputStream(is));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt == null) {
            Litematica.logger.warn("Failed to read NBT data from file '{}'", (Object)file.getAbsolutePath());
        }
        return nbt;
    }
}

