/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.collect.ImmutableSet;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.malilib.util.BlockUtils;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class PlacementHandler {
    public static final ImmutableSet<Property<?>> WHITELISTED_PROPERTIES = ImmutableSet.of((Object)BlockStateProperties.field_208188_o, (Object)BlockStateProperties.field_208193_t, (Object)BlockStateProperties.field_208515_s, (Object)BlockStateProperties.field_208148_A, (Object)BlockStateProperties.field_208164_Q, (Object)BlockStateProperties.field_208140_ao, (Object[])new Property[]{BlockStateProperties.field_208141_ap, BlockStateProperties.field_208142_aq, BlockStateProperties.field_208145_at, BlockStateProperties.field_208146_au, BlockStateProperties.field_208158_K, BlockStateProperties.field_208173_Z, BlockStateProperties.field_208126_aa, BlockStateProperties.field_208134_ai, BlockStateProperties.field_208138_am});

    @Nullable
    public static BlockState applyPlacementProtocolToPlacementState(BlockState state, UseContext context) {
        if (Configs.Generic.EASY_PLACE_PROTOCOL_V3.getBooleanValue()) {
            return PlacementHandler.applyPlacementProtocolV3(state, context);
        }
        return PlacementHandler.applyPlacementProtocolV2(state, context);
    }

    public static BlockState applyPlacementProtocolV2(BlockState state, UseContext context) {
        int protocolValue = (int)(context.getHitVec().field_72450_a - (double)context.getPos().func_177958_n()) - 2;
        if (protocolValue < 0) {
            return state;
        }
        DirectionProperty property = BlockUtils.getFirstDirectionProperty((BlockState)state);
        if (property != null && (state = PlacementHandler.applyDirectionProperty(state, context, property, protocolValue)) == null) {
            return null;
        }
        if ((protocolValue &= 0xFFFFFFF0) >= 16) {
            Block block = state.func_177230_c();
            if (block instanceof RepeaterBlock) {
                Integer delay = protocolValue / 16 + 1;
                if (RepeaterBlock.field_176410_b.func_177700_c().contains(delay)) {
                    state = (BlockState)state.func_206870_a((Property)RepeaterBlock.field_176410_b, (Comparable)delay);
                }
            } else if (block instanceof ComparatorBlock) {
                state = (BlockState)state.func_206870_a((Property)ComparatorBlock.field_176463_b, (Comparable)ComparatorMode.SUBTRACT);
            } else if (block instanceof TrapDoorBlock) {
                state = (BlockState)state.func_206870_a((Property)TrapDoorBlock.field_176285_M, (Comparable)Half.TOP);
            } else if (block instanceof StairsBlock && state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.BOTTOM) {
                state = (BlockState)state.func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP);
            }
        }
        return state;
    }

    public static <T extends Comparable<T>> BlockState applyPlacementProtocolV3(BlockState state, UseContext context) {
        int protocolValue = (int)(context.getHitVec().field_72450_a - (double)context.getPos().func_177958_n()) - 2;
        if (protocolValue < 0) {
            return state;
        }
        DirectionProperty property = BlockUtils.getFirstDirectionProperty((BlockState)state);
        if (property != null) {
            if ((state = PlacementHandler.applyDirectionProperty(state, context, property, protocolValue)) == null) {
                return null;
            }
            protocolValue >>>= 3;
        }
        protocolValue >>>= 1;
        ArrayList<Property> propList = new ArrayList<Property>(state.func_177230_c().func_176194_O().func_177623_d());
        propList.sort(Comparator.comparing(Property::func_177701_a));
        try {
            for (Property p : propList) {
                if (p instanceof DirectionProperty || !WHITELISTED_PROPERTIES.contains((Object)p)) continue;
                Property prop = p;
                ArrayList list = new ArrayList(prop.func_177700_c());
                list.sort(Comparable::compareTo);
                int requiredBits = MathHelper.func_151239_c((int)MathHelper.func_151236_b((int)list.size()));
                int bitMask = ~(-1 << requiredBits);
                int valueIndex = protocolValue & bitMask;
                if (valueIndex < 0 || valueIndex >= list.size()) continue;
                Comparable value = (Comparable)list.get(valueIndex);
                if (!state.func_177229_b(prop).equals(value) && value != SlabType.DOUBLE) {
                    state = (BlockState)state.func_206870_a(prop, value);
                }
                protocolValue >>>= requiredBits;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Exception trying to apply placement protocol value", (Throwable)e);
        }
        return state;
    }

    private static BlockState applyDirectionProperty(BlockState state, UseContext context, DirectionProperty property, int protocolValue) {
        Direction facingOrig;
        Direction facing = facingOrig = (Direction)state.func_177229_b((Property)property);
        int decodedFacingIndex = (protocolValue & 0xF) >> 1;
        if (decodedFacingIndex == 6) {
            facing = facing.func_176734_d();
        } else if (decodedFacingIndex >= 0 && decodedFacingIndex <= 5) {
            facing = Direction.func_82600_a((int)decodedFacingIndex);
            if (!property.func_177700_c().contains(facing)) {
                facing = context.getEntity().func_174811_aO().func_176734_d();
            }
        }
        if (facing != facingOrig && property.func_177700_c().contains(facing)) {
            if (state.func_177230_c() instanceof BedBlock) {
                BlockPos headPos = context.pos.func_177972_a(facing);
                BlockItemUseContext ctx = context.getItemPlacementContext();
                if (!context.getWorld().func_180495_p(headPos).func_196953_a(ctx)) {
                    return null;
                }
            }
            state = (BlockState)state.func_206870_a((Property)property, (Comparable)facing);
        }
        return state;
    }

    public static class UseContext {
        private final World world;
        private final BlockPos pos;
        private final Direction side;
        private final Vector3d hitVec;
        private final LivingEntity entity;
        private final Hand hand;
        @Nullable
        private final BlockItemUseContext itemPlacementContext;

        private UseContext(World world, BlockPos pos, Direction side, Vector3d hitVec, LivingEntity entity, Hand hand, @Nullable BlockItemUseContext itemPlacementContext) {
            this.world = world;
            this.pos = pos;
            this.side = side;
            this.hitVec = hitVec;
            this.entity = entity;
            this.hand = hand;
            this.itemPlacementContext = itemPlacementContext;
        }

        public static UseContext from(BlockItemUseContext ctx, Hand hand) {
            Vector3d pos = ctx.func_221532_j();
            return new UseContext(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), new Vector3d(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), (LivingEntity)ctx.func_195999_j(), hand, ctx);
        }

        public World getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getSide() {
            return this.side;
        }

        public Vector3d getHitVec() {
            return this.hitVec;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }

        public Hand getHand() {
            return this.hand;
        }

        @Nullable
        public BlockItemUseContext getItemPlacementContext() {
            return this.itemPlacementContext;
        }
    }
}

