/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import org.apache.commons.lang3.tuple.Pair;

public class PositionUtils {
    public static final BlockPosComparator BLOCK_POS_COMPARATOR = new BlockPosComparator();
    public static final ChunkPosComparator CHUNK_POS_COMPARATOR = new ChunkPosComparator();
    public static final Direction.Axis[] AXES_ALL = new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Y, Direction.Axis.Z};
    public static final Direction[] ADJACENT_SIDES_ZY = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};
    public static final Direction[] ADJACENT_SIDES_XY = new Direction[]{Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST};
    public static final Direction[] ADJACENT_SIDES_XZ = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_XN_ZN = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 0, -1), new Vector3i(-1, 0, -1)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_XP_ZN = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(1, 0, 0), new Vector3i(0, 0, -1), new Vector3i(1, 0, -1)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_XN_ZP = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 0, 1), new Vector3i(-1, 0, 1)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_XP_ZP = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(1, 0, 0), new Vector3i(0, 0, 1), new Vector3i(1, 0, 1)};
    private static final Vector3i[][] EDGE_NEIGHBOR_OFFSETS_Y = new Vector3i[][]{EDGE_NEIGHBOR_OFFSETS_XN_ZN, EDGE_NEIGHBOR_OFFSETS_XP_ZN, EDGE_NEIGHBOR_OFFSETS_XN_ZP, EDGE_NEIGHBOR_OFFSETS_XP_ZP};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_XN_YN = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, -1, 0), new Vector3i(-1, -1, 0)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_XP_YN = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(1, 0, 0), new Vector3i(0, -1, 0), new Vector3i(1, -1, 0)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_XN_YP = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 1, 0), new Vector3i(-1, 1, 0)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_XP_YP = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(1, 0, 0), new Vector3i(0, 1, 0), new Vector3i(1, 1, 0)};
    private static final Vector3i[][] EDGE_NEIGHBOR_OFFSETS_Z = new Vector3i[][]{EDGE_NEIGHBOR_OFFSETS_XN_YN, EDGE_NEIGHBOR_OFFSETS_XP_YN, EDGE_NEIGHBOR_OFFSETS_XN_YP, EDGE_NEIGHBOR_OFFSETS_XP_YP};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_YN_ZN = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(0, -1, 0), new Vector3i(0, 0, -1), new Vector3i(0, -1, -1)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_YP_ZN = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(0, 1, 0), new Vector3i(0, 0, -1), new Vector3i(0, 1, -1)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_YN_ZP = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(0, -1, 0), new Vector3i(0, 0, 1), new Vector3i(0, -1, 1)};
    private static final Vector3i[] EDGE_NEIGHBOR_OFFSETS_YP_ZP = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(0, 1, 0), new Vector3i(0, 0, 1), new Vector3i(0, 1, 1)};
    private static final Vector3i[][] EDGE_NEIGHBOR_OFFSETS_X = new Vector3i[][]{EDGE_NEIGHBOR_OFFSETS_YN_ZN, EDGE_NEIGHBOR_OFFSETS_YP_ZN, EDGE_NEIGHBOR_OFFSETS_YN_ZP, EDGE_NEIGHBOR_OFFSETS_YP_ZP};

    public static Vector3i[] getEdgeNeighborOffsets(Direction.Axis axis, int cornerIndex) {
        switch (axis) {
            case X: {
                return EDGE_NEIGHBOR_OFFSETS_X[cornerIndex];
            }
            case Y: {
                return EDGE_NEIGHBOR_OFFSETS_Y[cornerIndex];
            }
            case Z: {
                return EDGE_NEIGHBOR_OFFSETS_Z[cornerIndex];
            }
        }
        return null;
    }

    public static BlockPos getMinCorner(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos getMaxCorner(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static boolean isPositionInsideArea(BlockPos pos, BlockPos posMin, BlockPos posMax) {
        return pos.func_177958_n() >= posMin.func_177958_n() && pos.func_177958_n() <= posMax.func_177958_n() && pos.func_177956_o() >= posMin.func_177956_o() && pos.func_177956_o() <= posMax.func_177956_o() && pos.func_177952_p() >= posMin.func_177952_p() && pos.func_177952_p() <= posMax.func_177952_p();
    }

    public static BlockPos getTransformedPlacementPosition(BlockPos posWithinSub, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        BlockPos pos = posWithinSub;
        pos = PositionUtils.getTransformedBlockPos(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        pos = PositionUtils.getTransformedBlockPos(pos, placement.getMirror(), placement.getRotation());
        return pos;
    }

    public static boolean arePositionsWithinWorld(World world, BlockPos pos1, BlockPos pos2) {
        if (pos1.func_177956_o() >= 0 && pos1.func_177956_o() <= 255 && pos2.func_177956_o() >= 0 && pos2.func_177956_o() <= 255) {
            WorldBorder border = world.func_175723_af();
            return border.func_177746_a(pos1) && border.func_177746_a(pos2);
        }
        return false;
    }

    public static boolean isBoxWithinWorld(World world, Box box) {
        if (box.getPos1() != null && box.getPos2() != null) {
            return PositionUtils.arePositionsWithinWorld(world, box.getPos1(), box.getPos2());
        }
        return false;
    }

    public static boolean isPlacementWithinWorld(World world, SchematicPlacement schematicPlacement, boolean respectRenderRange) {
        LayerRange range = DataManager.getRenderLayerRange();
        BlockPos.Mutable posMutable1 = new BlockPos.Mutable();
        BlockPos.Mutable posMutable2 = new BlockPos.Mutable();
        for (Box box : schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).values()) {
            if (respectRenderRange) {
                IntBoundingBox bb;
                if (!range.intersectsBox(box.getPos1(), box.getPos2()) || (bb = range.getClampedArea(box.getPos1(), box.getPos2())) == null) continue;
                posMutable1.func_181079_c(bb.minX, bb.minY, bb.minZ);
                posMutable2.func_181079_c(bb.maxX, bb.maxY, bb.maxZ);
                if (PositionUtils.arePositionsWithinWorld(world, (BlockPos)posMutable1, (BlockPos)posMutable2)) continue;
                return false;
            }
            if (PositionUtils.isBoxWithinWorld(world, box)) continue;
            return false;
        }
        return true;
    }

    public static BlockPos getAreaSizeFromRelativeEndPosition(BlockPos posEndRelative) {
        int x = posEndRelative.func_177958_n();
        int y = posEndRelative.func_177956_o();
        int z = posEndRelative.func_177952_p();
        x = x >= 0 ? x + 1 : x - 1;
        y = y >= 0 ? y + 1 : y - 1;
        z = z >= 0 ? z + 1 : z - 1;
        return new BlockPos(x, y, z);
    }

    public static BlockPos getAreaSizeFromRelativeEndPositionAbs(BlockPos posEndRelative) {
        int x = posEndRelative.func_177958_n();
        int y = posEndRelative.func_177956_o();
        int z = posEndRelative.func_177952_p();
        x = x >= 0 ? x + 1 : x - 1;
        y = y >= 0 ? y + 1 : y - 1;
        z = z >= 0 ? z + 1 : z - 1;
        return new BlockPos(Math.abs(x), Math.abs(y), Math.abs(z));
    }

    public static BlockPos getRelativeEndPositionFromAreaSize(Vector3i size) {
        int x = size.func_177958_n();
        int y = size.func_177956_o();
        int z = size.func_177952_p();
        x = x >= 0 ? x - 1 : x + 1;
        y = y >= 0 ? y - 1 : y + 1;
        z = z >= 0 ? z - 1 : z + 1;
        return new BlockPos(x, y, z);
    }

    public static List<Box> getValidBoxes(AreaSelection area) {
        ArrayList<Box> boxes = new ArrayList<Box>();
        List<Box> originalBoxes = area.getAllSubRegionBoxes();
        for (Box box : originalBoxes) {
            if (!PositionUtils.isBoxValid(box)) continue;
            boxes.add(box);
        }
        return boxes;
    }

    public static boolean isBoxValid(Box box) {
        return box.getPos1() != null && box.getPos2() != null;
    }

    public static BlockPos getEnclosingAreaSize(AreaSelection area) {
        return PositionUtils.getEnclosingAreaSize(area.getAllSubRegionBoxes());
    }

    public static BlockPos getEnclosingAreaSize(Collection<Box> boxes) {
        Pair<BlockPos, BlockPos> pair = PositionUtils.getEnclosingAreaCorners(boxes);
        return ((BlockPos)pair.getRight()).func_177973_b((Vector3i)pair.getLeft()).func_177982_a(1, 1, 1);
    }

    @Nullable
    public static Pair<BlockPos, BlockPos> getEnclosingAreaCorners(Collection<Box> boxes) {
        if (boxes.isEmpty()) {
            return null;
        }
        BlockPos.Mutable posMin = new BlockPos.Mutable(60000000, 60000000, 60000000);
        BlockPos.Mutable posMax = new BlockPos.Mutable(-60000000, -60000000, -60000000);
        for (Box box : boxes) {
            PositionUtils.getMinMaxCoords(posMin, posMax, box.getPos1());
            PositionUtils.getMinMaxCoords(posMin, posMax, box.getPos2());
        }
        return Pair.of((Object)posMin.func_185334_h(), (Object)posMax.func_185334_h());
    }

    private static void getMinMaxCoords(BlockPos.Mutable posMin, BlockPos.Mutable posMax, @Nullable BlockPos posToCheck) {
        if (posToCheck != null) {
            posMin.func_181079_c(Math.min(posMin.func_177958_n(), posToCheck.func_177958_n()), Math.min(posMin.func_177956_o(), posToCheck.func_177956_o()), Math.min(posMin.func_177952_p(), posToCheck.func_177952_p()));
            posMax.func_181079_c(Math.max(posMax.func_177958_n(), posToCheck.func_177958_n()), Math.max(posMax.func_177956_o(), posToCheck.func_177956_o()), Math.max(posMax.func_177952_p(), posToCheck.func_177952_p()));
        }
    }

    public static int getTotalVolume(Collection<Box> boxes) {
        if (boxes.isEmpty()) {
            return 0;
        }
        int volume = 0;
        for (Box box : boxes) {
            if (!PositionUtils.isBoxValid(box)) continue;
            BlockPos min = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            BlockPos max = PositionUtils.getMaxCorner(box.getPos1(), box.getPos2());
            volume += (max.func_177958_n() - min.func_177958_n() + 1) * (max.func_177956_o() - min.func_177956_o() + 1) * (max.func_177952_p() - min.func_177952_p() + 1);
        }
        return volume;
    }

    public static ImmutableMap<String, IntBoundingBox> getBoxesWithinChunk(int chunkX, int chunkZ, ImmutableMap<String, Box> subRegions) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : subRegions.entrySet()) {
            Box box = (Box)entry.getValue();
            IntBoundingBox bb = box != null ? PositionUtils.getBoundsWithinChunkForBox(box, chunkX, chunkZ) : null;
            if (bb == null) continue;
            builder.put(entry.getKey(), (Object)bb);
        }
        return builder.build();
    }

    public static ImmutableList<IntBoundingBox> getBoxesWithinChunk(int chunkX, int chunkZ, Collection<Box> boxes) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Box box : boxes) {
            IntBoundingBox bb = PositionUtils.getBoundsWithinChunkForBox(box, chunkX, chunkZ);
            if (bb == null) continue;
            builder.add((Object)bb);
        }
        return builder.build();
    }

    public static Set<ChunkPos> getTouchedChunks(ImmutableMap<String, Box> boxes) {
        return PositionUtils.getTouchedChunksForBoxes((Collection<Box>)boxes.values());
    }

    public static Set<ChunkPos> getTouchedChunksForBoxes(Collection<Box> boxes) {
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        for (Box box : boxes) {
            int boxXMin = Math.min(box.getPos1().func_177958_n(), box.getPos2().func_177958_n()) >> 4;
            int boxZMin = Math.min(box.getPos1().func_177952_p(), box.getPos2().func_177952_p()) >> 4;
            int boxXMax = Math.max(box.getPos1().func_177958_n(), box.getPos2().func_177958_n()) >> 4;
            int boxZMax = Math.max(box.getPos1().func_177952_p(), box.getPos2().func_177952_p()) >> 4;
            for (int cz = boxZMin; cz <= boxZMax; ++cz) {
                for (int cx = boxXMin; cx <= boxXMax; ++cx) {
                    set.add(new ChunkPos(cx, cz));
                }
            }
        }
        return set;
    }

    @Nullable
    public static IntBoundingBox getBoundsWithinChunkForBox(Box box, int chunkX, int chunkZ) {
        boolean notOverlapping;
        int chunkXMin = chunkX << 4;
        int chunkZMin = chunkZ << 4;
        int chunkXMax = chunkXMin + 15;
        int chunkZMax = chunkZMin + 15;
        int boxXMin = Math.min(box.getPos1().func_177958_n(), box.getPos2().func_177958_n());
        int boxZMin = Math.min(box.getPos1().func_177952_p(), box.getPos2().func_177952_p());
        int boxXMax = Math.max(box.getPos1().func_177958_n(), box.getPos2().func_177958_n());
        int boxZMax = Math.max(box.getPos1().func_177952_p(), box.getPos2().func_177952_p());
        boolean bl = notOverlapping = boxXMin > chunkXMax || boxZMin > chunkZMax || boxXMax < chunkXMin || boxZMax < chunkZMin;
        if (!notOverlapping) {
            int xMin = Math.max(chunkXMin, boxXMin);
            int yMin = Math.min(box.getPos1().func_177956_o(), box.getPos2().func_177956_o());
            int zMin = Math.max(chunkZMin, boxZMin);
            int xMax = Math.min(chunkXMax, boxXMax);
            int yMax = Math.max(box.getPos1().func_177956_o(), box.getPos2().func_177956_o());
            int zMax = Math.min(chunkZMax, boxZMax);
            return new IntBoundingBox(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        return null;
    }

    public static AxisAlignedBB createEnclosingAABB(BlockPos pos1, BlockPos pos2) {
        int minX = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        int minY = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        int minZ = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        int maxX = Math.max(pos1.func_177958_n(), pos2.func_177958_n()) + 1;
        int maxY = Math.max(pos1.func_177956_o(), pos2.func_177956_o()) + 1;
        int maxZ = Math.max(pos1.func_177952_p(), pos2.func_177952_p()) + 1;
        return PositionUtils.createAABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static AxisAlignedBB createAABBFrom(IntBoundingBox bb) {
        return PositionUtils.createAABB(bb.minX, bb.minY, bb.minZ, bb.maxX + 1, bb.maxY + 1, bb.maxZ + 1);
    }

    public static AxisAlignedBB createAABBForPosition(BlockPos pos) {
        return PositionUtils.createAABBForPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static AxisAlignedBB createAABBForPosition(int x, int y, int z) {
        return PositionUtils.createAABB(x, y, z, x + 1, y + 1, z + 1);
    }

    public static AxisAlignedBB createAABB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static BlockPos getModifiedPosition(BlockPos pos, int value, PositionUtils.CoordinateType type) {
        switch (type) {
            case X: {
                pos = new BlockPos(value, pos.func_177956_o(), pos.func_177952_p());
                break;
            }
            case Y: {
                pos = new BlockPos(pos.func_177958_n(), value, pos.func_177952_p());
                break;
            }
            case Z: {
                pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), value);
            }
        }
        return pos;
    }

    public static int getCoordinate(BlockPos pos, PositionUtils.CoordinateType type) {
        switch (type) {
            case X: {
                return pos.func_177958_n();
            }
            case Y: {
                return pos.func_177956_o();
            }
            case Z: {
                return pos.func_177952_p();
            }
        }
        return 0;
    }

    public static Box growOrShrinkBox(Box box, int amount) {
        BlockPos pos1 = box.getPos1();
        BlockPos pos2 = box.getPos2();
        if (pos1 == null || pos2 == null) {
            if (pos1 == null && pos2 == null) {
                return box;
            }
            if (pos2 == null) {
                pos2 = pos1;
            } else {
                pos1 = pos2;
            }
        }
        Pair<Integer, Integer> x = PositionUtils.growCoordinatePair(pos1.func_177958_n(), pos2.func_177958_n(), amount);
        Pair<Integer, Integer> y = PositionUtils.growCoordinatePair(pos1.func_177956_o(), pos2.func_177956_o(), amount);
        Pair<Integer, Integer> z = PositionUtils.growCoordinatePair(pos1.func_177952_p(), pos2.func_177952_p(), amount);
        Box boxNew = box.copy();
        boxNew.setPos1(new BlockPos(((Integer)x.getLeft()).intValue(), ((Integer)y.getLeft()).intValue(), ((Integer)z.getLeft()).intValue()));
        boxNew.setPos2(new BlockPos(((Integer)x.getRight()).intValue(), ((Integer)y.getRight()).intValue(), ((Integer)z.getRight()).intValue()));
        return boxNew;
    }

    private static Pair<Integer, Integer> growCoordinatePair(int v1, int v2, int amount) {
        if (v2 >= v1) {
            if (v2 + amount >= v1) {
                v2 += amount;
            }
            if (v1 - amount <= v2) {
                v1 -= amount;
            }
        } else if (v1 > v2) {
            if (v1 + amount >= v2) {
                v1 += amount;
            }
            if (v2 - amount <= v1) {
                v2 -= amount;
            }
        }
        return Pair.of((Object)v1, (Object)v2);
    }

    public static void growOrShrinkCurrentSelection(boolean grow) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (area == null || world == null) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
            return;
        }
        Box box = area.getSelectedSubRegionBox();
        if (box == null || box.getPos1() == null && box.getPos2() == null) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.area_selection.grow.no_sub_region_selected", (Object[])new Object[0]);
            return;
        }
        if (box != null && (box.getPos1() != null || box.getPos2() != null)) {
            int amount = 1;
            Box boxNew = box.copy();
            for (int i = 0; i < 256; ++i) {
                if (grow) {
                    boxNew = PositionUtils.growOrShrinkBox(boxNew, amount);
                }
                BlockPos pos1 = boxNew.getPos1();
                BlockPos pos2 = boxNew.getPos2();
                int xMin = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
                int yMin = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
                int zMin = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
                int xMax = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
                int yMax = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
                int zMax = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
                int emptySides = 0;
                if (WorldUtils.isSliceEmpty((World)world, Direction.Axis.X, new BlockPos(xMin, yMin, zMin), new BlockPos(xMin, yMax, zMax))) {
                    xMin += amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((World)world, Direction.Axis.X, new BlockPos(xMax, yMin, zMin), new BlockPos(xMax, yMax, zMax))) {
                    xMax -= amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((World)world, Direction.Axis.Y, new BlockPos(xMin, yMin, zMin), new BlockPos(xMax, yMin, zMax))) {
                    yMin += amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((World)world, Direction.Axis.Y, new BlockPos(xMin, yMax, zMin), new BlockPos(xMax, yMax, zMax))) {
                    yMax -= amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((World)world, Direction.Axis.Z, new BlockPos(xMin, yMin, zMin), new BlockPos(xMax, yMax, zMin))) {
                    zMin += amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((World)world, Direction.Axis.Z, new BlockPos(xMin, yMin, zMax), new BlockPos(xMax, yMax, zMax))) {
                    zMax -= amount;
                    ++emptySides;
                }
                boxNew.setPos1(new BlockPos(xMin, yMin, zMin));
                boxNew.setPos2(new BlockPos(xMax, yMax, zMax));
                if (grow && emptySides >= 6 || !grow && emptySides == 0) break;
            }
            area.setSelectedSubRegionCornerPos(boxNew.getPos1(), Corner.CORNER_1);
            area.setSelectedSubRegionCornerPos(boxNew.getPos2(), Corner.CORNER_2);
        }
    }

    public static BlockPos getTransformedBlockPos(BlockPos pos, Mirror mirror, Rotation rotation) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean isMirrored = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                isMirrored = false;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
        }
        return isMirrored ? new BlockPos(x, y, z) : pos;
    }

    public static BlockPos getReverseTransformedBlockPos(BlockPos pos, Mirror mirror, Rotation rotation) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean isRotated = true;
        int tmp = x;
        switch (rotation) {
            case CLOCKWISE_90: {
                x = z;
                z = -tmp;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                x = -z;
                z = tmp;
                break;
            }
            case CLOCKWISE_180: {
                x = -x;
                z = -z;
                break;
            }
            default: {
                isRotated = false;
            }
        }
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                if (isRotated) break;
                return pos;
            }
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos getOriginalPositionFromTransformed(BlockPos pos, Mirror mirror, Rotation rotation) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean noRotation = false;
        switch (rotation) {
            case CLOCKWISE_90: {
                int tmp = x;
                x = -z;
                z = tmp;
            }
            case COUNTERCLOCKWISE_90: {
                int tmp = x;
                x = z;
                z = -tmp;
            }
            case CLOCKWISE_180: {
                x = -x;
                z = -z;
            }
        }
        noRotation = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                if (!noRotation) break;
                return pos;
            }
        }
        return new BlockPos(x, y, z);
    }

    public static Vector3d getTransformedPosition(Vector3d originalPos, Mirror mirror, Rotation rotation) {
        double x = originalPos.field_72450_a;
        double y = originalPos.field_72448_b;
        double z = originalPos.field_72449_c;
        boolean transformed = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = 1.0 - z;
                break;
            }
            case FRONT_BACK: {
                x = 1.0 - x;
                break;
            }
            default: {
                transformed = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vector3d(z, y, 1.0 - x);
            }
            case CLOCKWISE_90: {
                return new Vector3d(1.0 - z, y, x);
            }
            case CLOCKWISE_180: {
                return new Vector3d(1.0 - x, y, 1.0 - z);
            }
        }
        return transformed ? new Vector3d(x, y, z) : originalPos;
    }

    public static Rotation getReverseRotation(Rotation rotationIn) {
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return Rotation.CLOCKWISE_90;
            }
            case CLOCKWISE_90: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case CLOCKWISE_180: {
                return Rotation.CLOCKWISE_180;
            }
        }
        return rotationIn;
    }

    public static BlockPos getModifiedPartiallyLockedPosition(BlockPos posOriginal, BlockPos posNew, int lockMask) {
        if (lockMask != 0) {
            int x = posNew.func_177958_n();
            int y = posNew.func_177956_o();
            int z = posNew.func_177952_p();
            if ((lockMask & 1 << PositionUtils.CoordinateType.X.ordinal()) != 0) {
                x = posOriginal.func_177958_n();
            }
            if ((lockMask & 1 << PositionUtils.CoordinateType.Y.ordinal()) != 0) {
                y = posOriginal.func_177956_o();
            }
            if ((lockMask & 1 << PositionUtils.CoordinateType.Z.ordinal()) != 0) {
                z = posOriginal.func_177952_p();
            }
            posNew = new BlockPos(x, y, z);
        }
        return posNew;
    }

    public static Direction getFacingFromPositions(BlockPos pos1, BlockPos pos2) {
        if (pos1 == null || pos2 == null) {
            return null;
        }
        return PositionUtils.getFacingFromPositions(pos1.func_177958_n(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177952_p());
    }

    private static Direction getFacingFromPositions(int x1, int z1, int x2, int z2) {
        if (x2 == x1) {
            return z2 > z1 ? Direction.SOUTH : Direction.NORTH;
        }
        if (z2 == z1) {
            return x2 > x1 ? Direction.EAST : Direction.WEST;
        }
        if (x2 > x1) {
            return z2 > z1 ? Direction.EAST : Direction.NORTH;
        }
        return z2 > z1 ? Direction.SOUTH : Direction.WEST;
    }

    public static Rotation cycleRotation(Rotation rotation, boolean reverse) {
        int ordinal = rotation.ordinal();
        ordinal = reverse ? (ordinal == 0 ? Rotation.values().length - 1 : ordinal - 1) : (ordinal >= Rotation.values().length - 1 ? 0 : ordinal + 1);
        return Rotation.values()[ordinal];
    }

    public static Mirror cycleMirror(Mirror mirror, boolean reverse) {
        int ordinal = mirror.ordinal();
        ordinal = reverse ? (ordinal == 0 ? Mirror.values().length - 1 : ordinal - 1) : (ordinal >= Mirror.values().length - 1 ? 0 : ordinal + 1);
        return Mirror.values()[ordinal];
    }

    public static String getRotationNameShort(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return "CW_90";
            }
            case CLOCKWISE_180: {
                return "CW_180";
            }
            case COUNTERCLOCKWISE_90: {
                return "CCW_90";
            }
        }
        return "NONE";
    }

    public static String getMirrorName(Mirror mirror) {
        switch (mirror) {
            case FRONT_BACK: {
                return "FRONT_BACK";
            }
            case LEFT_RIGHT: {
                return "LEFT_RIGHT";
            }
        }
        return "NONE";
    }

    public static float getRotatedYaw(float yaw, Rotation rotation) {
        yaw = MathHelper.func_76142_g((float)yaw);
        switch (rotation) {
            case CLOCKWISE_180: {
                yaw += 180.0f;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                yaw += 270.0f;
                break;
            }
            case CLOCKWISE_90: {
                yaw += 90.0f;
                break;
            }
        }
        return yaw;
    }

    public static float getMirroredYaw(float yaw, Mirror mirror) {
        yaw = MathHelper.func_76142_g((float)yaw);
        switch (mirror) {
            case LEFT_RIGHT: {
                yaw = 180.0f - yaw;
                break;
            }
            case FRONT_BACK: {
                yaw = -yaw;
                break;
            }
        }
        return yaw;
    }

    public static enum Corner {
        NONE,
        CORNER_1,
        CORNER_2;

    }

    public static class ChunkPosComparator
    implements Comparator<ChunkPos> {
        private BlockPos posReference = BlockPos.field_177992_a;
        private boolean closestFirst;

        public ChunkPosComparator setClosestFirst(boolean closestFirst) {
            this.closestFirst = closestFirst;
            return this;
        }

        public ChunkPosComparator setReferencePosition(BlockPos pos) {
            this.posReference = pos;
            return this;
        }

        @Override
        public int compare(ChunkPos pos1, ChunkPos pos2) {
            double dist2;
            double dist1 = this.distanceSq(pos1);
            if (dist1 == (dist2 = this.distanceSq(pos2))) {
                return 0;
            }
            return dist1 < dist2 == this.closestFirst ? -1 : 1;
        }

        private double distanceSq(ChunkPos pos) {
            double dx = (double)(pos.field_77276_a << 4) - (double)this.posReference.func_177958_n();
            double dz = (double)(pos.field_77275_b << 4) - (double)this.posReference.func_177952_p();
            return dx * dx + dz * dz;
        }
    }

    public static class BlockPosComparator
    implements Comparator<BlockPos> {
        private BlockPos posReference = BlockPos.field_177992_a;
        private boolean closestFirst;

        public void setClosestFirst(boolean closestFirst) {
            this.closestFirst = closestFirst;
        }

        public void setReferencePosition(BlockPos pos) {
            this.posReference = pos;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double dist2;
            double dist1 = pos1.func_177951_i((Vector3i)this.posReference);
            if (dist1 == (dist2 = pos2.func_177951_i((Vector3i)this.posReference))) {
                return 0;
            }
            return dist1 < dist2 == this.closestFirst ? -1 : 1;
        }
    }
}

