/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RayTraceUtils {
    private static final AxisAlignedBB FULL_BLOCK_BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static RayTraceWrapper closestBox;
    private static RayTraceWrapper closestCorner;
    private static RayTraceWrapper closestOrigin;
    private static double closestBoxDistance;
    private static double closestCornerDistance;
    private static double closestOriginDistance;
    private static RayTraceWrapper.HitType originType;

    @Nullable
    public static BlockPos getTargetedPosition(World world, Entity player, double maxDistance, boolean sneakToOffset) {
        RayTraceResult trace = RayTraceUtils.getRayTraceFromEntity(world, player, false, maxDistance);
        if (trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return null;
        }
        BlockRayTraceResult traceBlock = (BlockRayTraceResult)trace;
        BlockPos pos = traceBlock.func_216350_a();
        if (sneakToOffset == player.func_225608_bj_()) {
            pos = pos.func_177972_a(traceBlock.func_216354_b());
        }
        return pos;
    }

    @Nonnull
    public static RayTraceWrapper getWrappedRayTraceFromEntity(World world, Entity entity, double range) {
        Vector3d eyesPos = entity.func_174824_e(1.0f);
        Vector3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(range);
        Vector3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        RayTraceResult result = RayTraceUtils.getRayTraceFromEntity(world, entity, false, range);
        double closestVanilla = result.func_216346_c() != RayTraceResult.Type.MISS ? result.func_216347_e().func_72438_d(eyesPos) : -1.0;
        AreaSelection area = DataManager.getSelectionManager().getCurrentSelection();
        RayTraceWrapper wrapper = null;
        RayTraceUtils.clearTraceVars();
        if (!DataManager.getToolMode().getUsesSchematic() && area != null) {
            for (Box box : area.getAllSubRegionBoxes()) {
                boolean hitCorner = false;
                hitCorner |= RayTraceUtils.traceToSelectionBoxCorner(box, PositionUtils.Corner.CORNER_1, eyesPos, lookEndPos);
                if (hitCorner |= RayTraceUtils.traceToSelectionBoxCorner(box, PositionUtils.Corner.CORNER_2, eyesPos, lookEndPos)) continue;
                RayTraceUtils.traceToSelectionBoxBody(box, eyesPos, lookEndPos);
            }
            BlockPos origin = area.getExplicitOrigin();
            if (origin != null) {
                RayTraceUtils.traceToOrigin(origin, eyesPos, lookEndPos, RayTraceWrapper.HitType.SELECTION_ORIGIN, null);
            }
        }
        if (DataManager.getToolMode().getUsesSchematic()) {
            for (SchematicPlacement placement : DataManager.getSchematicPlacementManager().getAllSchematicsPlacements()) {
                if (!placement.isEnabled()) continue;
                RayTraceUtils.traceToPlacementBox(placement, eyesPos, lookEndPos);
                RayTraceUtils.traceToOrigin(placement.getOrigin(), eyesPos, lookEndPos, RayTraceWrapper.HitType.PLACEMENT_ORIGIN, placement);
            }
        }
        double closestDistance = closestVanilla;
        if (closestBoxDistance >= 0.0 && (closestVanilla < 0.0 || closestBoxDistance <= closestVanilla)) {
            closestDistance = closestBoxDistance;
            wrapper = closestBox;
        }
        if (closestCornerDistance >= 0.0 && (closestVanilla < 0.0 || closestCornerDistance <= closestVanilla)) {
            closestDistance = closestCornerDistance;
            wrapper = closestCorner;
        }
        if (closestOriginDistance >= 0.0 && (closestVanilla < 0.0 || closestOriginDistance <= closestVanilla)) {
            closestDistance = closestOriginDistance;
            wrapper = originType == RayTraceWrapper.HitType.PLACEMENT_ORIGIN ? closestOrigin : new RayTraceWrapper(RayTraceWrapper.HitType.SELECTION_ORIGIN);
        }
        RayTraceUtils.clearTraceVars();
        if (wrapper == null || closestDistance < 0.0) {
            wrapper = new RayTraceWrapper();
        }
        return wrapper;
    }

    private static void clearTraceVars() {
        closestBox = null;
        closestCorner = null;
        closestOrigin = null;
        closestBoxDistance = -1.0;
        closestCornerDistance = -1.0;
        closestOriginDistance = -1.0;
    }

    private static boolean traceToSelectionBoxCorner(Box box, PositionUtils.Corner corner, Vector3d start, Vector3d end) {
        AxisAlignedBB bb;
        Optional optional;
        BlockPos pos;
        Object object = corner == PositionUtils.Corner.CORNER_1 ? box.getPos1() : (pos = corner == PositionUtils.Corner.CORNER_2 ? box.getPos2() : null);
        if (pos != null && (optional = (bb = PositionUtils.createAABBForPosition(pos)).func_216365_b(start, end)).isPresent()) {
            double dist = ((Vector3d)optional.get()).func_72438_d(start);
            if (closestCornerDistance < 0.0 || dist < closestCornerDistance) {
                closestCornerDistance = dist;
                closestCorner = new RayTraceWrapper(box, corner, (Vector3d)optional.get());
            }
            return true;
        }
        return false;
    }

    private static boolean traceToSelectionBoxBody(Box box, Vector3d start, Vector3d end) {
        AxisAlignedBB bb;
        Optional optional;
        if (box.getPos1() != null && box.getPos2() != null && (optional = (bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2())).func_216365_b(start, end)).isPresent()) {
            double dist = ((Vector3d)optional.get()).func_72438_d(start);
            if (closestBoxDistance < 0.0 || dist < closestBoxDistance) {
                closestBoxDistance = dist;
                closestBox = new RayTraceWrapper(box, PositionUtils.Corner.NONE, (Vector3d)optional.get());
            }
            return true;
        }
        return false;
    }

    private static boolean traceToPlacementBox(SchematicPlacement placement, Vector3d start, Vector3d end) {
        ImmutableMap<String, Box> boxes = placement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED);
        boolean hitSomething = false;
        for (Map.Entry entry : boxes.entrySet()) {
            AxisAlignedBB bb;
            Optional optional;
            String boxName = (String)entry.getKey();
            Box box = (Box)entry.getValue();
            if (box.getPos1() == null || box.getPos2() == null || !(optional = (bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2())).func_216365_b(start, end)).isPresent()) continue;
            double dist = ((Vector3d)optional.get()).func_72438_d(start);
            if (!(closestBoxDistance < 0.0) && !(dist < closestBoxDistance)) continue;
            closestBoxDistance = dist;
            closestBox = new RayTraceWrapper(placement, (Vector3d)optional.get(), boxName);
            hitSomething = true;
        }
        return hitSomething;
    }

    private static boolean traceToOrigin(BlockPos pos, Vector3d start, Vector3d end, RayTraceWrapper.HitType type, @Nullable SchematicPlacement placement) {
        AxisAlignedBB bb;
        Optional optional;
        if (pos != null && (optional = (bb = PositionUtils.createAABBForPosition(pos)).func_216365_b(start, end)).isPresent()) {
            double dist = ((Vector3d)optional.get()).func_72438_d(start);
            if (closestOriginDistance < 0.0 || dist < closestOriginDistance) {
                closestOriginDistance = dist;
                originType = type;
                if (type == RayTraceWrapper.HitType.PLACEMENT_ORIGIN) {
                    closestOrigin = new RayTraceWrapper(placement, (Vector3d)optional.get(), null);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static BlockRayTraceResult traceToPositions(List<BlockPos> posList, Entity entity, double range) {
        if (posList.isEmpty()) {
            return null;
        }
        Vector3d eyesPos = entity.func_174824_e(1.0f);
        Vector3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(range);
        Vector3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        double closest = -1.0;
        BlockRayTraceResult trace = null;
        for (BlockPos pos : posList) {
            BlockRayTraceResult hit;
            if (pos == null || (hit = AxisAlignedBB.func_197743_a((Iterable)ImmutableList.of((Object)FULL_BLOCK_BOUNDS), (Vector3d)eyesPos, (Vector3d)lookEndPos, (BlockPos)pos)) == null) continue;
            double dist = hit.func_216347_e().func_72438_d(eyesPos);
            if (!(closest < 0.0) && !(dist < closest)) continue;
            trace = new BlockRayTraceResult(hit.func_216347_e(), hit.func_216354_b(), pos, false);
            closest = dist;
        }
        return trace;
    }

    @Nullable
    public static BlockRayTraceResult traceToSchematicWorld(Entity entity, double range, boolean respectRenderRange, boolean targetFluids) {
        boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
        if (respectRenderRange && (!Configs.Visuals.ENABLE_RENDERING.getBooleanValue() || Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() == invert)) {
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world == null) {
            return null;
        }
        Vector3d eyesPos = entity.func_174824_e(1.0f);
        Vector3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(range);
        Vector3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        RayTraceContext.FluidMode fluidMode = targetFluids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE;
        return RayTraceUtils.rayTraceBlocks(world, eyesPos, lookEndPos, fluidMode, false, true, respectRenderRange, 200);
    }

    @Nullable
    public static RayTraceWrapper getGenericTrace(World worldClient, Entity entity, double range) {
        return RayTraceUtils.getGenericTrace(worldClient, entity, range, true, true, false);
    }

    @Nullable
    public static RayTraceWrapper getGenericTrace(World worldClient, Entity entity, double range, boolean respectRenderRange, boolean targetFluids, boolean includeVerifier) {
        SchematicVerifier verifier;
        List<BlockPos> posList;
        BlockRayTraceResult traceMismatch;
        double dist;
        RayTraceResult traceClient = RayTraceUtils.getRayTraceFromEntity(worldClient, entity, targetFluids, range);
        BlockRayTraceResult traceSchematic = RayTraceUtils.traceToSchematicWorld(entity, range, respectRenderRange, targetFluids);
        double distClosest = -1.0;
        RayTraceWrapper.HitType type = RayTraceWrapper.HitType.MISS;
        Vector3d eyesPos = entity.func_174824_e(1.0f);
        BlockRayTraceResult trace = null;
        if (traceSchematic != null && traceSchematic.func_216346_c() == RayTraceResult.Type.BLOCK) {
            dist = eyesPos.func_72436_e(traceSchematic.func_216347_e());
            if (distClosest < 0.0 || dist < distClosest) {
                trace = traceSchematic;
                distClosest = eyesPos.func_72436_e(traceSchematic.func_216347_e());
                type = RayTraceWrapper.HitType.SCHEMATIC_BLOCK;
            }
        }
        if (traceClient != null && traceClient.func_216346_c() == RayTraceResult.Type.BLOCK) {
            dist = eyesPos.func_72436_e(traceClient.func_216347_e());
            if (distClosest < 0.0 || dist < distClosest) {
                trace = traceClient;
                type = RayTraceWrapper.HitType.VANILLA_BLOCK;
            }
        }
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (includeVerifier && placement != null && placement.hasVerifier() && (traceMismatch = RayTraceUtils.traceToPositions(posList = (verifier = placement.getSchematicVerifier()).getSelectedMismatchBlockPositionsForRender(), entity, range)) != null) {
            trace = traceMismatch;
            type = RayTraceWrapper.HitType.MISMATCH_OVERLAY;
        }
        if (type != RayTraceWrapper.HitType.MISS) {
            return new RayTraceWrapper(type, trace);
        }
        return null;
    }

    @Nullable
    public static RayTraceWrapper getSchematicWorldTraceWrapperIfClosest(World worldClient, Entity entity, double range) {
        RayTraceWrapper trace = RayTraceUtils.getGenericTrace(worldClient, entity, range);
        if (trace != null && trace.getHitType() == RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            return trace;
        }
        return null;
    }

    @Nullable
    public static BlockPos getSchematicWorldTraceIfClosest(World worldClient, Entity entity, double range) {
        RayTraceWrapper trace = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest(worldClient, entity, range);
        return trace != null && trace.getHitType() == RayTraceWrapper.HitType.SCHEMATIC_BLOCK ? trace.getBlockHitResult().func_216350_a() : null;
    }

    @Nullable
    public static BlockPos getFurthestSchematicWorldBlockBeforeVanilla(World worldClient, Entity entity, double maxRange, boolean requireVanillaBlockBehind) {
        Vector3d eyesPos = entity.func_174824_e(1.0f);
        Vector3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(maxRange);
        Vector3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        BlockPos closestVanillaPos = null;
        Direction side = null;
        double closestVanilla = -1.0;
        RayTraceResult traceVanilla = RayTraceUtils.getRayTraceFromEntity(worldClient, entity, false, maxRange);
        if (traceVanilla.func_216346_c() == RayTraceResult.Type.BLOCK) {
            closestVanilla = traceVanilla.func_216347_e().func_72436_e(eyesPos);
            BlockRayTraceResult vanillaHitResult = (BlockRayTraceResult)traceVanilla;
            side = vanillaHitResult.func_216354_b();
            closestVanillaPos = vanillaHitResult.func_216350_a();
        } else if (requireVanillaBlockBehind) {
            return null;
        }
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        List<BlockRayTraceResult> list = RayTraceUtils.rayTraceBlocksToList(worldSchematic, eyesPos, lookEndPos, RayTraceContext.FluidMode.NONE, false, false, true, 200);
        BlockRayTraceResult furthestTrace = null;
        double furthestDist = -1.0;
        if (!list.isEmpty()) {
            for (BlockRayTraceResult trace : list) {
                double dist = trace.func_216347_e().func_72436_e(eyesPos);
                if ((furthestDist < 0.0 || dist > furthestDist) && (dist < closestVanilla || closestVanilla < 0.0) && !trace.func_216350_a().equals((Object)closestVanillaPos)) {
                    furthestDist = dist;
                    furthestTrace = trace;
                }
                if (!(closestVanilla >= 0.0) || !(dist > closestVanilla)) continue;
                break;
            }
        }
        if (furthestTrace == null && side != null && closestVanillaPos != null) {
            BlockPos pos = closestVanillaPos.func_177972_a(side);
            LayerRange layerRange = DataManager.getRenderLayerRange();
            if (layerRange.isPositionWithinRange(pos) && !worldSchematic.func_180495_p(pos).func_196958_f() && worldClient.func_180495_p(pos).func_196958_f()) {
                return pos;
            }
        }
        return furthestTrace != null ? furthestTrace.func_216350_a() : null;
    }

    @Nullable
    public static RayTraceWrapper getFurthestSchematicWorldTraceBeforeVanilla(World worldClient, Entity entity, double maxRange) {
        Vector3d eyesPos = entity.func_174824_e(1.0f);
        Vector3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(maxRange);
        Vector3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        BlockPos closestVanillaPos = null;
        double closestVanilla = -1.0;
        RayTraceResult traceVanilla = RayTraceUtils.getRayTraceFromEntity(worldClient, entity, false, maxRange);
        if (traceVanilla.func_216346_c() == RayTraceResult.Type.BLOCK) {
            closestVanilla = traceVanilla.func_216347_e().func_72436_e(eyesPos);
            BlockRayTraceResult vanillaHitResult = (BlockRayTraceResult)traceVanilla;
            closestVanillaPos = vanillaHitResult.func_216350_a();
        }
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        List<BlockRayTraceResult> list = RayTraceUtils.rayTraceBlocksToList(worldSchematic, eyesPos, lookEndPos, RayTraceContext.FluidMode.NONE, false, false, true, 200);
        BlockRayTraceResult furthestTrace = null;
        double furthestDist = -1.0;
        if (!list.isEmpty()) {
            for (BlockRayTraceResult trace : list) {
                double dist = trace.func_216347_e().func_72436_e(eyesPos);
                if ((furthestDist < 0.0 || dist > furthestDist) && (dist < closestVanilla || closestVanilla < 0.0) && !trace.func_216350_a().equals((Object)closestVanillaPos)) {
                    furthestDist = dist;
                    furthestTrace = trace;
                }
                if (!(closestVanilla >= 0.0) || !(dist > closestVanilla)) continue;
                break;
            }
        }
        return furthestTrace != null ? new RayTraceWrapper(RayTraceWrapper.HitType.SCHEMATIC_BLOCK, furthestTrace) : null;
    }

    @Nonnull
    public static RayTraceResult getRayTraceFromEntity(World world, Entity entity, boolean useLiquids, double range) {
        Vector3d eyesPos = entity.func_174824_e(1.0f);
        Vector3d rangedLookRot = entity.func_70676_i(1.0f).func_186678_a(range);
        Vector3d lookEndPos = eyesPos.func_178787_e(rangedLookRot);
        RayTraceContext.FluidMode fluidMode = useLiquids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE;
        BlockRayTraceResult result = RayTraceUtils.rayTraceBlocks(world, eyesPos, lookEndPos, fluidMode, false, false, false, 1000);
        AxisAlignedBB bb = entity.func_174813_aQ().func_72314_b(rangedLookRot.field_72450_a, rangedLookRot.field_72448_b, rangedLookRot.field_72449_c).func_72314_b(1.0, 1.0, 1.0);
        List list = world.func_72839_b(entity, bb);
        double closest = result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK ? eyesPos.func_72438_d(result.func_216347_e()) : Double.MAX_VALUE;
        Entity targetEntity = null;
        Optional optional = Optional.empty();
        for (int i = 0; i < list.size(); ++i) {
            double distance;
            Entity entityTmp = (Entity)list.get(i);
            Optional optionalTmp = entityTmp.func_174813_aQ().func_216365_b(eyesPos, lookEndPos);
            if (!optionalTmp.isPresent() || !((distance = eyesPos.func_72438_d((Vector3d)optionalTmp.get())) <= closest)) continue;
            targetEntity = entityTmp;
            optional = optionalTmp;
            closest = distance;
        }
        if (targetEntity != null) {
            result = new EntityRayTraceResult(targetEntity, (Vector3d)optional.get());
        }
        if (result == null || eyesPos.func_72438_d(result.func_216347_e()) > range) {
            result = BlockRayTraceResult.func_216352_a((Vector3d)Vector3d.field_186680_a, (Direction)Direction.UP, (BlockPos)BlockPos.field_177992_a);
        }
        return result;
    }

    @Nullable
    public static BlockRayTraceResult rayTraceBlocks(World world, Vector3d start, Vector3d end, RayTraceContext.FluidMode fluidMode, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectLayerRange, int maxSteps) {
        FluidState fluidState;
        BlockState blockState;
        if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c) || Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c)) {
            return null;
        }
        LayerRange range = DataManager.getRenderLayerRange();
        RayTraceCalcsData data = new RayTraceCalcsData(start, end, range, fluidMode);
        BlockRayTraceResult trace = RayTraceUtils.traceFirstStep(data, world, blockState = world.func_180495_p(data.blockPos), fluidState = world.func_204610_c(data.blockPos), ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, respectLayerRange);
        if (trace != null) {
            return trace;
        }
        while (--maxSteps >= 0) {
            if (RayTraceUtils.rayTraceCalcs(data, returnLastUncollidableBlock, respectLayerRange)) {
                return data.trace;
            }
            blockState = world.func_180495_p(data.blockPos);
            if (!RayTraceUtils.traceLoopSteps(data, world, blockState, fluidState = world.func_204610_c(data.blockPos), ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, respectLayerRange)) continue;
            return data.trace;
        }
        return returnLastUncollidableBlock ? data.trace : null;
    }

    @Nullable
    private static BlockRayTraceResult traceFirstStep(RayTraceCalcsData data, World world, BlockState blockState, FluidState fluidState, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectLayerRange) {
        if (!(respectLayerRange && !data.range.isPositionWithinRange(data.x, data.y, data.z) || ignoreBlockWithoutBoundingBox && blockState.func_196952_d((IBlockReader)world, data.blockPos).func_197766_b())) {
            VoxelShape blockShape = blockState.func_196954_c((IBlockReader)world, data.blockPos);
            boolean blockCollidable = !blockShape.func_197766_b();
            boolean fluidCollidable = data.fluidMode.func_222248_a(fluidState);
            if (blockCollidable || fluidCollidable) {
                BlockRayTraceResult trace = null;
                if (blockCollidable) {
                    trace = blockShape.func_212433_a(data.start, data.end, data.blockPos);
                }
                if (trace == null && fluidCollidable) {
                    trace = fluidState.func_215676_d((IBlockReader)world, data.blockPos).func_212433_a(data.start, data.end, data.blockPos);
                }
                if (trace != null) {
                    return trace;
                }
            }
        }
        return null;
    }

    @Nullable
    private static boolean traceLoopSteps(RayTraceCalcsData data, World world, BlockState blockState, FluidState fluidState, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectLayerRange) {
        if (!(respectLayerRange && !data.range.isPositionWithinRange(data.x, data.y, data.z) || ignoreBlockWithoutBoundingBox && blockState.func_185904_a() != Material.field_151567_E && blockState.func_196952_d((IBlockReader)world, data.blockPos).func_197766_b())) {
            VoxelShape blockShape = blockState.func_196954_c((IBlockReader)world, data.blockPos);
            boolean blockCollidable = !blockShape.func_197766_b();
            boolean fluidCollidable = data.fluidMode.func_222248_a(fluidState);
            if (!blockCollidable && !fluidCollidable) {
                Vector3d pos = new Vector3d(data.currentX, data.currentY, data.currentZ);
                data.trace = BlockRayTraceResult.func_216352_a((Vector3d)pos, (Direction)data.facing, (BlockPos)data.blockPos);
            } else {
                BlockRayTraceResult traceTmp = null;
                if (blockCollidable) {
                    traceTmp = blockShape.func_212433_a(data.start, data.end, data.blockPos);
                }
                if (traceTmp == null && fluidCollidable) {
                    traceTmp = fluidState.func_215676_d((IBlockReader)world, data.blockPos).func_212433_a(data.start, data.end, data.blockPos);
                }
                if (traceTmp != null) {
                    data.trace = traceTmp;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<BlockRayTraceResult> rayTraceBlocksToList(World world, Vector3d start, Vector3d end, RayTraceContext.FluidMode fluidMode, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectLayerRange, int maxSteps) {
        if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c) || Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c)) {
            return ImmutableList.of();
        }
        LayerRange range = DataManager.getRenderLayerRange();
        RayTraceCalcsData data = new RayTraceCalcsData(start, end, range, fluidMode);
        BlockState blockState = world.func_180495_p(data.blockPos);
        FluidState fluidState = world.func_204610_c(data.blockPos);
        BlockRayTraceResult trace = RayTraceUtils.traceFirstStep(data, world, blockState, fluidState, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, respectLayerRange);
        ArrayList<BlockRayTraceResult> hits = new ArrayList<BlockRayTraceResult>();
        if (trace != null) {
            hits.add(trace);
        }
        while (--maxSteps >= 0) {
            if (RayTraceUtils.rayTraceCalcs(data, returnLastUncollidableBlock, respectLayerRange)) {
                if (data.trace != null) {
                    hits.add(data.trace);
                }
                return hits;
            }
            blockState = world.func_180495_p(data.blockPos);
            if (!RayTraceUtils.traceLoopSteps(data, world, blockState, fluidState = world.func_204610_c(data.blockPos), ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, respectLayerRange)) continue;
            hits.add(data.trace);
        }
        return hits;
    }

    private static boolean rayTraceCalcs(RayTraceCalcsData data, boolean returnLastNonCollidableBlock, boolean respectLayerRange) {
        boolean xDiffers = true;
        boolean yDiffers = true;
        boolean zDiffers = true;
        double nextX = 999.0;
        double nextY = 999.0;
        double nextZ = 999.0;
        if (Double.isNaN(data.currentX) || Double.isNaN(data.currentY) || Double.isNaN(data.currentZ)) {
            data.trace = null;
            return true;
        }
        if (data.x == data.xEnd && data.y == data.yEnd && data.z == data.zEnd) {
            if (!returnLastNonCollidableBlock) {
                data.trace = null;
            }
            return true;
        }
        if (data.xEnd > data.x) {
            nextX = (double)data.x + 1.0;
        } else if (data.xEnd < data.x) {
            nextX = (double)data.x + 0.0;
        } else {
            xDiffers = false;
        }
        if (data.yEnd > data.y) {
            nextY = (double)data.y + 1.0;
        } else if (data.yEnd < data.y) {
            nextY = (double)data.y + 0.0;
        } else {
            yDiffers = false;
        }
        if (data.zEnd > data.z) {
            nextZ = (double)data.z + 1.0;
        } else if (data.zEnd < data.z) {
            nextZ = (double)data.z + 0.0;
        } else {
            zDiffers = false;
        }
        double relStepX = 999.0;
        double relStepY = 999.0;
        double relStepZ = 999.0;
        double distToEndX = data.end.field_72450_a - data.currentX;
        double distToEndY = data.end.field_72448_b - data.currentY;
        double distToEndZ = data.end.field_72449_c - data.currentZ;
        if (xDiffers) {
            relStepX = (nextX - data.currentX) / distToEndX;
        }
        if (yDiffers) {
            relStepY = (nextY - data.currentY) / distToEndY;
        }
        if (zDiffers) {
            relStepZ = (nextZ - data.currentZ) / distToEndZ;
        }
        if (relStepX == -0.0) {
            relStepX = -1.0E-4;
        }
        if (relStepY == -0.0) {
            relStepY = -1.0E-4;
        }
        if (relStepZ == -0.0) {
            relStepZ = -1.0E-4;
        }
        if (relStepX < relStepY && relStepX < relStepZ) {
            data.facing = data.xEnd > data.x ? Direction.WEST : Direction.EAST;
            data.currentX = nextX;
            data.currentY += distToEndY * relStepX;
            data.currentZ += distToEndZ * relStepX;
        } else if (relStepY < relStepZ) {
            data.facing = data.yEnd > data.y ? Direction.DOWN : Direction.UP;
            data.currentX += distToEndX * relStepY;
            data.currentY = nextY;
            data.currentZ += distToEndZ * relStepY;
        } else {
            data.facing = data.zEnd > data.z ? Direction.NORTH : Direction.SOUTH;
            data.currentX += distToEndX * relStepZ;
            data.currentY += distToEndY * relStepZ;
            data.currentZ = nextZ;
        }
        data.x = MathHelper.func_76128_c((double)data.currentX) - (data.facing == Direction.EAST ? 1 : 0);
        data.y = MathHelper.func_76128_c((double)data.currentY) - (data.facing == Direction.UP ? 1 : 0);
        data.z = MathHelper.func_76128_c((double)data.currentZ) - (data.facing == Direction.SOUTH ? 1 : 0);
        data.blockPos = new BlockPos(data.x, data.y, data.z);
        return false;
    }

    public static class RayTraceWrapper {
        private final HitType type;
        private PositionUtils.Corner corner = PositionUtils.Corner.NONE;
        private Vector3d hitVec = Vector3d.field_186680_a;
        @Nullable
        private BlockRayTraceResult traceBlock = null;
        @Nullable
        private EntityRayTraceResult traceEntity = null;
        @Nullable
        private Box box = null;
        @Nullable
        private SchematicPlacement schematicPlacement = null;
        @Nullable
        private String placementRegionName = null;

        public RayTraceWrapper() {
            this.type = HitType.MISS;
        }

        public RayTraceWrapper(HitType type) {
            this.type = type;
        }

        public RayTraceWrapper(HitType type, BlockRayTraceResult trace) {
            this.type = type;
            this.hitVec = trace.func_216347_e();
            this.traceBlock = trace;
        }

        public RayTraceWrapper(HitType type, EntityRayTraceResult trace) {
            this.type = type;
            this.hitVec = trace.func_216347_e();
            this.traceEntity = trace;
        }

        public RayTraceWrapper(Box box, PositionUtils.Corner corner, Vector3d hitVec) {
            this.type = corner == PositionUtils.Corner.NONE ? HitType.SELECTION_BOX_BODY : HitType.SELECTION_BOX_CORNER;
            this.corner = corner;
            this.hitVec = hitVec;
            this.box = box;
        }

        public RayTraceWrapper(SchematicPlacement placement, Vector3d hitVec, @Nullable String regionName) {
            this.type = regionName != null ? HitType.PLACEMENT_SUBREGION : HitType.PLACEMENT_ORIGIN;
            this.hitVec = hitVec;
            this.schematicPlacement = placement;
            this.placementRegionName = regionName;
        }

        public HitType getHitType() {
            return this.type;
        }

        @Nullable
        public BlockRayTraceResult getBlockHitResult() {
            return this.traceBlock;
        }

        @Nullable
        public EntityRayTraceResult getEntityHitResult() {
            return this.traceEntity;
        }

        @Nullable
        public Box getHitSelectionBox() {
            return this.box;
        }

        @Nullable
        public SchematicPlacement getHitSchematicPlacement() {
            return this.schematicPlacement;
        }

        @Nullable
        public String getHitSchematicPlacementRegionName() {
            return this.placementRegionName;
        }

        public Vector3d getHitVec() {
            return this.hitVec;
        }

        public PositionUtils.Corner getHitCorner() {
            return this.corner;
        }

        public static enum HitType {
            MISS,
            VANILLA_BLOCK,
            VANILLA_ENTITY,
            SELECTION_BOX_BODY,
            SELECTION_BOX_CORNER,
            SELECTION_ORIGIN,
            PLACEMENT_SUBREGION,
            PLACEMENT_ORIGIN,
            SCHEMATIC_BLOCK,
            SCHEMATIC_ENTITY,
            MISMATCH_OVERLAY;

        }
    }

    public static class RayTraceCalcsData {
        public final LayerRange range;
        public final RayTraceContext.FluidMode fluidMode;
        public final Vector3d start;
        public final Vector3d end;
        public final int xEnd;
        public final int yEnd;
        public final int zEnd;
        public int x;
        public int y;
        public int z;
        public double currentX;
        public double currentY;
        public double currentZ;
        public BlockPos blockPos;
        public Direction facing;
        public BlockRayTraceResult trace;

        public RayTraceCalcsData(Vector3d start, Vector3d end, LayerRange range, RayTraceContext.FluidMode fluidMode) {
            this.start = start;
            this.end = end;
            this.range = range;
            this.fluidMode = fluidMode;
            this.currentX = start.field_72450_a;
            this.currentY = start.field_72448_b;
            this.currentZ = start.field_72449_c;
            this.xEnd = MathHelper.func_76128_c((double)end.field_72450_a);
            this.yEnd = MathHelper.func_76128_c((double)end.field_72448_b);
            this.zEnd = MathHelper.func_76128_c((double)end.field_72449_c);
            this.x = MathHelper.func_76128_c((double)start.field_72450_a);
            this.y = MathHelper.func_76128_c((double)start.field_72448_b);
            this.z = MathHelper.func_76128_c((double)start.field_72449_c);
            this.blockPos = new BlockPos(this.x, this.y, this.z);
            this.trace = null;
        }
    }
}

