/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.mojang.datafixers.DataFixer;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.FileType;
import fi.dy.masa.litematica.util.IWorldUpdateSuppressor;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.PlacementHandler;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class WorldUtils {
    private static final List<PositionCache> EASY_PLACE_POSITIONS = new ArrayList<PositionCache>();

    public static boolean shouldPreventBlockUpdates(World world) {
        return ((IWorldUpdateSuppressor)world).litematica_getShouldPreventBlockUpdates();
    }

    public static void setShouldPreventBlockUpdates(World world, boolean preventUpdates) {
        ((IWorldUpdateSuppressor)world).litematica_setShouldPreventBlockUpdates(preventUpdates);
    }

    public static boolean convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertSchematicaSchematicToLitematicaSchematic(inputDir, inputFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        SchematicaSchematic schematic = SchematicaSchematic.createFromFile(new File(inputDir, inputFileName));
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_read_schematic");
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld();
        WorldUtils.loadChunksSchematicWorld(world, BlockPos.field_177992_a, schematic.getSize());
        PlacementSettings placementSettings = new PlacementSettings();
        placementSettings.func_186222_a(ignoreEntities);
        schematic.placeSchematicDirectlyToChunks(world, BlockPos.field_177992_a, placementSettings);
        String subRegionName = FileUtils.getNameWithoutExtension((String)inputFileName) + " (Converted Schematic)";
        AreaSelection area = new AreaSelection();
        area.setName(subRegionName);
        subRegionName = area.createNewSubRegionBox(BlockPos.field_177992_a, subRegionName);
        area.setSelectedSubRegionBox(subRegionName);
        Box box = area.getSelectedSubRegionBox();
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, BlockPos.field_177992_a);
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, new BlockPos(schematic.getSize()).func_177982_a(-1, -1, -1));
        LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromWorld(world, area, info, "?", feedback);
        if (litematicaSchematic != null && !ignoreEntities) {
            litematicaSchematic.takeEntityDataFromSchematicaSchematic(schematic, subRegionName);
        } else {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_create_schematic");
        }
        return litematicaSchematic;
    }

    public static boolean convertStructureToLitematicaSchematic(File structureDir, String structureFileName, File outputDir, String outputFileName, boolean override) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertStructureToLitematicaSchematic(structureDir, structureFileName);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertSpongeSchematicToLitematicaSchematic(File dir, String fileName) {
        try {
            LitematicaSchematic schematic = LitematicaSchematic.createFromFile(dir, fileName, FileType.SPONGE_SCHEMATIC);
            if (schematic == null) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to read the Sponge schematic from '" + fileName + '\"'), (Object[])new Object[0]);
            }
            return schematic;
        }
        catch (Exception e) {
            String msg = "Exception while trying to load the Sponge schematic: " + e.getMessage();
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
            Litematica.logger.error(msg);
            return null;
        }
    }

    @Nullable
    public static LitematicaSchematic convertStructureToLitematicaSchematic(File structureDir, String structureFileName) {
        try {
            LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(structureDir, structureFileName, FileType.VANILLA_STRUCTURE);
            if (litematicaSchematic == null) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to read the vanilla structure template from '" + structureFileName + '\"'), (Object[])new Object[0]);
            }
            return litematicaSchematic;
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Exception while trying to load the vanilla structure: " + e.getMessage()), (Object[])new Object[0]);
            Litematica.logger.error("Exception while trying to load the vanilla structure: " + e.getMessage());
            return null;
        }
    }

    public static boolean convertLitematicaSchematicToSchematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        return false;
    }

    public static boolean convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        Template template = WorldUtils.convertLitematicaSchematicToVanillaStructure(inputDir, inputFileName, ignoreEntities, feedback);
        return WorldUtils.writeVanillaStructureToFile(template, outputDir, outputFileName, override, feedback);
    }

    @Nullable
    public static Template convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld();
        BlockPos size = new BlockPos(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, BlockPos.field_177992_a, (Vector3i)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, BlockPos.field_177992_a);
        litematicaSchematic.placeToWorld(world, schematicPlacement, false);
        Template template = new Template();
        template.func_186254_a((World)world, BlockPos.field_177992_a, size, !ignoreEntities, Blocks.field_189881_dj);
        return template;
    }

    private static boolean writeVanillaStructureToFile(Template template, File dir, String fileNameIn, boolean override, IStringConsumer feedback) {
        String fileName = fileNameIn;
        String extension = ".nbt";
        if (!fileName.endsWith(extension)) {
            fileName = fileName + extension;
        }
        File file = new File(dir, fileName);
        FileOutputStream os = null;
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()}));
                return false;
            }
            if (!override && file.exists()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exists", (Object[])new Object[]{file.getAbsolutePath()}));
                return false;
            }
            CompoundNBT tag = template.func_189552_a(new CompoundNBT());
            os = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((CompoundNBT)tag, (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exception", (Object[])new Object[]{file.getAbsolutePath()}));
            return false;
        }
    }

    private static Template readTemplateFromStream(InputStream stream, DataFixer fixer) throws IOException {
        CompoundNBT nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
        Template template = new Template();
        template.func_186256_b(nbt);
        return template;
    }

    public static boolean isClientChunkLoaded(ClientWorld world, int chunkX, int chunkZ) {
        return world.func_72863_F().func_212849_a_(chunkX, chunkZ, ChunkStatus.field_222617_m, false) != null;
    }

    public static void loadChunksSchematicWorld(WorldSchematic world, BlockPos origin, Vector3i areaSize) {
        BlockPos posEnd = origin.func_177971_a((Vector3i)PositionUtils.getRelativeEndPositionFromAreaSize(areaSize));
        BlockPos posMin = PositionUtils.getMinCorner(origin, posEnd);
        BlockPos posMax = PositionUtils.getMaxCorner(origin, posEnd);
        int cxMin = posMin.func_177958_n() >> 4;
        int czMin = posMin.func_177952_p() >> 4;
        int cxMax = posMax.func_177958_n() >> 4;
        int czMax = posMax.func_177952_p() >> 4;
        for (int cz = czMin; cz <= czMax; ++cz) {
            for (int cx = cxMin; cx <= cxMax; ++cx) {
                world.getChunkProvider().loadChunk(cx, cz);
            }
        }
    }

    public static void setToolModeBlockState(ToolMode mode, boolean primary, Minecraft mc) {
        BlockRayTraceResult trace;
        BlockState state = Blocks.field_150350_a.func_176223_P();
        Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getGenericTrace((World)mc.field_71441_e, entity, 6.0);
        if (wrapper != null && (trace = wrapper.getBlockHitResult()) != null && trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = trace.func_216350_a();
            if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                state = SchematicWorldHandler.getSchematicWorld().func_180495_p(pos);
            } else if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
                state = mc.field_71441_e.func_180495_p(pos);
            }
        }
        if (primary) {
            mode.setPrimaryBlock(state);
        } else {
            mode.setSecondaryBlock(state);
        }
    }

    public static boolean doSchematicWorldPickBlock(boolean closest, Minecraft mc) {
        BlockPos pos = closest ? RayTraceUtils.getSchematicWorldTraceIfClosest((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0) : RayTraceUtils.getFurthestSchematicWorldBlockBeforeVanilla((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0, true);
        if (pos != null) {
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            BlockState state = world.func_180495_p(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(state, world, pos);
            InventoryUtils.schematicWorldPickBlock(stack, pos, world, mc);
            return true;
        }
        return false;
    }

    public static void easyPlaceOnUseTick(Minecraft mc) {
        if (mc.field_71439_g != null && DataManager.getToolMode() != ToolMode.REBUILD && Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Configs.Generic.EASY_PLACE_HOLD_ENABLED.getBooleanValue() && Hotkeys.EASY_PLACE_ACTIVATION.getKeybind().isKeybindHeld()) {
            WorldUtils.doEasyPlaceAction(mc);
        }
    }

    public static boolean handleEasyPlace(Minecraft mc) {
        if (Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && DataManager.getToolMode() != ToolMode.REBUILD) {
            ActionResultType result = WorldUtils.doEasyPlaceAction(mc);
            if (result == ActionResultType.FAIL) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
                return true;
            }
            return result != ActionResultType.PASS;
        }
        return false;
    }

    private static ActionResultType doEasyPlaceAction(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper traceWrapper;
        if (Configs.Generic.EASY_PLACE_FIRST.getBooleanValue()) {
            boolean targetFluids = Configs.InfoOverlays.INFO_OVERLAYS_TARGET_FLUIDS.getBooleanValue();
            traceWrapper = RayTraceUtils.getGenericTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0, true, targetFluids, false);
        } else {
            traceWrapper = RayTraceUtils.getFurthestSchematicWorldTraceBeforeVanilla((World)mc.field_71441_e, (Entity)mc.field_71439_g, 6.0);
        }
        if (traceWrapper == null) {
            return ActionResultType.PASS;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockRayTraceResult trace = traceWrapper.getBlockHitResult();
            RayTraceResult traceVanilla = RayTraceUtils.getRayTraceFromEntity((World)mc.field_71441_e, (Entity)mc.field_71439_g, false, 6.0);
            BlockPos pos = trace.func_216350_a();
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            BlockState stateSchematic = world.func_180495_p(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (WorldUtils.easyPlaceIsPositionCached(pos)) {
                return ActionResultType.FAIL;
            }
            if (!stack.func_190926_b()) {
                BlockState stateClient = mc.field_71441_e.func_180495_p(pos);
                if (stateSchematic == stateClient) {
                    return ActionResultType.FAIL;
                }
                if (WorldUtils.easyPlaceBlockChecksCancel(stateSchematic, stateClient, (PlayerEntity)mc.field_71439_g, traceVanilla, stack)) {
                    return ActionResultType.FAIL;
                }
                InventoryUtils.schematicWorldPickBlock(stack, pos, world, mc);
                Hand hand = EntityUtils.getUsedHandForItem((PlayerEntity)mc.field_71439_g, stack);
                if (hand == null) {
                    return ActionResultType.FAIL;
                }
                Vector3d hitPos = trace.func_216347_e();
                Direction sideOrig = trace.func_216354_b();
                if (traceVanilla != null && traceVanilla.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult hitResult = (BlockRayTraceResult)traceVanilla;
                    BlockPos posVanilla = hitResult.func_216350_a();
                    Direction sideVanilla = hitResult.func_216354_b();
                    BlockState stateVanilla = mc.field_71441_e.func_180495_p(posVanilla);
                    Vector3d hit = traceVanilla.func_216347_e();
                    BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext((PlayerEntity)mc.field_71439_g, hand, hitResult));
                    if (!stateVanilla.func_196953_a(ctx) && pos.equals((Object)(posVanilla = posVanilla.func_177972_a(sideVanilla)))) {
                        hitPos = hit;
                        sideOrig = sideVanilla;
                    }
                }
                Direction side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                hitPos = Configs.Generic.EASY_PLACE_PROTOCOL_V3.getBooleanValue() ? WorldUtils.applyPlacementProtocolV3(pos, stateSchematic, hitPos) : WorldUtils.applyCarpetProtocolHitVec(pos, stateSchematic, hitPos);
                WorldUtils.cacheEasyPlacePosition(pos);
                BlockRayTraceResult hitResult = new BlockRayTraceResult(hitPos, side, pos, false);
                mc.field_71442_b.func_217292_a(mc.field_71439_g, mc.field_71441_e, hand, hitResult);
                if (stateSchematic.func_177230_c() instanceof SlabBlock && stateSchematic.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.DOUBLE && (stateClient = mc.field_71441_e.func_180495_p(pos)).func_177230_c() instanceof SlabBlock && stateClient.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
                    side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                    hitResult = new BlockRayTraceResult(hitPos, side, pos, false);
                    mc.field_71442_b.func_217292_a(mc.field_71439_g, mc.field_71441_e, hand, hitResult);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
            return WorldUtils.placementRestrictionInEffect(mc) ? ActionResultType.FAIL : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    private static boolean easyPlaceBlockChecksCancel(BlockState stateSchematic, BlockState stateClient, PlayerEntity player, RayTraceResult trace, ItemStack stack) {
        Block blockClient;
        Block blockSchematic = stateSchematic.func_177230_c();
        if (blockSchematic instanceof SlabBlock && stateSchematic.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.DOUBLE && (blockClient = stateClient.func_177230_c()) instanceof SlabBlock && stateClient.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
            return blockSchematic != blockClient;
        }
        if (trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockRayTraceResult hitResult = (BlockRayTraceResult)trace;
        BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, hitResult));
        return !stateClient.func_196953_a(ctx);
    }

    public static Vector3d applyCarpetProtocolHitVec(BlockPos pos, BlockState state, Vector3d hitVecIn) {
        double x = hitVecIn.field_72450_a;
        double y = hitVecIn.field_72448_b;
        double z = hitVecIn.field_72449_c;
        Block block = state.func_177230_c();
        Direction facing = BlockUtils.getFirstPropertyFacingValue((BlockState)state);
        int propertyIncrement = 16;
        double relX = hitVecIn.field_72450_a - (double)pos.func_177958_n();
        if (facing != null) {
            x = (double)pos.func_177958_n() + relX + 2.0 + (double)(facing.func_176745_a() * 2);
        }
        if (block instanceof RepeaterBlock) {
            x += (double)(((Integer)state.func_177229_b((Property)RepeaterBlock.field_176410_b) - 1) * 16);
        } else if (block instanceof TrapDoorBlock && state.func_177229_b((Property)TrapDoorBlock.field_176285_M) == Half.TOP) {
            x += 16.0;
        } else if (block instanceof ComparatorBlock && state.func_177229_b((Property)ComparatorBlock.field_176463_b) == ComparatorMode.SUBTRACT) {
            x += 16.0;
        } else if (block instanceof StairsBlock && state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP) {
            x += 16.0;
        } else if (block instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
            y = state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.TOP ? (double)pos.func_177956_o() + 0.9 : (double)pos.func_177956_o();
        }
        return new Vector3d(x, y, z);
    }

    public static <T extends Comparable<T>> Vector3d applyPlacementProtocolV3(BlockPos pos, BlockState state, Vector3d hitVecIn) {
        Collection props = state.func_177230_c().func_176194_O().func_177623_d();
        if (props.isEmpty()) {
            return hitVecIn;
        }
        double relX = hitVecIn.field_72450_a - (double)pos.func_177958_n();
        int protocolValue = 0;
        int shiftAmount = 1;
        int propCount = 0;
        DirectionProperty property = BlockUtils.getFirstDirectionProperty((BlockState)state);
        if (property != null) {
            Direction direction = (Direction)state.func_177229_b((Property)property);
            protocolValue |= direction.func_176745_a() << shiftAmount;
            shiftAmount += 3;
            ++propCount;
        }
        ArrayList<Property> propList = new ArrayList<Property>(props);
        propList.sort(Comparator.comparing(Property::func_177701_a));
        try {
            for (Property p : propList) {
                if (p instanceof DirectionProperty || !PlacementHandler.WHITELISTED_PROPERTIES.contains((Object)p)) continue;
                Property prop = p;
                ArrayList list = new ArrayList(prop.func_177700_c());
                list.sort(Comparable::compareTo);
                int requiredBits = MathHelper.func_151239_c((int)MathHelper.func_151236_b((int)list.size()));
                int valueIndex = list.indexOf(state.func_177229_b(prop));
                if (valueIndex == -1) continue;
                protocolValue |= valueIndex << shiftAmount;
                shiftAmount += requiredBits;
                ++propCount;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Exception trying to request placement protocol value", (Throwable)e);
        }
        if (propCount > 0) {
            double x = (double)pos.func_177958_n() + relX + 2.0 + (double)protocolValue;
            return new Vector3d(x, hitVecIn.field_72448_b, hitVecIn.field_72449_c);
        }
        return hitVecIn;
    }

    private static Direction applyPlacementFacing(BlockState stateSchematic, Direction side, BlockState stateClient) {
        Block blockSchematic = stateSchematic.func_177230_c();
        Block blockClient = stateClient.func_177230_c();
        if (blockSchematic instanceof SlabBlock) {
            if (stateSchematic.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.DOUBLE && blockClient instanceof SlabBlock && stateClient.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
                if (stateClient.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.TOP) {
                    return Direction.DOWN;
                }
                return Direction.UP;
            }
            return Direction.NORTH;
        }
        return side;
    }

    public static boolean handlePlacementRestriction(Minecraft mc) {
        boolean cancel = WorldUtils.placementRestrictionInEffect(mc);
        if (cancel) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
        }
        return cancel;
    }

    private static boolean placementRestrictionInEffect(Minecraft mc) {
        RayTraceResult trace = mc.field_71476_x;
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (stack.func_190926_b()) {
            stack = mc.field_71439_g.func_184592_cb();
        }
        if (stack.func_190926_b()) {
            return false;
        }
        if (trace != null && trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockHitResult = (BlockRayTraceResult)trace;
            BlockPos pos = blockHitResult.func_216350_a();
            BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext((PlayerEntity)mc.field_71439_g, Hand.MAIN_HAND, blockHitResult));
            pos = ctx.func_195995_a();
            BlockState stateClient = mc.field_71441_e.func_180495_p(pos);
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            LayerRange range = DataManager.getRenderLayerRange();
            boolean schematicHasAir = worldSchematic.func_175623_d(pos);
            if (!schematicHasAir && !range.isPositionWithinRange(pos)) {
                return true;
            }
            if (schematicHasAir && WorldUtils.isPositionWithinRangeOfSchematicRegions(pos, 2)) {
                return true;
            }
            blockHitResult = new BlockRayTraceResult(blockHitResult.func_216347_e(), blockHitResult.func_216354_b(), pos, false);
            ctx = new BlockItemUseContext(new ItemUseContext((PlayerEntity)mc.field_71439_g, Hand.MAIN_HAND, (BlockRayTraceResult)trace));
            if (!stateClient.func_196953_a(ctx)) {
                return true;
            }
            BlockState stateSchematic = worldSchematic.func_180495_p(pos);
            stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (!stack.func_190926_b() && EntityUtils.getUsedHandForItem((PlayerEntity)mc.field_71439_g, stack) == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPositionWithinRangeOfSchematicRegions(BlockPos pos, int range) {
        SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
        int minCX = pos.func_177958_n() - range >> 4;
        int minCY = pos.func_177956_o() - range >> 4;
        int minCZ = pos.func_177952_p() - range >> 4;
        int maxCX = pos.func_177958_n() + range >> 4;
        int maxCY = pos.func_177956_o() + range >> 4;
        int maxCZ = pos.func_177952_p() + range >> 4;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int cy = minCY; cy <= maxCY; ++cy) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = minCX; cx <= maxCX; ++cx) {
                    List<IntBoundingBox> boxes = manager.getTouchedBoxesInSubChunk(new SubChunkPos(cx, cy, cz));
                    for (int i = 0; i < boxes.size(); ++i) {
                        IntBoundingBox box = boxes.get(i);
                        if (x < box.minX - range || x > box.maxX + range || y < box.minY - range || y > box.maxY + range || z < box.minZ - range || z > box.maxZ + range) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isSliceEmpty(World world, Direction.Axis axis, BlockPos pos1, BlockPos pos2) {
        BlockPos.Mutable posMutable = new BlockPos.Mutable();
        switch (axis) {
            case Z: {
                int x1 = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
                int x2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
                int y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
                int y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
                int z = pos1.func_177952_p();
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                for (int cx = cxMin; cx <= cxMax; ++cx) {
                    Chunk chunk = world.func_212866_a_(cx, z >> 4);
                    int xMin = Math.max(x1, cx << 4);
                    int xMax = Math.min(x2, (cx << 4) + 15);
                    int yMax = Math.min(y2, chunk.func_76625_h() + 15);
                    for (int x = xMin; x <= xMax; ++x) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.func_180495_p((BlockPos)posMutable.func_181079_c(x, y, z)).func_196958_f()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case Y: {
                int x1 = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
                int x2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
                int y = pos1.func_177956_o();
                int z1 = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
                int z2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    for (int cx = cxMin; cx <= cxMax; ++cx) {
                        Chunk chunk = world.func_212866_a_(cx, cz);
                        if (y > chunk.func_76625_h() + 15) continue;
                        int xMin = Math.max(x1, cx << 4);
                        int xMax = Math.min(x2, (cx << 4) + 15);
                        int zMin = Math.max(z1, cz << 4);
                        int zMax = Math.min(z2, (cz << 4) + 15);
                        for (int z = zMin; z <= zMax; ++z) {
                            for (int x = xMin; x <= xMax; ++x) {
                                if (chunk.func_180495_p((BlockPos)posMutable.func_181079_c(x, y, z)).func_196958_f()) continue;
                                return false;
                            }
                        }
                    }
                }
                break;
            }
            case X: {
                int x = pos1.func_177958_n();
                int z1 = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
                int z2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
                int y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
                int y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    Chunk chunk = world.func_212866_a_(x >> 4, cz);
                    int zMin = Math.max(z1, cz << 4);
                    int zMax = Math.min(z2, (cz << 4) + 15);
                    int yMax = Math.min(y2, chunk.func_76625_h() + 15);
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.func_180495_p((BlockPos)posMutable.func_181079_c(x, y, z)).func_196958_f()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    public static boolean easyPlaceIsPositionCached(BlockPos pos) {
        long currentTime = System.nanoTime();
        boolean cached = false;
        for (int i = 0; i < EASY_PLACE_POSITIONS.size(); ++i) {
            PositionCache val = EASY_PLACE_POSITIONS.get(i);
            boolean expired = val.hasExpired(currentTime);
            if (expired) {
                EASY_PLACE_POSITIONS.remove(i);
                --i;
                continue;
            }
            if (!val.getPos().equals((Object)pos)) continue;
            cached = true;
            if (EASY_PLACE_POSITIONS.size() < 16) break;
        }
        return cached;
    }

    private static void cacheEasyPlacePosition(BlockPos pos) {
        EASY_PLACE_POSITIONS.add(new PositionCache(pos, System.nanoTime(), 2000000000L));
    }

    public static class PositionCache {
        private final BlockPos pos;
        private final long time;
        private final long timeout;

        private PositionCache(BlockPos pos, long time, long timeout) {
            this.pos = pos;
            this.time = time;
            this.timeout = timeout;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public boolean hasExpired(long currentTime) {
            return currentTime - this.time > this.timeout;
        }
    }
}

