/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.WorldLightManager;

public class ChunkManagerSchematic
extends AbstractChunkProvider {
    private final WorldSchematic world;
    private final Long2ObjectMap<ChunkSchematic> loadedChunks = new Long2ObjectOpenHashMap(8192);
    private final ChunkSchematic blankChunk;
    private final WorldLightManager lightingProvider;

    public ChunkManagerSchematic(WorldSchematic world) {
        this.world = world;
        this.blankChunk = new ChunkSchematic(world, new ChunkPos(0, 0));
        this.lightingProvider = new WorldLightManager((IChunkLightProvider)this, true, world.func_230315_m_().func_218272_d());
    }

    public WorldSchematic getWorld() {
        return this.world;
    }

    public void loadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = new ChunkSchematic(this.world, new ChunkPos(chunkX, chunkZ));
        this.loadedChunks.put(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ), (Object)chunk);
    }

    public boolean func_73149_a(int chunkX, int chunkZ) {
        return this.loadedChunks.containsKey(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
    }

    public String func_73148_d() {
        return "Schematic Chunk Cache: " + this.getLoadedChunkCount();
    }

    public int getLoadedChunkCount() {
        return this.loadedChunks.size();
    }

    public Long2ObjectMap<ChunkSchematic> getLoadedChunks() {
        return this.loadedChunks;
    }

    public Chunk getChunk(int chunkX, int chunkZ, ChunkStatus status, boolean fallbackToEmpty) {
        ChunkSchematic chunk = this.getChunk(chunkX, chunkZ);
        return chunk == null && fallbackToEmpty ? this.blankChunk : chunk;
    }

    public ChunkSchematic getChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = (ChunkSchematic)((Object)this.loadedChunks.get(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ)));
        return chunk == null ? this.blankChunk : chunk;
    }

    public void unloadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = (ChunkSchematic)((Object)this.loadedChunks.remove(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ)));
        if (chunk != null) {
            this.world.unloadBlockEntities(chunk.func_177434_r().values());
            for (ClassInheritanceMultiMap list : chunk.func_177429_s()) {
                for (Entity entity : list.func_219790_a(Entity.class)) {
                    this.world.removeEntity(entity.func_145782_y());
                }
            }
        }
    }

    public WorldLightManager func_212863_j_() {
        return this.lightingProvider;
    }
}

