/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.world.PublicDimensionType;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.DefaultBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.storage.ISpawnWorldInfo;

public class SchematicWorldHandler {
    @Nullable
    private static WorldSchematic world;
    public static final DimensionType DIMENSIONTYPE;

    @Nullable
    public static WorldSchematic getSchematicWorld() {
        return world;
    }

    public static WorldSchematic createSchematicWorld() {
        ClientWorld.ClientWorldInfo levelInfo = new ClientWorld.ClientWorldInfo(Difficulty.PEACEFUL, false, true);
        return new WorldSchematic((ISpawnWorldInfo)levelInfo, DIMENSIONTYPE, () -> ((Minecraft)Minecraft.func_71410_x()).func_213239_aq());
    }

    public static void recreateSchematicWorld(boolean remove) {
        if (remove) {
            if (Configs.Generic.DEBUG_LOGGING.getBooleanValue()) {
                Litematica.logger.info("Removing the schematic world...");
            }
            world = null;
        } else {
            if (Configs.Generic.DEBUG_LOGGING.getBooleanValue()) {
                Litematica.logger.info("(Re-)creating the schematic world...");
            }
            world = SchematicWorldHandler.createSchematicWorld();
            if (Configs.Generic.DEBUG_LOGGING.getBooleanValue()) {
                Litematica.logger.info("Schematic world created: {}", (Object)world);
            }
        }
        LitematicaRenderer.getInstance().onSchematicWorldChanged(world);
    }

    static {
        DIMENSIONTYPE = new PublicDimensionType(OptionalLong.of(6000L), false, false, false, false, 1.0, false, false, false, false, true, 256, (IBiomeMagnifier)DefaultBiomeMagnifier.INSTANCE, BlockTags.field_241279_aE_.func_230234_a_(), DimensionType.field_242712_c, 0.0f);
    }
}

