/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.downloader.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.lib720.kiulian.downloader.base64.Base64Encoder;
import me.lib720.kiulian.downloader.downloader.request.Request;
import me.lib720.kiulian.downloader.model.search.SearchResult;
import me.lib720.kiulian.downloader.model.search.field.DurationField;
import me.lib720.kiulian.downloader.model.search.field.FeatureField;
import me.lib720.kiulian.downloader.model.search.field.FormatField;
import me.lib720.kiulian.downloader.model.search.field.SearchField;
import me.lib720.kiulian.downloader.model.search.field.SortField;
import me.lib720.kiulian.downloader.model.search.field.TypeField;
import me.lib720.kiulian.downloader.model.search.field.UploadDateField;

public class RequestSearchResult
extends Request<RequestSearchResult, SearchResult> {
    private static final byte[] FORCED_DATA = new byte[]{66, 2, 8, 1};
    private final String query;
    private boolean forceExactQuery;
    private Map<Integer, SearchField> filterFields = new HashMap<Integer, SearchField>();
    private SortField sortField;

    public RequestSearchResult(String query) {
        this.query = query;
    }

    public String encodeParameters() {
        if (this.sortField == null && this.filterFields.isEmpty() && !this.forceExactQuery) {
            return null;
        }
        int filterLength = 0;
        ArrayList<SearchField> filters = null;
        if (!this.filterFields.isEmpty()) {
            filters = new ArrayList<SearchField>(this.filterFields.values());
            filters.sort((f1, f2) -> f1.category() - f2.category());
            for (SearchField filter : filters) {
                filterLength += filter.length();
            }
        }
        int length = filterLength;
        if (this.sortField != null) {
            length += 2;
        }
        if (filters != null) {
            length += 2;
        }
        if (this.forceExactQuery) {
            length += FORCED_DATA.length;
        }
        byte[] bytes = new byte[length];
        int i = 0;
        if (this.sortField != null) {
            bytes[i++] = 8;
            bytes[i++] = this.sortField.value();
        }
        if (filters != null) {
            bytes[i++] = 18;
            bytes[i++] = (byte)filterLength;
            for (SearchField filter : filters) {
                System.arraycopy(filter.data(), 0, bytes, i, filter.length());
                i += filter.length();
            }
        }
        if (this.forceExactQuery) {
            System.arraycopy(FORCED_DATA, 0, bytes, i, FORCED_DATA.length);
        }
        String encoded = Base64Encoder.getInstance().encodeToString(bytes);
        return encoded.replace("=", "%253D");
    }

    public String query() {
        return this.query;
    }

    public RequestSearchResult forceExactQuery(boolean forceExactQuery) {
        this.forceExactQuery = forceExactQuery;
        return this;
    }

    public RequestSearchResult filter(SearchField ... field) {
        for (SearchField filter : field) {
            this.filterFields.put(filter.category(), filter);
        }
        return this;
    }

    public RequestSearchResult uploadedThis(UploadDateField uploadDateField) {
        this.put(uploadDateField);
        return this;
    }

    public RequestSearchResult type(TypeField typeField) {
        this.put(typeField);
        return this;
    }

    public RequestSearchResult during(DurationField durationField) {
        this.put(durationField);
        return this;
    }

    public RequestSearchResult match(FeatureField ... featuresField) {
        return this.filter(featuresField);
    }

    public RequestSearchResult format(FormatField ... formatsField) {
        return this.filter(formatsField);
    }

    public RequestSearchResult sortBy(SortField sortField) {
        this.sortField = sortField;
        return this;
    }

    private void put(SearchField field) {
        this.filterFields.put(field.category(), field);
    }
}

