/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.network.twitch;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StreamQuality
implements Comparable<StreamQuality> {
    private static final Pattern M3U8_STREAM_INF_RE = Pattern.compile("^#EXT-X-STREAM-INF:(.*)");
    private static final Pattern M3U8_INF_VALUE_RE = Pattern.compile("([A-Z-]+)=(?:([^,]+)|\"([^\"]+?)\")");
    private static final Pattern HTTP_URL_RE = Pattern.compile("https?://.*");
    private int bandwidth;
    private int width;
    private int height;
    private int framerate;
    private String codecs;
    private String url;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFramerate(int framerate) {
        this.framerate = framerate;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBandwidth(int bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setCodecs(String codecs) {
        this.codecs = codecs;
    }

    public void setResolution(String resolution) {
        String[] res = resolution.split("x");
        this.width = Integer.parseInt(res[0]);
        this.height = Integer.parseInt(res[1]);
    }

    public String getCodecs() {
        return this.codecs;
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFramerate() {
        return this.framerate;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return String.format("Bandwidth: %d, Resolution: %dx%d, Framerate: %d, Codecs: %s, URL: %s", this.bandwidth, this.width, this.height, this.framerate, this.codecs, this.url);
    }

    @Override
    public int compareTo(StreamQuality streamQuality) {
        int res = streamQuality.width - this.width;
        if (res == 0) {
            res = streamQuality.framerate - this.framerate;
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamQuality)) {
            return false;
        }
        StreamQuality that = (StreamQuality)o;
        return this.bandwidth == that.bandwidth && this.width == that.width && this.height == that.height && this.framerate == that.framerate && Objects.equals(this.codecs, that.codecs) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.bandwidth, this.width, this.height, this.framerate, this.codecs, this.url);
    }

    public static List<StreamQuality> parse(String playlistData) {
        String[] lines = playlistData.split("\n");
        ArrayList<StreamQuality> streamQualities = new ArrayList<StreamQuality>();
        StreamQuality currentQuality = null;
        for (String line : lines) {
            Matcher matcher = M3U8_STREAM_INF_RE.matcher(line);
            if (matcher.matches()) {
                String streamInformation = matcher.group(1);
                currentQuality = new StreamQuality();
                Matcher valueMatcher = M3U8_INF_VALUE_RE.matcher(streamInformation);
                while (valueMatcher.find()) {
                    String key = valueMatcher.group(1);
                    String value = valueMatcher.group(2);
                    if (value == null) {
                        value = valueMatcher.group(3);
                    }
                    switch (key) {
                        case "BANDWIDTH": {
                            currentQuality.setBandwidth((int)Float.parseFloat(value));
                            break;
                        }
                        case "RESOLUTION": {
                            currentQuality.setResolution(value);
                            break;
                        }
                        case "CODECS": {
                            currentQuality.setCodecs(value);
                            break;
                        }
                        case "FRAME-RATE": {
                            currentQuality.setFramerate((int)Float.parseFloat(value));
                        }
                    }
                }
                continue;
            }
            if (!HTTP_URL_RE.matcher(line).matches() || currentQuality == null) continue;
            currentQuality.setUrl(line);
            streamQualities.add(currentQuality);
            currentQuality = null;
        }
        streamQualities.sort((q1, q2) -> {
            int res = q2.width - q1.width;
            if (res == 0) {
                res = q2.framerate - q1.framerate;
            }
            return res;
        });
        return streamQualities;
    }
}

