/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.player;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lib720.apache.io.FileUtils;
import me.lib720.apache.io.file.PathUtils;
import me.lib720.apache.lang3.ArrayUtils;
import me.lib720.caprica.vlcj.discovery.NativeDiscovery;
import me.lib720.caprica.vlcj.discovery.strategy.NativeDiscoveryStrategy;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.srrapero720.watermedia.OperativeSystem;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.core.tools.IOTool;
import me.srrapero720.watermedia.core.tools.JarTool;
import me.srrapero720.watermedia.loaders.ILoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PlayerAPI
extends WaterMediaAPI {
    private static final Marker IT = MarkerManager.getMarker((String)PlayerAPI.class.getSimpleName());
    private static final NativeDiscovery DISCOVERY = new NativeDiscovery(new NativeDiscoveryStrategy[0]);
    public static final Map<String, MediaPlayerFactory> FACTORIES = new LinkedHashMap<String, MediaPlayerFactory>();
    private static MediaPlayerFactory DEFAULT_FACTORY;
    private static MediaPlayerFactory DEFAULT_SONG_FACTORY;
    private final Path dir;
    private final String zipInput;
    private final String configInput;
    private final File zipOutput;
    private final File configOutput;
    private final boolean wrapped;
    private boolean extract;

    public static boolean isReady() {
        return NativeDiscovery.alreadyFound;
    }

    public static MediaPlayerFactory getFactory() {
        return FACTORIES.get(WaterMedia.asResource("default"));
    }

    public static MediaPlayerFactory getFactorySoundOnly() {
        return FACTORIES.get(WaterMedia.asResource("sound_only"));
    }

    public static MediaPlayerFactory registerFactory(String resLoc, String[] vlcArgs) {
        if (DISCOVERY.discover()) {
            MediaPlayerFactory factory = new MediaPlayerFactory(DISCOVERY, vlcArgs);
            MediaPlayerFactory oldFactory = FACTORIES.put(resLoc, factory);
            WaterMedia.LOGGER.info(IT, "Created new VLC instance from '{}' with args: '{}'", (Object)DISCOVERY.discoveredPath(), (Object)Arrays.toString(vlcArgs));
            if (oldFactory != null) {
                WaterMedia.LOGGER.warn(IT, "Factory {} previously defined was overwritted", (Object)resLoc);
            }
            return factory;
        }
        WaterMedia.LOGGER.fatal(IT, "[VLC IS MISSING]: Cannot create MediaPlayerFactory instance");
        return null;
    }

    public static MediaPlayerFactory customFactory(String[] vlcArgs) {
        int fakeID = 0;
        while (FACTORIES.containsKey(WaterMedia.asResource("unidentified_" + fakeID))) {
            ++fakeID;
        }
        return PlayerAPI.registerFactory(WaterMedia.asResource("unidentified_" + fakeID), vlcArgs);
    }

    public PlayerAPI() {
        ILoader bootstrap = WaterMedia.getLoader();
        String zFilename = OperativeSystem.getFile();
        this.dir = bootstrap.tempDir().resolve("videolan");
        this.wrapped = zFilename != null;
        this.zipInput = "videolan/" + zFilename;
        this.configInput = "videolan/version.cfg";
        if (this.wrapped) {
            this.zipOutput = this.dir.resolve(zFilename).toFile();
            this.configOutput = this.dir.resolve("version.cfg").toFile();
        } else {
            this.configOutput = null;
            this.zipOutput = null;
        }
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.HIGH;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        WaterMedia.LOGGER.info(IT, "Binaries are {}", (Object)(this.wrapped ? "wrapped" : "not wrapped"));
        if (this.wrapped) {
            boolean versionMatch;
            String versionInJar = JarTool.readString(this.configInput);
            String versionInFile = IOTool.readString(this.configOutput.toPath());
            boolean bl = versionMatch = versionInFile != null && versionInFile.equalsIgnoreCase(versionInJar);
            if (!versionMatch) {
                this.extract = true;
                WaterMedia.LOGGER.info(IT, "Binaries not extracted, extraction scheduled");
                if (this.zipOutput.getParentFile().exists()) {
                    WaterMedia.LOGGER.warn(IT, "Detected an old installation, cleaning up...");
                    try {
                        FileUtils.deleteDirectory(this.zipOutput.getParentFile());
                    }
                    catch (Exception e) {
                        WaterMedia.LOGGER.error(IT, "Failed to delete directories", (Throwable)e);
                    }
                    WaterMedia.LOGGER.warn(IT, "Cleaning up successfully");
                }
            } else {
                WaterMedia.LOGGER.warn(IT, "VLC binaries extraction skipped. Extracted version match with wrapped version");
            }
        } else {
            WaterMedia.LOGGER.warn(IT, "[NOT A BUG] {} doesn't contains VLC binaries for your OS and ARCH, you had to download it manually from 'https://www.videolan.org/vlc/'", (Object)"WATERMeDIA");
        }
        return true;
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
        if (this.extract) {
            WaterMedia.LOGGER.info(IT, "Extracting VideoLAN binaries...");
            if (!this.zipOutput.exists() && JarTool.copyAsset(this.zipInput, this.zipOutput.toPath()) || this.zipOutput.exists()) {
                IOTool.un7zip(IT, this.zipOutput.toPath());
                if (!this.zipOutput.delete()) {
                    WaterMedia.LOGGER.error(IT, "Failed to delete binaries zip file...");
                }
                JarTool.copyAsset(this.configInput, this.configOutput.toPath());
                WaterMedia.LOGGER.info(IT, "VideoLAN binaries extracted successfully");
            } else {
                WaterMedia.LOGGER.error(IT, "Failed to extract VideoLAN binaries");
            }
        }
        WaterMedia.LOGGER.info(IT, "Processing VideoLAN log files...");
        if (Files.exists(this.dir.resolve("logs/videolan.log"), new LinkOption[0])) {
            Path parent = this.dir.resolve("logs");
            try {
                PathUtils.deleteDirectory(parent);
            }
            catch (IOException e) {
                WaterMedia.LOGGER.warn(IT, "Failed to delete VLC logs directory", (Throwable)e);
            }
        }
        try {
            String[] args = JarTool.readArray("videolan/arguments.json");
            PlayerAPI.registerFactory(WaterMedia.asResource("default"), args);
            PlayerAPI.registerFactory(WaterMedia.asResource("sound_only"), ArrayUtils.addAll(args, "--vout=none"));
            Runtime.getRuntime().addShutdownHook(new Thread(this::release));
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to load VLC", (Throwable)e);
        }
    }

    @Override
    public void release() {
        FACTORIES.forEach((s, mediaPlayerFactory) -> mediaPlayerFactory.release());
        FACTORIES.clear();
    }
}

