/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import java.net.URL;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;

public class DropboxFixer
extends URLFixer {
    @Override
    public String platform() {
        return "Dropbox";
    }

    @Override
    public boolean isValid(URL url) {
        String q;
        return url.getHost().contains("dropbox.com") && (q = url.getQuery()) != null && q.contains("dl=0");
    }

    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality preferQuality) throws URLFixer.FixingURLException {
        super.patch(url, preferQuality);
        try {
            return new URLFixer.Result(new URL(url.toString().replace("dl=0", "dl=1")), false, false);
        }
        catch (Exception e) {
            throw new URLFixer.FixingURLException(url, (Throwable)e);
        }
    }
}

