/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compat;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import java.util.Collection;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.embeddedt.embeddium.api.ChunkDataBuiltEvent;

@Mod.EventBusSubscriber(modid="embeddium", value={Dist.CLIENT})
public class FlywheelCompat {
    private static final boolean flywheelLoaded = ModList.get().isLoaded("flywheel");

    public static void filterBlockEntityList(Collection<TileEntity> blockEntities) {
        if (flywheelLoaded && Backend.getInstance().canUseInstancing()) {
            InstancedRenderRegistry r = InstancedRenderRegistry.getInstance();
            blockEntities.removeIf(arg_0 -> ((InstancedRenderRegistry)r).shouldSkipRender(arg_0));
        }
    }

    public static boolean isSkipped(TileEntity be) {
        if (!flywheelLoaded) {
            return false;
        }
        if (!Backend.getInstance().canUseInstancing()) {
            return false;
        }
        return InstancedRenderRegistry.getInstance().shouldSkipRender(be);
    }

    @SubscribeEvent
    public static void onChunkDataBuilt(ChunkDataBuiltEvent event) {
        if (flywheelLoaded) {
            event.getDataBuilder().removeBlockEntitiesIf(FlywheelCompat::isSkipped);
        }
    }
}

