/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compat.forge;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.ForgeConfig;

public class ForgeBlockRenderer {
    private static boolean useForgeLightingPipeline = false;
    private static BlockModelRenderer forgeRenderer;

    public static void init() {
        useForgeLightingPipeline = (Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get();
        forgeRenderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
    }

    public static boolean useForgeLightingPipeline() {
        return useForgeLightingPipeline;
    }

    private boolean markQuads(ChunkRenderData.Builder renderData, List<BakedQuad> quads) {
        if (quads.isEmpty()) {
            return true;
        }
        for (int i = 0; i < quads.size(); ++i) {
            ModelQuadView src = (ModelQuadView)quads.get(i);
            TextureAtlasSprite sprite = src.rubidium$getSprite();
            if (sprite == null) continue;
            renderData.addSprite(sprite);
        }
        return false;
    }

    public boolean renderBlock(LightMode mode, BlockState state, BlockPos pos, IBlockDisplayReader world, IBakedModel model, MatrixStack stack, IVertexBuilder buffer, Random random, long seed, IModelData data, boolean checkSides, BlockOcclusionCache sideCache, ChunkRenderData.Builder renderData) {
        if (mode == LightMode.FLAT) {
            forgeRenderer.renderModelFlat(world, model, state, pos, stack, buffer, checkSides, random, seed, OverlayTexture.field_229196_a_, data);
        } else {
            forgeRenderer.renderModelSmooth(world, model, state, pos, stack, buffer, checkSides, random, seed, OverlayTexture.field_229196_a_, data);
        }
        random.setSeed(seed);
        boolean empty = this.markQuads(renderData, model.getQuads(state, null, random, data));
        for (Direction side : DirectionUtil.ALL_DIRECTIONS) {
            random.setSeed(seed);
            empty = this.markQuads(renderData, model.getQuads(state, side, random, data));
        }
        return !empty;
    }
}

