/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.compat.modernui.MuiGuiScaleHook;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.binding.compat.VanillaBooleanOptionBinding;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.renderDistance")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.view_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.quantity("options.chunks"))).setBinding((options, value) -> {
            options.field_151451_c = value;
        }, options -> options.field_151451_c).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.gamma")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.brightness.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.field_74333_Y = (double)value.intValue() * 0.01;
        }, opts -> (int)(opts.field_74333_Y / 0.01)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.clouds.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.clouds.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            Framebuffer framebuffer;
            opts.quality.enableClouds = value;
            if (Minecraft.func_238218_y_() && (framebuffer = Minecraft.func_71410_x().field_71438_f.func_239232_u_()) != null) {
                framebuffer.func_216493_b(Minecraft.field_142025_a);
            }
        }, opts -> opts.quality.enableClouds).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.guiScale")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.gui_scale.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, MuiGuiScaleHook.getMaxGuiScale(), 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.field_74335_Z = value;
            Minecraft client = Minecraft.func_71410_x();
            client.func_213226_a();
        }, opts -> opts.field_74335_Z).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.fullscreen")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.fullscreen.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74353_u = value;
            Minecraft client = Minecraft.func_71410_x();
            MainWindow window = client.func_228018_at_();
            if (window != null && window.func_198113_j() != opts.field_74353_u) {
                window.func_198077_g();
                opts.field_74353_u = window.func_198113_j();
            }
        }, opts -> opts.field_74353_u).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.vsync")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.v_sync.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding(AbstractOption.field_216682_F)).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.framerateLimit")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.fps_limit.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 5, 260, 5, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.field_74350_i = value;
            Minecraft.func_71410_x().func_228018_at_().func_216526_a(value.intValue());
        }, opts -> opts.field_74350_i).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.viewBobbing")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.view_bobbing.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding(AbstractOption.field_216692_P)).build()).add(OptionImpl.createBuilder(AttackIndicatorStatus.class, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.attackIndicator")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.attack_indicator.tooltip")).setControl(opts -> new CyclingControl<AttackIndicatorStatus>((Option<AttackIndicatorStatus>)opts, AttackIndicatorStatus.class, new ITextComponent[]{new TranslationTextComponent("options.off"), new TranslationTextComponent("options.attack.crosshair"), new TranslationTextComponent("options.attack.hotbar")})).setBinding((opts, value) -> {
            opts.field_186716_M = value;
        }, opts -> opts.field_186716_M).build()).build());
        return new OptionPage((ITextComponent)new TranslationTextComponent("stat.generalButton"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsFanciness.class, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.graphics")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.graphics_quality.tooltip")).setControl(option -> new CyclingControl<GraphicsFanciness>((Option<GraphicsFanciness>)option, GraphicsFanciness.class, new ITextComponent[]{new TranslationTextComponent("options.graphics.fast"), new TranslationTextComponent("options.graphics.fancy"), new TranslationTextComponent("options.graphics.fabulous")})).setBinding((opts, value) -> {
            opts.field_238330_f_ = value;
        }, opts -> opts.field_238330_f_).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("options.renderClouds")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.clouds_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.cloudQuality = value;
        }, opts -> opts.quality.cloudQuality).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("soundCategory.weather")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.weather_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.leaves_quality.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.leaves_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.leavesQuality = value;
        }, opts -> opts.quality.leavesQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(ParticleStatus.class, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.particles")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.particle_quality.tooltip")).setControl(opt -> new CyclingControl<ParticleStatus>((Option<ParticleStatus>)opt, ParticleStatus.class, new ITextComponent[]{new TranslationTextComponent("options.particles.all"), new TranslationTextComponent("options.particles.decreased"), new TranslationTextComponent("options.particles.minimal")})).setBinding((opts, value) -> {
            opts.field_74362_aa = value;
        }, opts -> opts.field_74362_aa).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.LightingQuality.class, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("options.ao")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.smooth_lighting.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.LightingQuality>((Option<SodiumGameOptions.LightingQuality>)option, SodiumGameOptions.LightingQuality.class)).setBinding((opts, value) -> {
            opts.quality.smoothLighting = value;
        }, opts -> opts.quality.smoothLighting).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.biomeBlendRadius")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.biome_blend.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 7, 1, ControlValueFormatter.quantityOrDisabled("sodium.options.biome_blend.value", "gui.none"))).setBinding((opts, value) -> {
            opts.field_205217_U = value;
        }, opts -> opts.field_205217_U).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.entityDistanceScaling")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.entity_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> {
            opts.field_238329_c_ = (float)value.intValue() / 100.0f;
        }, opts -> Math.round(opts.field_238329_c_ * 100.0f)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.entityShadows")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.entity_shadows.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_181151_V = value;
        }, opts -> opts.field_181151_V).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.vignette.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.vignette.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TranslationTextComponent("options.mipmapLevels")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.mipmap_levels.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.field_151442_I = value;
        }, opts -> opts.field_151442_I).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage((ITextComponent)new TranslationTextComponent("sodium.options.pages.quality"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.use_chunk_multidraw.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.use_chunk_multidraw.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useChunkMultidraw = value;
        }, opts -> opts.advanced.useChunkMultidraw).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.EXTREME).setEnabled(MultidrawChunkRenderBackend.isSupported(SodiumGameOptionPages.sodiumOpts.getData().advanced.ignoreDriverBlacklist)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.use_vertex_objects.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.use_vertex_objects.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useVertexArrayObjects = value;
        }, opts -> opts.advanced.useVertexArrayObjects).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.use_block_face_culling.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.use_block_face_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useBlockFaceCulling = value;
        }, opts -> opts.advanced.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.use_compact_vertex_format.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.use_compact_vertex_format.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useCompactVertexFormat = value;
        }, opts -> opts.advanced.useCompactVertexFormat).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.use_fog_occlusion.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.use_fog_occlusion.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useFogOcclusion = value;
        }, opts -> opts.advanced.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.translucency_sorting.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.translucency_sorting.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.translucencySorting = value;
        }, opts -> opts.advanced.translucencySorting).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.use_entity_culling.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.use_entity_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useEntityCulling = value;
        }, opts -> opts.advanced.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.animate_only_visible_textures.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.animate_only_visible_textures.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.animateOnlyVisibleTextures = value;
        }, opts -> opts.advanced.animateOnlyVisibleTextures).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.allow_direct_memory_access.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.allow_direct_memory_access.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.allowDirectMemoryAccess = value;
        }, opts -> opts.advanced.allowDirectMemoryAccess).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.ignore_driver_blacklist.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.ignore_driver_blacklist.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.ignoreDriverBlacklist = value;
        }, opts -> opts.advanced.ignoreDriverBlacklist).build()).build());
        return new OptionPage((ITextComponent)new TranslationTextComponent("sodium.options.pages.advanced"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage performance() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.chunk_update_threads.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.chunk_update_threads.tooltip")).setControl(o -> new SliderControl((Option<Integer>)o, 0, ChunkBuilder.getMaxThreadCount(), 1, ControlValueFormatter.quantityOrDisabled("sodium.options.threads.value", "sodium.options.default"))).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.chunkBuilderThreads = value;
        }, opts -> opts.performance.chunkBuilderThreads).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TranslationTextComponent("sodium.options.always_defer_chunk_updates.name")).setTooltip((ITextComponent)new TranslationTextComponent("sodium.options.always_defer_chunk_updates.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.alwaysDeferChunkUpdates = value;
        }, opts -> opts.performance.alwaysDeferChunkUpdates).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        return new OptionPage((ITextComponent)new TranslationTextComponent("sodium.options.pages.performance"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

