/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.properties;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.Direction;

public class ModelQuadFlags {
    public static final int IS_PARTIAL = 1;
    public static final int IS_PARALLEL = 2;
    public static final int IS_ALIGNED = 4;

    public static boolean contains(int flags, int mask) {
        return (flags & mask) != 0;
    }

    public static int getQuadFlags(BakedQuad bakedQuad) {
        ModelQuadView quad = (ModelQuadView)bakedQuad;
        Direction face = bakedQuad.func_178210_d();
        float minX = 32.0f;
        float minY = 32.0f;
        float minZ = 32.0f;
        float maxX = -32.0f;
        float maxY = -32.0f;
        float maxZ = -32.0f;
        int numVertices = Math.min(4, bakedQuad.func_178209_a().length / 8);
        for (int i = 0; i < numVertices; ++i) {
            float x = quad.getX(i);
            float y = quad.getY(i);
            float z = quad.getZ(i);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        boolean partial = false;
        switch (face.func_176740_k()) {
            case X: {
                partial = minY >= 1.0E-4f || minZ >= 1.0E-4f || maxY <= 0.9999f || maxZ <= 0.9999f;
                break;
            }
            case Y: {
                partial = minX >= 1.0E-4f || minZ >= 1.0E-4f || maxX <= 0.9999f || maxZ <= 0.9999f;
                break;
            }
            case Z: {
                partial = minX >= 1.0E-4f || minY >= 1.0E-4f || maxX <= 0.9999f || maxY <= 0.9999f;
            }
        }
        boolean parallel = false;
        switch (face.func_176740_k()) {
            case X: {
                parallel = minX == maxX;
                break;
            }
            case Y: {
                parallel = minY == maxY;
                break;
            }
            case Z: {
                parallel = minZ == maxZ;
            }
        }
        boolean aligned = false;
        boolean flag = false;
        switch (face) {
            case DOWN: {
                flag = minY < 1.0E-4f;
                break;
            }
            case UP: {
                flag = maxY > 0.9999f;
                break;
            }
            case NORTH: {
                flag = minZ < 1.0E-4f;
                break;
            }
            case SOUTH: {
                flag = maxZ > 0.9999f;
                break;
            }
            case WEST: {
                flag = minX < 1.0E-4f;
                break;
            }
            case EAST: {
                flag = maxX > 0.9999f;
            }
        }
        aligned = parallel && flag;
        int flags = 0;
        if (partial) {
            flags |= 1;
        }
        if (parallel) {
            flags |= 2;
        }
        if (aligned) {
            flags |= 4;
        }
        return flags;
    }
}

