/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.data;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.minecraft.client.renderer.chunk.SetVisibility;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public class ChunkRenderData {
    public static final ChunkRenderData ABSENT = new Builder().build();
    public static final ChunkRenderData EMPTY = ChunkRenderData.createEmptyData();
    private Set<TileEntity> globalBlockEntities;
    private List<TileEntity> blockEntities;
    private EnumMap<BlockRenderPass, ChunkMeshData> meshes;
    private SetVisibility occlusionData;
    private ChunkRenderBounds bounds;
    private List<TextureAtlasSprite> animatedSprites;
    private boolean isEmpty;
    private int meshByteSize;
    private int facesWithData;

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public ChunkRenderBounds getBounds() {
        return this.bounds;
    }

    public SetVisibility getOcclusionData() {
        return this.occlusionData;
    }

    public List<TextureAtlasSprite> getAnimatedSprites() {
        return this.animatedSprites;
    }

    public Collection<TileEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public Collection<TileEntity> getGlobalBlockEntities() {
        return this.globalBlockEntities;
    }

    public ChunkMeshData getMesh(BlockRenderPass pass) {
        return this.meshes.get((Object)pass);
    }

    public void setMesh(BlockRenderPass pass, ChunkMeshData data) {
        if (this.meshes.get((Object)pass) == null) {
            throw new IllegalStateException("No mesh found");
        }
        this.meshes.put(pass, data);
    }

    public int getMeshSize() {
        return this.meshByteSize;
    }

    public int getFacesWithData() {
        return this.facesWithData;
    }

    public ChunkRenderData copyAndReplaceMesh(Map<BlockRenderPass, ChunkMeshData> replacements) {
        ChunkRenderData data = new ChunkRenderData();
        data.globalBlockEntities = this.globalBlockEntities;
        data.blockEntities = this.blockEntities;
        data.occlusionData = this.occlusionData;
        data.meshes = new EnumMap<BlockRenderPass, ChunkMeshData>(this.meshes);
        data.bounds = this.bounds;
        data.animatedSprites = new ObjectArrayList(this.animatedSprites);
        data.meshes.putAll(replacements);
        int facesWithData = 0;
        int size = 0;
        for (ChunkMeshData meshData : this.meshes.values()) {
            size += meshData.getVertexDataSize();
            for (Map.Entry<ModelQuadFacing, BufferSlice> entry : meshData.getSlices()) {
                facesWithData |= 1 << entry.getKey().ordinal();
            }
        }
        data.isEmpty = this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty() && facesWithData == 0;
        data.meshByteSize = size;
        data.facesWithData = facesWithData;
        return data;
    }

    private static ChunkRenderData createEmptyData() {
        SetVisibility occlusionData = new SetVisibility();
        occlusionData.func_178620_a(EnumSet.allOf(Direction.class));
        Builder meshInfo = new Builder();
        meshInfo.setOcclusionData(occlusionData);
        return meshInfo.build();
    }

    public static class Builder {
        private final List<TileEntity> globalBlockEntities = new ArrayList<TileEntity>();
        private final List<TileEntity> blockEntities = new ArrayList<TileEntity>();
        private final Set<TextureAtlasSprite> animatedSprites = new ObjectOpenHashSet();
        private final EnumMap<BlockRenderPass, ChunkMeshData> meshes = new EnumMap(BlockRenderPass.class);
        private SetVisibility occlusionData;
        private ChunkRenderBounds bounds = ChunkRenderBounds.ALWAYS_FALSE;

        public Builder() {
            for (BlockRenderPass pass : BlockRenderPass.VALUES) {
                this.setMesh(pass, ChunkMeshData.EMPTY);
            }
        }

        public void setBounds(ChunkRenderBounds bounds) {
            this.bounds = bounds;
        }

        public void setOcclusionData(SetVisibility data) {
            this.occlusionData = data;
        }

        public void addSprite(TextureAtlasSprite sprite) {
            if (sprite.func_130098_m()) {
                this.animatedSprites.add(sprite);
            }
        }

        public void setMesh(BlockRenderPass pass, ChunkMeshData data) {
            this.meshes.put(pass, data);
        }

        public void addBlockEntity(TileEntity entity, boolean cull) {
            (cull ? this.blockEntities : this.globalBlockEntities).add(entity);
        }

        public void removeBlockEntitiesIf(Predicate<TileEntity> removePredicate) {
            this.blockEntities.removeIf(removePredicate);
            this.globalBlockEntities.removeIf(removePredicate);
        }

        public ChunkRenderData build() {
            ChunkRenderData data = new ChunkRenderData();
            data.globalBlockEntities = (Set)new ObjectOpenHashSet(this.globalBlockEntities);
            data.blockEntities = this.blockEntities;
            data.occlusionData = this.occlusionData;
            data.meshes = this.meshes;
            data.bounds = this.bounds;
            data.animatedSprites = (List)new ObjectArrayList(this.animatedSprites);
            int facesWithData = 0;
            int size = 0;
            for (ChunkMeshData meshData : this.meshes.values()) {
                size += meshData.getVertexDataSize();
                for (Map.Entry<ModelQuadFacing, BufferSlice> entry : meshData.getSlices()) {
                    facesWithData |= 1 << entry.getKey().ordinal();
                }
            }
            data.isEmpty = this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty() && facesWithData == 0;
            data.meshByteSize = size;
            data.facesWithData = facesWithData;
            return data;
        }
    }
}

