/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import java.util.Map;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.embeddedt.embeddium.api.ChunkDataBuiltEvent;
import org.embeddedt.embeddium.model.ModelDataSnapshotter;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private final ChunkRenderContainer<T> render;
    private final BlockPos offset;
    private final ChunkRenderContext context;
    private final Map<BlockPos, IModelData> modelDataMap;
    private Vector3d camera;
    private final boolean translucencySorting;

    public ChunkRenderRebuildTask(ChunkRenderContainer<T> render, ChunkRenderContext context, BlockPos offset) {
        this.render = render;
        this.offset = offset;
        this.context = context;
        this.camera = Vector3d.field_186680_a;
        this.translucencySorting = SodiumClientMod.options().advanced.translucencySorting;
        this.modelDataMap = ModelDataSnapshotter.getModelDataForSection(Minecraft.func_71410_x().field_71441_e, this.context.getOrigin());
    }

    public ChunkRenderRebuildTask<T> withCameraPosition(Vector3d camera) {
        this.camera = camera;
        return this;
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        VisGraph occluder = new VisGraph();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        buffers.init(renderData);
        cache.init(this.context);
        WorldSlice slice = cache.getWorldSlice();
        int baseX = this.render.getOriginX();
        int baseY = this.render.getOriginY();
        int baseZ = this.render.getOriginZ();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockPos renderOffset = this.offset;
        try {
            for (int relY = 0; relY < 16; ++relY) {
                if (cancellationSource.isCancelled()) {
                    return null;
                }
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relX = 0; relX < 16; ++relX) {
                        TileEntityRenderer renderer;
                        TileEntity entity;
                        FluidState fluidState;
                        BlockState blockState = slice.getBlockStateRelative(relX + 16, relY + 16, relZ + 16);
                        if (blockState.func_177230_c() == Blocks.field_150350_a || blockState.func_177230_c() == Blocks.field_201941_jj) continue;
                        pos.func_181079_c(baseX + relX, baseY + relY, baseZ + relZ);
                        buffers.setRenderOffset(pos.func_177958_n() - renderOffset.func_177958_n(), pos.func_177956_o() - renderOffset.func_177956_o(), pos.func_177952_p() - renderOffset.func_177952_p());
                        if (blockState.func_185901_i() == BlockRenderType.MODEL) {
                            for (RenderType layer : cache.getRenderLayerCache().forState(blockState)) {
                                ForgeHooksClient.setRenderLayer((RenderType)layer);
                                IModelData modelData = this.modelDataMap.getOrDefault(pos, (IModelData)EmptyModelData.INSTANCE);
                                IBakedModel model = cache.getBlockModels().func_178125_b(blockState);
                                long seed = blockState.func_209533_a((BlockPos)pos);
                                if (!cache.getBlockRenderer().renderModel(cache.getLocalSlice(), blockState, (BlockPos)pos, model, buffers.get(layer), true, seed, modelData)) continue;
                                bounds.addBlock(relX, relY, relZ);
                            }
                        }
                        if (!(fluidState = blockState.func_204520_s()).func_206888_e()) {
                            RenderType layer;
                            layer = cache.getRenderLayerCache().forState(fluidState).iterator();
                            while (layer.hasNext()) {
                                RenderType layer2 = (RenderType)layer.next();
                                ForgeHooksClient.setRenderLayer((RenderType)layer2);
                                if (!cache.getFluidRenderer().render(cache.getLocalSlice(), fluidState, (BlockPos)pos, buffers.get(layer2))) continue;
                                bounds.addBlock(relX, relY, relZ);
                            }
                        }
                        if (blockState.hasTileEntity() && (entity = slice.func_175625_s((BlockPos)pos)) != null && (renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(entity)) != null) {
                            renderData.addBlockEntity(entity, !renderer.func_188185_a(entity));
                            bounds.addBlock(relX, relY, relZ);
                        }
                        if (!blockState.func_200015_d((IBlockReader)slice, (BlockPos)pos)) continue;
                        occluder.func_178606_a((BlockPos)pos);
                    }
                }
            }
        }
        catch (ReportedException ex) {
            throw this.fillCrashInfo(ex.func_71575_a(), slice, (BlockPos)pos);
        }
        catch (Throwable ex) {
            throw this.fillCrashInfo(CrashReport.func_85055_a((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (BlockPos)pos);
        }
        ForgeHooksClient.setRenderLayer(null);
        this.render.setRebuildForTranslucents(false);
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass, (float)this.camera.field_72450_a - (float)this.offset.func_177958_n(), (float)this.camera.field_72448_b - (float)this.offset.func_177956_o(), (float)this.camera.field_72449_c - (float)this.offset.func_177952_p(), this.translucencySorting);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
            if (!this.translucencySorting || !pass.isTranslucent()) continue;
            this.render.setRebuildForTranslucents(true);
        }
        renderData.setOcclusionData(occluder.func_178607_a());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        ChunkDataBuiltEvent.BUS.post(new ChunkDataBuiltEvent(renderData));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    private ReportedException fillCrashInfo(CrashReport report, WorldSlice slice, BlockPos pos) {
        CrashReportCategory crashReportSection = report.func_85057_a("Block being rendered", 1);
        BlockState state = null;
        try {
            state = slice.func_180495_p(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrashReportCategory.func_175750_a((CrashReportCategory)crashReportSection, (BlockPos)pos, (BlockState)state);
        crashReportSection.func_71507_a("Chunk section", this.render);
        if (this.context != null) {
            crashReportSection.func_71507_a("Render context volume", (Object)this.context.getVolume());
        }
        return new ReportedException(report);
    }

    @Override
    public void releaseResources() {
        this.context.releaseResources();
    }
}

