/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.compat.ccl.SinkingVertexBuilder;
import me.jellysquid.mods.sodium.client.compat.forge.ForgeBlockRenderer;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import org.embeddedt.embeddium.api.BlockRendererRegistry;

public class BlockRenderer {
    private static final int[] DEFAULT_QUAD_COLORS = new int[]{-1, -1, -1, -1};
    private static final MatrixStack EMPTY_STACK = new MatrixStack();
    private final Random random = new XoRoShiRoRandom();
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final ForgeBlockRenderer forgeBlockRenderer = new ForgeBlockRenderer();
    private final BiomeColorBlender biomeColorBlender;
    private final LightPipelineProvider lighters;
    private final boolean useAmbientOcclusion;
    private final List<BlockRendererRegistry.Renderer> customRenderers = new ObjectArrayList();
    private final SinkingVertexBuilder sinkingVertexBuilder = new SinkingVertexBuilder();

    public BlockRenderer(Minecraft client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        this.blockColors = (BlockColorsExtended)client.func_184125_al();
        this.biomeColorBlender = biomeColorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = Minecraft.func_71379_u();
    }

    public boolean renderModel(IBlockDisplayReader world, BlockState state, BlockPos pos, IBakedModel model, ChunkModelBuffers buffers, boolean cull, long seed, IModelData modelData) {
        LightMode mode = this.getLightingMode(state, model, world, pos);
        LightPipeline lighter = this.lighters.getLighter(mode);
        Vector3d offset = state.func_191059_e((IBlockReader)world, pos);
        boolean rendered = false;
        modelData = model.getModelData(world, pos, state, modelData);
        this.customRenderers.clear();
        BlockRendererRegistry.instance().fillCustomRenderers(this.customRenderers, state, pos, world);
        if (!this.customRenderers.isEmpty()) {
            for (BlockRendererRegistry.Renderer customRenderer : this.customRenderers) {
                this.sinkingVertexBuilder.reset();
                BlockRendererRegistry.RenderResult result = customRenderer.renderBlock(state, pos, world, this.sinkingVertexBuilder, this.random, modelData);
                this.sinkingVertexBuilder.flush(buffers);
                if (result != BlockRendererRegistry.RenderResult.OVERRIDE) continue;
                return true;
            }
        }
        if (ForgeBlockRenderer.useForgeLightingPipeline()) {
            MatrixStack mStack;
            if (offset != Vector3d.field_186680_a) {
                mStack = new MatrixStack();
                mStack.func_227860_a_();
                mStack.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            } else {
                mStack = EMPTY_STACK;
            }
            this.sinkingVertexBuilder.reset();
            rendered = this.forgeBlockRenderer.renderBlock(mode, state, pos, world, model, mStack, this.sinkingVertexBuilder, this.random, seed, modelData, cull, this.occlusionCache, buffers.getRenderData());
            this.sinkingVertexBuilder.flush(buffers);
            return rendered;
        }
        for (MatrixStack dir : DirectionUtil.ALL_DIRECTIONS) {
            this.random.setSeed(seed);
            List sided = model.getQuads(state, (Direction)dir, this.random, modelData);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (IBlockReader)world, pos, (Direction)dir)) continue;
            this.renderQuadList(world, state, pos, lighter, offset, buffers, sided, (Direction)dir);
            rendered = true;
        }
        this.random.setSeed(seed);
        List all = model.getQuads(state, null, this.random, modelData);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, lighter, offset, buffers, all, null);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadList(IBlockDisplayReader world, BlockState state, BlockPos pos, LightPipeline lighter, Vector3d offset, ChunkModelBuffers buffers, List<BakedQuad> quads, Direction cullFace) {
        ModelQuadFacing facing = cullFace == null ? ModelQuadFacing.UNASSIGNED : ModelQuadFacing.fromDirection(cullFace);
        IBlockColor colorizer = null;
        ModelVertexSink sink = buffers.getSink(facing);
        sink.ensureCapacity(quads.size() * 4);
        ChunkRenderData.Builder renderData = buffers.getRenderData();
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuad quad = quads.get(i);
            QuadLightData light = this.cachedQuadLightData;
            lighter.calculate((ModelQuadView)quad, pos, light, cullFace, quad.func_178210_d(), quad.func_239287_f_());
            if (quad.func_178212_b() && colorizer == null) {
                colorizer = this.blockColors.getColorProvider(state);
            }
            this.renderQuad(world, state, pos, sink, offset, colorizer, quad, light, renderData);
        }
        sink.flush();
    }

    private void renderQuad(IBlockDisplayReader world, BlockState state, BlockPos pos, ModelVertexSink sink, Vector3d offset, IBlockColor colorProvider, BakedQuad bakedQuad, QuadLightData light, ChunkRenderData.Builder renderData) {
        ModelQuadView src = (ModelQuadView)bakedQuad;
        ModelQuadOrientation order = ModelQuadOrientation.orient(light.br);
        int[] colors = bakedQuad.func_178212_b() ? this.biomeColorBlender.getColors(colorProvider, world, state, pos, src) : DEFAULT_QUAD_COLORS;
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = order.getVertexIndex(dstIndex);
            float x = src.getX(srcIndex) + (float)offset.func_82615_a();
            float y = src.getY(srcIndex) + (float)offset.func_82617_b();
            float z = src.getZ(srcIndex) + (float)offset.func_82616_c();
            int color = ColorABGR.mul(ModelQuadUtil.mixABGRColors(colors[srcIndex], src.getColor(srcIndex)), light.br[srcIndex]);
            float u = src.getTexU(srcIndex);
            float v = src.getTexV(srcIndex);
            int lm = ModelQuadUtil.mergeBakedLight(src.getLight(srcIndex), light.lm[srcIndex]);
            sink.writeQuad(x, y, z, color, u, v, lm);
        }
        TextureAtlasSprite sprite = src.rubidium$getSprite();
        if (sprite != null) {
            renderData.addSprite(sprite);
        }
    }

    private LightMode getLightingMode(BlockState state, IBakedModel model, IBlockDisplayReader world, BlockPos pos) {
        if (this.useAmbientOcclusion && model.isAmbientOcclusion(state) && state.getLightValue((IBlockReader)world, pos) == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

