/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.world.biome.BiomeSlice;
import me.jellysquid.mods.sodium.client.world.biome.BoxBlur;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.level.ColorResolver;

public class BiomeColorCache {
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private final BiomeSlice biomeData;
    private final Reference2ReferenceOpenHashMap<ColorResolver, Slice[]> slices;
    private final int blendRadius;
    private final BoxBlur.ColorBuffer tempColorBuffer;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int populateStamp;
    private final int sizeXZ;
    private final int sizeY;
    private final boolean uses3DBiomes;

    public BiomeColorCache(BiomeSlice biomeData, int blendRadius, boolean is3D) {
        this.biomeData = biomeData;
        this.blendRadius = Math.min(7, blendRadius);
        this.uses3DBiomes = is3D;
        this.sizeXZ = 16 + (2 + this.blendRadius) * 2;
        this.sizeY = 20;
        this.slices = new Reference2ReferenceOpenHashMap();
        this.populateStamp = 1;
        this.tempColorBuffer = new BoxBlur.ColorBuffer(this.sizeXZ, this.sizeXZ);
    }

    public void update(ChunkRenderContext context) {
        this.minX = context.getOrigin().func_218161_d() - 2 - this.blendRadius;
        this.minY = context.getOrigin().func_218151_e() - 2;
        this.minZ = context.getOrigin().func_218164_f() - 2 - this.blendRadius;
        this.maxX = context.getOrigin().func_218152_g() + 2 + this.blendRadius;
        this.maxY = context.getOrigin().func_218165_h() + 2;
        this.maxZ = context.getOrigin().func_218143_r() + 2 + this.blendRadius;
        ++this.populateStamp;
    }

    public int getColor(ColorResolver resolver, int blockX, int blockY, int blockZ) {
        Slice slice;
        int relX = MathHelper.func_76125_a((int)blockX, (int)this.minX, (int)this.maxX) - this.minX;
        int relY = MathHelper.func_76125_a((int)blockY, (int)this.minY, (int)this.maxY) - this.minY;
        int relZ = MathHelper.func_76125_a((int)blockZ, (int)this.minZ, (int)this.maxZ) - this.minZ;
        if (!this.slices.containsKey((Object)resolver)) {
            this.initializeSlices(resolver);
        }
        if ((slice = ((Slice[])this.slices.get((Object)resolver))[relY]).lastPopulateStamp < (long)this.populateStamp) {
            this.updateColorBuffers(relY, resolver, slice);
        }
        BoxBlur.ColorBuffer buffer = slice.getBuffer();
        return buffer.get(relX, relZ);
    }

    private void initializeSlices(ColorResolver resolver) {
        Object[] slice = new Slice[this.sizeY];
        this.slices.put((Object)resolver, (Object)slice);
        if (this.uses3DBiomes) {
            for (int y = 0; y < this.sizeY; ++y) {
                slice[y] = new Slice(this.sizeXZ);
            }
        } else {
            Arrays.fill(slice, new Slice(this.sizeXZ));
        }
    }

    private void updateColorBuffers(int relY, ColorResolver resolver, Slice slice) {
        int worldY = this.minY + relY;
        for (int worldZ = this.minZ; worldZ <= this.maxZ; ++worldZ) {
            for (int worldX = this.minX; worldX <= this.maxX; ++worldX) {
                Biome biome = this.biomeData.getBiome(worldX, worldY, worldZ);
                int relativeX = worldX - this.minX;
                int relativeZ = worldZ - this.minZ;
                slice.buffer.set(relativeX, relativeZ, resolver.getColor(biome, (double)worldX, (double)worldZ));
            }
        }
        if (this.blendRadius > 0) {
            BoxBlur.blur(slice.buffer, this.tempColorBuffer, this.blendRadius);
        }
        slice.lastPopulateStamp = this.populateStamp;
    }

    private static class Slice {
        private final BoxBlur.ColorBuffer buffer;
        private long lastPopulateStamp;

        private Slice(int size) {
            this.buffer = new BoxBlur.ColorBuffer(size, size);
            this.lastPopulateStamp = 0L;
        }

        public BoxBlur.ColorBuffer getBuffer() {
            return this.buffer;
        }
    }
}

