/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import net.minecraft.util.math.MathHelper;

public class BoxBlur {
    public static void blur(ColorBuffer buf, ColorBuffer tmp, int radius) {
        if (buf.width != tmp.width || buf.height != tmp.height) {
            throw new IllegalArgumentException("Color buffers must have same dimensions");
        }
        if (BoxBlur.isHomogenous(buf.data)) {
            return;
        }
        BoxBlur.blurImpl(buf.data, tmp.data, buf.width, buf.height, radius);
        BoxBlur.blurImpl(tmp.data, buf.data, buf.width, buf.height, radius);
    }

    private static void blurImpl(int[] src, int[] dst, int width, int height, int radius) {
        int multiplier = BoxBlur.getAveragingMultiplier(radius * 2 + 1);
        for (int y = 0; y < height; ++y) {
            int color;
            int x;
            int srcRowOffset = ColorBuffer.getIndex(0, y, width);
            int color2 = src[srcRowOffset];
            int red = ColorARGB.unpackRed(color2);
            int green = ColorARGB.unpackGreen(color2);
            int blue = ColorARGB.unpackBlue(color2);
            red += red * radius;
            green += green * radius;
            blue += blue * radius;
            for (x = 1; x <= radius; ++x) {
                color = src[srcRowOffset + x];
                red += ColorARGB.unpackRed(color);
                green += ColorARGB.unpackGreen(color);
                blue += ColorARGB.unpackBlue(color);
            }
            for (x = 0; x < width; ++x) {
                dst[ColorBuffer.getIndex((int)y, (int)x, (int)width)] = BoxBlur.averageRGB(red, green, blue, multiplier);
                color = src[srcRowOffset + Math.max(0, x - radius)];
                red -= ColorARGB.unpackRed(color);
                green -= ColorARGB.unpackGreen(color);
                blue -= ColorARGB.unpackBlue(color);
                color = src[srcRowOffset + Math.min(width - 1, x + radius + 1)];
                red += ColorARGB.unpackRed(color);
                green += ColorARGB.unpackGreen(color);
                blue += ColorARGB.unpackBlue(color);
            }
        }
    }

    private static int getAveragingMultiplier(int size) {
        return MathHelper.func_76143_f((double)(1.6777216E7 / (double)size));
    }

    public static int averageRGB(int red, int green, int blue, int multiplier) {
        int value = -16777216;
        value |= blue * multiplier >>> 24 << 0;
        value |= green * multiplier >>> 24 << 8;
        return value |= red * multiplier >>> 24 << 16;
    }

    private static boolean isHomogenous(int[] array) {
        int first = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] == first) continue;
            return false;
        }
        return true;
    }

    public static class ColorBuffer {
        protected final int[] data;
        protected final int width;
        protected final int height;

        public ColorBuffer(int width, int height) {
            this.data = new int[width * height];
            this.width = width;
            this.height = height;
        }

        public void set(int x, int y, int color) {
            this.data[ColorBuffer.getIndex((int)x, (int)y, (int)this.width)] = color;
        }

        public int get(int x, int y) {
            return this.data[ColorBuffer.getIndex(x, y, this.width)];
        }

        public static int getIndex(int x, int y, int width) {
            return y * width + x;
        }
    }
}

