/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.client.world.cloned.PalettedContainerExtended;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalette;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPaletteFallback;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalleteArray;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BitArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IdentityPalette;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.NibbleArray;

public class ClonedChunkSection {
    private static final LightType[] LIGHT_TYPES = LightType.values();
    private static final ChunkSection EMPTY_SECTION = new ChunkSection(0);
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final ClonedChunkSectionCache backingCache;
    private final Short2ObjectMap<TileEntity> blockEntities;
    private final NibbleArray[] lightDataArrays;
    private final World world;
    private SectionPos pos;
    private BitArray blockStateData;
    private ClonedPalette<BlockState> blockStatePalette;
    private BiomeContainer biomeData;
    private long lastUsedTimestamp = Long.MAX_VALUE;

    ClonedChunkSection(ClonedChunkSectionCache backingCache, World world) {
        this.backingCache = backingCache;
        this.world = world;
        this.blockEntities = new Short2ObjectOpenHashMap();
        this.lightDataArrays = new NibbleArray[LIGHT_TYPES.length];
    }

    public void init(SectionPos pos) {
        Chunk chunk = this.world.func_212866_a_(pos.func_177958_n(), pos.func_177952_p());
        if (chunk == null) {
            throw new RuntimeException("Couldn't retrieve chunk at " + pos.func_218155_u());
        }
        ChunkSection section = ClonedChunkSection.getChunkSection((IChunk)chunk, pos);
        if (section == Chunk.field_186036_a) {
            section = EMPTY_SECTION;
        }
        this.pos = pos;
        PalettedContainerExtended<BlockState> container = PalettedContainerExtended.cast(section.func_186049_g());
        this.blockStateData = ClonedChunkSection.copyBlockData(container);
        this.blockStatePalette = ClonedChunkSection.copyPalette(container);
        for (LightType type : LIGHT_TYPES) {
            this.lightDataArrays[type.ordinal()] = this.world.func_225524_e_().func_215569_a(type).func_215612_a(pos);
        }
        this.biomeData = chunk.func_225549_i_();
        MutableBoundingBox box = new MutableBoundingBox(pos.func_218161_d(), pos.func_218151_e(), pos.func_218164_f(), pos.func_218152_g(), pos.func_218165_h(), pos.func_218143_r());
        this.blockEntities.clear();
        for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
            BlockPos entityPos = (BlockPos)entry.getKey();
            if (!box.func_175898_b((Vector3i)entityPos)) continue;
            this.blockEntities.put(SectionPos.func_218150_b((BlockPos)entityPos), (Object)((TileEntity)entry.getValue()));
        }
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.blockStatePalette.get(this.blockStateData.func_188142_a(y << 8 | z << 4 | x));
    }

    public int getLightLevel(LightType type, int x, int y, int z) {
        NibbleArray array = this.lightDataArrays[type.ordinal()];
        if (array != null) {
            return array.func_76582_a(x, y, z);
        }
        return 0;
    }

    public Biome getBiomeForNoiseGen(int x, int y, int z) {
        return this.biomeData.func_225526_b_(x, y, z);
    }

    public TileEntity getBlockEntity(int x, int y, int z) {
        return (TileEntity)this.blockEntities.get(ClonedChunkSection.packLocal(x, y, z));
    }

    public BitArray getBlockData() {
        return this.blockStateData;
    }

    public ClonedPalette<BlockState> getBlockPalette() {
        return this.blockStatePalette;
    }

    public SectionPos getPosition() {
        return this.pos;
    }

    private static ClonedPalette<BlockState> copyPalette(PalettedContainerExtended<BlockState> container) {
        IPalette<BlockState> palette = container.getPalette();
        if (palette instanceof IdentityPalette) {
            return new ClonedPaletteFallback<BlockState>(Block.field_176229_d);
        }
        BlockState[] array = new BlockState[1 << container.getPaletteSize()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (BlockState)palette.func_186039_a(i);
            if (array[i] == null) break;
        }
        return new ClonedPalleteArray<BlockState>(array, container.getDefaultValue());
    }

    private static BitArray copyBlockData(PalettedContainerExtended<BlockState> container) {
        BitArray array = container.getDataArray();
        long[] storage = array.func_188143_a();
        return new BitArray(container.getPaletteSize(), array.func_188144_b(), (long[])storage.clone());
    }

    private static ChunkSection getChunkSection(IChunk chunk, SectionPos pos) {
        ChunkSection section = null;
        if (!World.func_217405_b((int)SectionPos.func_218142_c((int)pos.func_177956_o()))) {
            section = chunk.func_76587_i()[pos.func_177956_o()];
        }
        return section;
    }

    public void acquireReference() {
        this.referenceCount.incrementAndGet();
    }

    public boolean releaseReference() {
        return this.referenceCount.decrementAndGet() <= 0;
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long timestamp) {
        this.lastUsedTimestamp = timestamp;
    }

    public ClonedChunkSectionCache getBackingCache() {
        return this.backingCache;
    }

    private static short packLocal(int x, int y, int z) {
        return (short)(x << 8 | z << 4 | y);
    }
}

