/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util.collections;

import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.crash.ReportedException;

public class FutureDequeDrain<T>
implements Iterator<T> {
    private final Deque<CompletableFuture<T>> deque;
    private T next = null;

    public FutureDequeDrain(Deque<CompletableFuture<T>> deque) {
        this.deque = deque;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.findNext();
        return this.next != null;
    }

    private void findNext() {
        while (!this.deque.isEmpty()) {
            CompletableFuture<T> future = this.deque.remove();
            try {
                this.next = future.join();
                return;
            }
            catch (CancellationException cancellationException) {
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof ReportedException) {
                    throw (ReportedException)e.getCause();
                }
                throw e;
            }
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.next = null;
        return result;
    }
}

