/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.entity.smooth_lighting;

import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.model.light.EntityLighter;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.entity.EntityLightSampler;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public abstract class MixinEntityRenderer<T extends Entity>
implements EntityLightSampler<T> {
    @Shadow
    protected abstract int func_225624_a_(T var1, BlockPos var2);

    @Shadow(remap=false)
    protected abstract int func_239381_b_(T var1, BlockPos var2);

    @Inject(method={"getPackedLightCoords"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetLight(T entity, float tickDelta, CallbackInfoReturnable<Integer> cir) {
        if (SodiumClientMod.options().quality.smoothLighting == SodiumGameOptions.LightingQuality.HIGH) {
            cir.setReturnValue((Object)EntityLighter.getBlendedLight(this, entity, tickDelta));
        }
    }

    @Inject(method={"shouldRender"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/culling/Frustum;isVisible(Lnet/minecraft/world/phys/AABB;)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void preShouldRender(T entity, ClippingHelper frustum, double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        SodiumWorldRenderer renderer = SodiumWorldRenderer.getInstanceNullable();
        if (renderer == null) {
            return;
        }
        if (((Boolean)cir.getReturnValue()).booleanValue() && !renderer.isEntityVisible((Entity)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public int bridge$getBlockLight(T entity, BlockPos pos) {
        return this.func_225624_a_(entity, pos);
    }

    @Override
    public int bridge$getSkyLight(T entity, BlockPos pos) {
        return this.func_239381_b_(entity, pos);
    }
}

