/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.model;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.MultipartModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MultipartBakedModel.class})
public class MixinMultipartBakedModel {
    private final Map<BlockState, IBakedModel[]> stateCacheFast = new Reference2ReferenceOpenHashMap();
    private final StampedLock lock = new StampedLock();
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, IBakedModel>> field_188626_f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBakedModel[] getModelComponents(BlockState state) {
        IBakedModel[] models;
        long readStamp = this.lock.readLock();
        try {
            models = this.stateCacheFast.get(state);
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
        if (models == null) {
            long writeStamp = this.lock.writeLock();
            try {
                ArrayList<IBakedModel> modelList = new ArrayList<IBakedModel>(this.field_188626_f.size());
                for (Pair<Predicate<BlockState>, IBakedModel> pair : this.field_188626_f) {
                    if (!((Predicate)pair.getLeft()).test(state)) continue;
                    modelList.add((IBakedModel)pair.getRight());
                }
                models = modelList.toArray(new IBakedModel[modelList.size()]);
                this.stateCacheFast.put(state, models);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
        return models;
    }

    @Overwrite(remap=false)
    public List<BakedQuad> getQuads(BlockState state, Direction face, Random random, IModelData modelData) {
        if (state == null) {
            if (Collections.emptyMap().get(null) != null) {
                HashMap<Object, Object> fakeMap = new HashMap<Object, Object>();
                fakeMap.put(null, null);
            }
            return Collections.emptyList();
        }
        IBakedModel[] models = this.getModelComponents(state);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        long seed = random.nextLong();
        for (IBakedModel model : models) {
            random.setSeed(seed);
            quads.addAll(model.getQuads(state, face, random, MultipartModelData.resolve((IBakedModel)model, (IModelData)modelData)));
        }
        return quads;
    }

    @Overwrite(remap=false)
    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileModelData) {
        IBakedModel[] models = this.getModelComponents(state);
        MultipartModelData multipartModelData = null;
        for (IBakedModel model : models) {
            IModelData data = model.getModelData(world, pos, state, tileModelData);
            if (data == tileModelData) continue;
            if (multipartModelData == null) {
                multipartModelData = new MultipartModelData(tileModelData);
            }
            multipartModelData.setPartData(model, data);
        }
        return multipartModelData == null ? tileModelData : multipartModelData;
    }
}

