/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.particle.fast_render;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.particle.ParticleVertexSink;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={TexturedParticle.class})
public abstract class MixinBillboardParticle
extends Particle {
    @Shadow
    public abstract float func_217561_b(float var1);

    @Shadow
    protected abstract float func_217563_c();

    @Shadow
    protected abstract float func_217564_d();

    @Shadow
    protected abstract float func_217562_e();

    @Shadow
    protected abstract float func_217560_f();

    protected MixinBillboardParticle(ClientWorld world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Overwrite
    public void func_225606_a_(IVertexBuilder vertexConsumer, ActiveRenderInfo camera, float tickDelta) {
        Quaternion quaternion;
        Vector3d vec3d = camera.func_216785_c();
        float x = (float)(MathHelper.func_219803_d((double)tickDelta, (double)this.field_187123_c, (double)this.field_187126_f) - vec3d.func_82615_a());
        float y = (float)(MathHelper.func_219803_d((double)tickDelta, (double)this.field_187124_d, (double)this.field_187127_g) - vec3d.func_82617_b());
        float z = (float)(MathHelper.func_219803_d((double)tickDelta, (double)this.field_187125_e, (double)this.field_187128_h) - vec3d.func_82616_c());
        if (this.field_190014_F == 0.0f) {
            quaternion = camera.func_227995_f_();
        } else {
            float angle = MathHelper.func_219799_g((float)tickDelta, (float)this.field_190015_G, (float)this.field_190014_F);
            quaternion = new Quaternion(camera.func_227995_f_());
            quaternion.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(angle));
        }
        float size = this.func_217561_b(tickDelta);
        int light = this.func_189214_a(tickDelta);
        float minU = this.func_217563_c();
        float maxU = this.func_217564_d();
        float minV = this.func_217562_e();
        float maxV = this.func_217560_f();
        int color = ColorABGR.pack(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        ParticleVertexSink drain = VertexDrain.of(vertexConsumer).createSink(VanillaVertexTypes.PARTICLES);
        drain.ensureCapacity(4);
        MixinBillboardParticle.addVertex(drain, quaternion, -1.0f, -1.0f, x, y, z, maxU, maxV, color, light, size);
        MixinBillboardParticle.addVertex(drain, quaternion, -1.0f, 1.0f, x, y, z, maxU, minV, color, light, size);
        MixinBillboardParticle.addVertex(drain, quaternion, 1.0f, 1.0f, x, y, z, minU, minV, color, light, size);
        MixinBillboardParticle.addVertex(drain, quaternion, 1.0f, -1.0f, x, y, z, minU, maxV, color, light, size);
        drain.flush();
    }

    private static void addVertex(ParticleVertexSink drain, Quaternion rotation, float x, float y, float posX, float posY, float posZ, float u, float v, int color, int light, float size) {
        float q0x = rotation.func_195889_a();
        float q0y = rotation.func_195891_b();
        float q0z = rotation.func_195893_c();
        float q0w = rotation.func_195894_d();
        float q1x = q0w * x - q0z * y;
        float q1y = q0w * y + q0z * x;
        float q1w = q0x * y - q0y * x;
        float q1z = -(q0x * x) - q0y * y;
        float q2x = -q0x;
        float q2y = -q0y;
        float q2z = -q0z;
        float q2w = q0w;
        float q3x = q1z * q2x + q1x * q2w + q1y * q2z - q1w * q2y;
        float q3y = q1z * q2y - q1x * q2z + q1y * q2w + q1w * q2x;
        float q3z = q1z * q2z + q1x * q2y - q1y * q2x + q1w * q2w;
        float fx = q3x * size + posX;
        float fy = q3y * size + posY;
        float fz = q3z * size + posZ;
        drain.writeParticle(fx, fy, fz, u, v, color, light);
    }
}

