/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.compat.ccl;

import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IRegistryDelegate;
import org.embeddedt.embeddium.api.BlockRendererRegistry;

public class CCLCompat {
    private static Map<IRegistryDelegate<Block>, ICCBlockRenderer> customBlockRenderers;
    private static Map<IRegistryDelegate<Fluid>, ICCBlockRenderer> customFluidRenderers;
    private static List<ICCBlockRenderer> customGlobalRenderers;
    private static final Map<ICCBlockRenderer, BlockRendererRegistry.Renderer> ccRendererToSodium;
    private static final ThreadLocal<MatrixStack> STACK_THREAD_LOCAL;

    private static BlockRendererRegistry.Renderer createBridge(ICCBlockRenderer r) {
        return ccRendererToSodium.computeIfAbsent(r, ccRenderer -> (state, pos, world, consumer, random, modelData) -> {
            ccRenderer.renderBlock(state, pos, world, STACK_THREAD_LOCAL.get(), consumer, random, modelData);
            return BlockRendererRegistry.RenderResult.OVERRIDE;
        });
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("codechickenlib")) {
            CCLCompat.init();
            BlockRendererRegistry.instance().registerRenderPopulator((resultList, state, pos, world) -> {
                if (!customGlobalRenderers.isEmpty()) {
                    for (ICCBlockRenderer r : customGlobalRenderers) {
                        if (!r.canHandleBlock(world, pos, state)) continue;
                        resultList.add(CCLCompat.createBridge(r));
                    }
                }
                if (!customBlockRenderers.isEmpty()) {
                    Block block = state.func_177230_c();
                    for (Map.Entry<IRegistryDelegate<Block>, ICCBlockRenderer> entry : customBlockRenderers.entrySet()) {
                        if (entry.getKey().get() != block || !entry.getValue().canHandleBlock(world, pos, state)) continue;
                        resultList.add(CCLCompat.createBridge(entry.getValue()));
                    }
                }
                if (!customFluidRenderers.isEmpty()) {
                    Fluid fluid = state.func_204520_s().func_206886_c();
                    for (Map.Entry<IRegistryDelegate<Block>, ICCBlockRenderer> entry : customFluidRenderers.entrySet()) {
                        if (!((Fluid)entry.getKey().get()).func_207187_a(fluid) || !entry.getValue().canHandleBlock(world, pos, state)) continue;
                        resultList.add(CCLCompat.createBridge(entry.getValue()));
                    }
                }
            });
        }
    }

    public static void init() {
        try {
            SodiumClientMod.LOGGER.info("Retrieving block renderers");
            Field blockRenderersField = BlockRenderingRegistry.class.getDeclaredField("blockRenderers");
            blockRenderersField.setAccessible(true);
            customBlockRenderers = (Map)blockRenderersField.get(null);
            SodiumClientMod.LOGGER.info("Retrieving fluid renderers");
            Field fluidRenderersField = BlockRenderingRegistry.class.getDeclaredField("fluidRenderers");
            fluidRenderersField.setAccessible(true);
            customFluidRenderers = (Map)fluidRenderersField.get(null);
            SodiumClientMod.LOGGER.info("Retrieving global renderers");
            Field globalRenderersField = BlockRenderingRegistry.class.getDeclaredField("globalRenderers");
            globalRenderersField.setAccessible(true);
            customGlobalRenderers = (List)globalRenderersField.get(null);
            if (customBlockRenderers == null) {
                customBlockRenderers = Collections.emptyMap();
            }
            if (customFluidRenderers == null) {
                customFluidRenderers = Collections.emptyMap();
            }
            if (customGlobalRenderers == null) {
                customGlobalRenderers = Collections.emptyList();
            }
        }
        catch (Throwable t) {
            SodiumClientMod.LOGGER.error("Could not retrieve custom renderers");
        }
    }

    static {
        ccRendererToSodium = new ConcurrentHashMap<ICCBlockRenderer, BlockRendererRegistry.Renderer>();
        STACK_THREAD_LOCAL = ThreadLocal.withInitial(MatrixStack::new);
    }
}

