/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render.fluid;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidAttributes;

public class EmbeddiumFluidSpriteCache {
    private final TextureAtlasSprite[] sprites = new TextureAtlasSprite[3];
    private final Object2ObjectOpenHashMap<ResourceLocation, TextureAtlasSprite> spriteCache = new Object2ObjectOpenHashMap();

    private TextureAtlasSprite getTexture(ResourceLocation identifier) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.spriteCache.get((Object)identifier);
        if (sprite == null) {
            sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(identifier);
            this.spriteCache.put((Object)identifier, (Object)sprite);
        }
        return sprite;
    }

    public TextureAtlasSprite[] getSprites(IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        FluidAttributes attributes = fluidState.func_206886_c().getAttributes();
        this.sprites[0] = this.getTexture(attributes.getStillTexture(world, pos));
        this.sprites[1] = this.getTexture(attributes.getFlowingTexture(world, pos));
        ResourceLocation overlay = attributes.getOverlayTexture();
        this.sprites[2] = overlay != null ? this.getTexture(overlay) : null;
        return this.sprites;
    }
}

