/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.CollectionPlatformUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0016\u001a\u00020\u0012J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u0016\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000b\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\n\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/collection/CircularArray;", "E", "", "minCapacity", "", "(I)V", "capacityBitmask", "elements", "", "[Ljava/lang/Object;", "first", "getFirst", "()Ljava/lang/Object;", "head", "last", "getLast", "tail", "addFirst", "", "element", "(Ljava/lang/Object;)V", "addLast", "clear", "doubleCapacity", "get", "index", "(I)Ljava/lang/Object;", "isEmpty", "", "popFirst", "popLast", "removeFromEnd", "count", "removeFromStart", "size", "collection"})
@SourceDebugExtension(value={"SMAP\nCircularArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CircularArray.kt\nandroidx/collection/CircularArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CollectionPlatformUtils.jvm.kt\nandroidx/collection/CollectionPlatformUtils\n*L\n1#1,270:1\n1#2:271\n26#3:272\n26#3:273\n26#3:274\n26#3:275\n26#3:276\n26#3:277\n26#3:278\n*S KotlinDebug\n*F\n+ 1 CircularArray.kt\nandroidx/collection/CircularArray\n*L\n104#1:272\n122#1:273\n152#1:274\n187#1:275\n221#1:276\n235#1:277\n249#1:278\n*E\n"})
public final class CircularArray<E> {
    @NotNull
    private E[] elements;
    private int head;
    private int tail;
    private int capacityBitmask;

    @JvmOverloads
    public CircularArray(int minCapacity) {
        if (!(minCapacity >= 1)) {
            boolean $i$a$-require-CircularArray$32 = false;
            String $i$a$-require-CircularArray$32 = "capacity must be >= 1";
            throw new IllegalArgumentException($i$a$-require-CircularArray$32.toString());
        }
        if (!(minCapacity <= 0x40000000)) {
            boolean bl = false;
            String string = "capacity must be <= 2^30";
            throw new IllegalArgumentException(string.toString());
        }
        int arrayCapacity = Integer.bitCount(minCapacity) != 1 ? Integer.highestOneBit(minCapacity - 1) << 1 : minCapacity;
        this.capacityBitmask = arrayCapacity - 1;
        this.elements = new Object[arrayCapacity];
    }

    public /* synthetic */ CircularArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        this(n);
    }

    private final void doubleCapacity() {
        int n = this.elements.length;
        int r = n - this.head;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new RuntimeException("Max array capacity exceeded");
        }
        Object[] a = new Object[newCapacity];
        ArraysKt.copyInto(this.elements, a, 0, this.head, n);
        ArraysKt.copyInto(this.elements, a, r, 0, this.head);
        this.elements = a;
        this.head = 0;
        this.tail = n;
        this.capacityBitmask = newCapacity - 1;
    }

    public final void addFirst(E element) {
        this.head = this.head - 1 & this.capacityBitmask;
        this.elements[this.head] = element;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public final void addLast(E element) {
        this.elements[this.tail] = element;
        this.tail = this.tail + 1 & this.capacityBitmask;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    public final E popFirst() {
        if (this.head == this.tail) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        E result2 = this.elements[this.head];
        this.elements[this.head] = null;
        this.head = this.head + 1 & this.capacityBitmask;
        return result2;
    }

    public final E popLast() {
        if (this.head == this.tail) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        int t2 = this.tail - 1 & this.capacityBitmask;
        E result2 = this.elements[t2];
        this.elements[t2] = null;
        this.tail = t2;
        return result2;
    }

    public final void clear() {
        this.removeFromStart(this.size());
    }

    public final void removeFromStart(int count2) {
        if (count2 <= 0) {
            return;
        }
        if (count2 > this.size()) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        int numOfElements = count2;
        int end2 = this.elements.length;
        if (numOfElements < end2 - this.head) {
            end2 = this.head + numOfElements;
        }
        int n = end2;
        for (int i = this.head; i < n; ++i) {
            this.elements[i] = null;
        }
        int removed = end2 - this.head;
        this.head = this.head + removed & this.capacityBitmask;
        if ((numOfElements -= removed) > 0) {
            int n2 = numOfElements;
            for (int i = 0; i < n2; ++i) {
                this.elements[i] = null;
            }
            this.head = numOfElements;
        }
    }

    public final void removeFromEnd(int count2) {
        if (count2 <= 0) {
            return;
        }
        if (count2 > this.size()) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        int numOfElements = count2;
        int start2 = 0;
        if (numOfElements < this.tail) {
            start2 = this.tail - numOfElements;
        }
        int n = this.tail;
        for (int i = start2; i < n; ++i) {
            this.elements[i] = null;
        }
        int removed = this.tail - start2;
        this.tail -= removed;
        if ((numOfElements -= removed) > 0) {
            int newTail;
            this.tail = this.elements.length;
            int n2 = this.tail;
            for (int i = newTail = this.tail - numOfElements; i < n2; ++i) {
                this.elements[i] = null;
            }
            this.tail = newTail;
        }
    }

    public final E getFirst() {
        if (this.head == this.tail) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        E e = this.elements[this.head];
        Intrinsics.checkNotNull(e);
        return e;
    }

    public final E getLast() {
        if (this.head == this.tail) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        E e = this.elements[this.tail - 1 & this.capacityBitmask];
        Intrinsics.checkNotNull(e);
        return e;
    }

    public final E get(int index2) {
        if (index2 < 0 || index2 >= this.size()) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        E e = this.elements[this.head + index2 & this.capacityBitmask];
        Intrinsics.checkNotNull(e);
        return e;
    }

    public final int size() {
        return this.tail - this.head & this.capacityBitmask;
    }

    public final boolean isEmpty() {
        return this.head == this.tail;
    }

    @JvmOverloads
    public CircularArray() {
        this(0, 1, null);
    }
}

