/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.LongList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\b\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0001J\u0018\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0001J\u0018\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0003J\u0011\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0086\nJ\u0011\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0086\nJ\u0011\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\f2\b\b\u0001\u0010\n\u001a\u00020\u0003J\u001a\u0010\u0018\u001a\u00020\t2\b\b\u0001\u0010\u0019\u001a\u00020\u00032\b\b\u0001\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u001b\u0010\u001c\u001a\u00020\f2\b\b\u0001\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0006\u0010\u001d\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u00020\t2\b\b\u0002\u0010 \u001a\u00020\u0003R\u0012\u0010\u0005\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Landroidx/collection/MutableLongList;", "Landroidx/collection/LongList;", "initialCapacity", "", "(I)V", "capacity", "getCapacity", "()I", "add", "", "index", "element", "", "", "addAll", "elements", "", "clear", "ensureCapacity", "minusAssign", "plusAssign", "remove", "removeAll", "removeAt", "removeRange", "start", "end", "retainAll", "set", "sort", "sortDescending", "trim", "minCapacity", "collection"})
@SourceDebugExtension(value={"SMAP\nLongList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongList.kt\nandroidx/collection/MutableLongList\n+ 2 LongList.kt\nandroidx/collection/LongList\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,969:1\n549#1:970\n70#2:971\n253#2,6:974\n70#2:980\n70#2:981\n70#2:982\n70#2:989\n70#2:990\n13607#3,2:972\n1675#3,6:983\n*S KotlinDebug\n*F\n+ 1 LongList.kt\nandroidx/collection/MutableLongList\n*L\n692#1:970\n753#1:971\n772#1:974,6\n783#1:980\n787#1:981\n834#1:982\n850#1:989\n869#1:990\n763#1:972,2\n836#1:983,6\n*E\n"})
public final class MutableLongList
extends LongList {
    public MutableLongList(int initialCapacity) {
        super(initialCapacity, null);
    }

    public /* synthetic */ MutableLongList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final int getCapacity() {
        boolean $i$f$getCapacity = false;
        return this.content.length;
    }

    public final boolean add(long element) {
        this.ensureCapacity(this._size + 1);
        this.content[this._size] = element;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    public final void add(@IntRange(from=0L) int index2, long element) {
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index2 + " must be in 0.." + this._size);
        }
        this.ensureCapacity(this._size + 1);
        long[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + 1, index2, this._size);
        }
        content2[index2] = element;
        int n = this._size;
        this._size = n + 1;
    }

    public final boolean addAll(@IntRange(from=0L) int index2, @NotNull long[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index2 + " must be in 0.." + this._size);
        }
        if (elements.length == 0) {
            return false;
        }
        this.ensureCapacity(this._size + elements.length);
        long[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + elements.length, index2, this._size);
        }
        ArraysKt.copyInto$default(elements, content2, index2, 0, 0, 12, null);
        this._size += elements.length;
        return true;
    }

    public final boolean addAll(@IntRange(from=0L) int index2, @NotNull LongList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            throw new IndexOutOfBoundsException("Index " + index2 + " must be in 0.." + this._size);
        }
        if (elements.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this._size + elements._size);
        long[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + elements._size, index2, this._size);
        }
        ArraysKt.copyInto(elements.content, content2, index2, 0, elements._size);
        this._size += elements._size;
        return true;
    }

    public final boolean addAll(@NotNull LongList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.addAll(this._size, elements);
    }

    public final boolean addAll(@NotNull long[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull LongList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull long[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.addAll(this._size, elements);
    }

    public final void clear() {
        this._size = 0;
    }

    public final void trim(int minCapacity) {
        int minSize = Math.max(minCapacity, this._size);
        MutableLongList this_$iv = this;
        boolean $i$f$getCapacity = false;
        if (this_$iv.content.length > minSize) {
            long[] lArray = Arrays.copyOf(this.content, minSize);
            Intrinsics.checkNotNullExpressionValue(lArray, "copyOf(this, newSize)");
            this.content = lArray;
        }
    }

    public static /* synthetic */ void trim$default(MutableLongList mutableLongList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mutableLongList._size;
        }
        mutableLongList.trim(n);
    }

    public final void ensureCapacity(int capacity) {
        long[] oldContent = this.content;
        if (oldContent.length < capacity) {
            int newSize = Math.max(capacity, oldContent.length * 3 / 2);
            long[] lArray = Arrays.copyOf(oldContent, newSize);
            Intrinsics.checkNotNullExpressionValue(lArray, "copyOf(this, newSize)");
            this.content = lArray;
        }
    }

    public final void plusAssign(long element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(long element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(long element) {
        int index2 = this.indexOf(element);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public final boolean removeAll(@NotNull long[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            this.remove(elements[i]);
        }
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull LongList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int i = 0;
        LongList this_$iv = elements;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv._size - 1;
        if (i <= n) {
            while (true) {
                this.remove(elements.get(i));
                if (i == n) break;
                ++i;
            }
        }
        return initialSize != this._size;
    }

    public final void minusAssign(@NotNull long[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        long[] $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            long element$iv;
            long element = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final void minusAssign(@NotNull LongList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        LongList this_$iv = elements;
        boolean $i$f$forEach = false;
        long[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            long element = content$iv[i$iv];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final long removeAt(@IntRange(from=0L) int index2) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            LongList this_$iv = this;
            boolean $i$f$getLastIndex = false;
            throw new IndexOutOfBoundsException("Index " + index2 + " must be in 0.." + (this_$iv._size - 1));
        }
        long[] content2 = this.content;
        long item2 = content2[index2];
        LongList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        if (index2 != this_$iv._size - 1) {
            ArraysKt.copyInto(content2, content2, index2, index2 + 1, this._size);
        }
        int n = this._size;
        this._size = n + -1;
        return item2;
    }

    public final void removeRange(@IntRange(from=0L) int start2, @IntRange(from=0L) int end2) {
        block7: {
            block6: {
                boolean bl = 0 <= start2 ? start2 <= this._size : false;
                if (!bl) break block6;
                if (0 <= end2 ? end2 <= this._size : false) break block7;
            }
            throw new IndexOutOfBoundsException("Start (" + start2 + ") and end (" + end2 + ") must be in 0.." + this._size);
        }
        if (end2 < start2) {
            throw new IllegalArgumentException("Start (" + start2 + ") is more than end (" + end2 + ')');
        }
        if (end2 != start2) {
            if (end2 < this._size) {
                ArraysKt.copyInto(this.content, this.content, start2, end2, this._size);
            }
            this._size -= end2 - start2;
        }
    }

    public final boolean retainAll(@NotNull long[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        long[] content2 = this.content;
        LongList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            int n;
            block2: {
                long item2 = content2[i];
                long[] $this$indexOfFirst$iv = elements;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length;
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    long it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(it == item2)) continue;
                    n = index$iv;
                    break block2;
                }
                n = -1;
            }
            if (n >= 0) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull LongList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        long[] content2 = this.content;
        LongList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            long item2 = content2[i];
            if (elements.contains(item2)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final long set(@IntRange(from=0L) int index2, long element) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            LongList this_$iv = this;
            boolean $i$f$getLastIndex = false;
            throw new IndexOutOfBoundsException("set index " + index2 + " must be between 0 .. " + (this_$iv._size - 1));
        }
        long[] content2 = this.content;
        long old = content2[index2];
        content2[index2] = element;
        return old;
    }

    public final void sort() {
        ArraysKt.sort(this.content, 0, this._size);
    }

    public final void sortDescending() {
        ArraysKt.sortDescending(this.content, 0, this._size);
    }

    public MutableLongList() {
        this(0, 1, null);
    }
}

