/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.internal.ContainerHelpersKt;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b)\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B!\b\u0016\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u0001\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0013\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u0018\u0010\u001b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u00028\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJ,\u0010 \u001a\u0002H!\"\n\b\u0002\u0010!*\u0004\u0018\u00018\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u0002H!H\u0082\b\u00a2\u0006\u0002\u0010\u001fJ\b\u0010\"\u001a\u00020\u0007H\u0016J\u001d\u0010#\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010$\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0007H\u0002J\u0017\u0010)\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00028\u0001H\u0001\u00a2\u0006\u0004\b*\u0010'J\b\u0010+\u001a\u00020\u0012H\u0016J\u0015\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010.J\u001f\u0010/\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJ \u00100\u001a\u00020\u00102\u0016\u0010\u0004\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0000H\u0016J\u001f\u00101\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0017\u00102\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001d\u00102\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00103J\u0015\u00104\u001a\u00028\u00012\u0006\u0010-\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010.J\u001f\u00105\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJ%\u00105\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u00012\u0006\u00107\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00108J\u001d\u00109\u001a\u00028\u00012\u0006\u0010-\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010:J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010;\u001a\u00020<H\u0016J\u0015\u0010=\u001a\u00028\u00012\u0006\u0010-\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010.R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Landroidx/collection/SimpleArrayMap;", "K", "V", "", "map", "(Landroidx/collection/SimpleArrayMap;)V", "capacity", "", "(I)V", "array", "", "[Ljava/lang/Object;", "hashes", "", "size", "clear", "", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "ensureCapacity", "minimumCapacity", "equals", "other", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrDefault", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "getOrDefaultInternal", "T", "hashCode", "indexOf", "hash", "(Ljava/lang/Object;I)I", "indexOfKey", "(Ljava/lang/Object;)I", "indexOfNull", "indexOfValue", "__restricted$indexOfValue", "isEmpty", "keyAt", "index", "(I)Ljava/lang/Object;", "put", "putAll", "putIfAbsent", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "removeAt", "replace", "oldValue", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "setValueAt", "(ILjava/lang/Object;)Ljava/lang/Object;", "toString", "", "valueAt", "collection"})
@SourceDebugExtension(value={"SMAP\nSimpleArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleArrayMap.kt\nandroidx/collection/SimpleArrayMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,769:1\n297#1,5:770\n297#1,5:775\n1#2:780\n*S KotlinDebug\n*F\n+ 1 SimpleArrayMap.kt\nandroidx/collection/SimpleArrayMap\n*L\n276#1:770,5\n291#1:775,5\n*E\n"})
public class SimpleArrayMap<K, V> {
    @NotNull
    private int[] hashes;
    @NotNull
    private Object[] array;
    private int size;

    @JvmOverloads
    public SimpleArrayMap(int capacity) {
        this.hashes = capacity == 0 ? ContainerHelpersKt.EMPTY_INTS : new int[capacity];
        this.array = capacity == 0 ? ContainerHelpersKt.EMPTY_OBJECTS : new Object[capacity << 1];
    }

    public /* synthetic */ SimpleArrayMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public SimpleArrayMap(@Nullable SimpleArrayMap<? extends K, ? extends V> map2) {
        this(0, 1, null);
        if (map2 != null) {
            this.putAll(map2);
        }
    }

    private final int indexOf(K key, int hash) {
        int end2;
        int n = this.size;
        if (n == 0) {
            return -1;
        }
        int index2 = ContainerHelpersKt.binarySearch(this.hashes, n, hash);
        if (index2 < 0) {
            return index2;
        }
        if (Intrinsics.areEqual(key, this.array[index2 << 1])) {
            return index2;
        }
        for (end2 = index2 + 1; end2 < n && this.hashes[end2] == hash; ++end2) {
            if (!Intrinsics.areEqual(key, this.array[end2 << 1])) continue;
            return end2;
        }
        for (int i = index2 - 1; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Intrinsics.areEqual(key, this.array[i << 1])) continue;
            return i;
        }
        return ~end2;
    }

    private final int indexOfNull() {
        int end2;
        int n = this.size;
        if (n == 0) {
            return -1;
        }
        int index2 = ContainerHelpersKt.binarySearch(this.hashes, n, 0);
        if (index2 < 0) {
            return index2;
        }
        if (this.array[index2 << 1] == null) {
            return index2;
        }
        for (end2 = index2 + 1; end2 < n && this.hashes[end2] == 0; ++end2) {
            if (this.array[end2 << 1] != null) continue;
            return end2;
        }
        for (int i = index2 - 1; i >= 0 && this.hashes[i] == 0; --i) {
            if (this.array[i << 1] != null) continue;
            return i;
        }
        return ~end2;
    }

    public void clear() {
        if (this.size > 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.array = ContainerHelpersKt.EMPTY_OBJECTS;
            this.size = 0;
        }
        if (this.size > 0) {
            throw new ConcurrentModificationException();
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        int osize = this.size;
        if (this.hashes.length < minimumCapacity) {
            int[] nArray = Arrays.copyOf(this.hashes, minimumCapacity);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(this, newSize)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.array, minimumCapacity * 2);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(this, newSize)");
            this.array = objectArray;
        }
        if (this.size != osize) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean containsKey(K key) {
        return this.indexOfKey(key) >= 0;
    }

    public int indexOfKey(K key) {
        return key == null ? this.indexOfNull() : this.indexOf(key, key.hashCode());
    }

    @JvmName(name="__restricted$indexOfValue")
    public final int __restricted$indexOfValue(V value) {
        int n = this.size * 2;
        Object[] array = this.array;
        if (value == null) {
            for (int i = 1; i < n; i += 2) {
                if (array[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < n; i += 2) {
                if (!Intrinsics.areEqual(value, array[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    public boolean containsValue(V value) {
        return this.__restricted$indexOfValue(value) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public V get(K key) {
        void this_$iv;
        SimpleArrayMap simpleArrayMap = this;
        Object defaultValue$iv = null;
        boolean $i$f$getOrDefaultInternal = false;
        int index$iv = this_$iv.indexOfKey(key);
        return (V)(index$iv >= 0 ? this_$iv.array[(index$iv << 1) + 1] : defaultValue$iv);
    }

    public V getOrDefault(@Nullable Object key, V defaultValue) {
        SimpleArrayMap this_$iv = this;
        boolean $i$f$getOrDefaultInternal = false;
        int index$iv = this_$iv.indexOfKey(key);
        return (V)(index$iv >= 0 ? this_$iv.array[(index$iv << 1) + 1] : defaultValue);
    }

    private final <T extends V> T getOrDefaultInternal(Object key, T defaultValue) {
        boolean $i$f$getOrDefaultInternal = false;
        int index2 = this.indexOfKey(key);
        return (T)(index2 >= 0 ? this.array[(index2 << 1) + 1] : defaultValue);
    }

    public K keyAt(int index2) {
        if (!(0 <= index2 ? index2 < this.size : false)) {
            boolean bl = false;
            String string = "Expected index to be within 0..size()-1, but was " + index2;
            throw new IllegalArgumentException(string.toString());
        }
        return (K)this.array[index2 << 1];
    }

    public V valueAt(int index2) {
        if (!(0 <= index2 ? index2 < this.size : false)) {
            boolean bl = false;
            String string = "Expected index to be within 0..size()-1, but was " + index2;
            throw new IllegalArgumentException(string.toString());
        }
        return (V)this.array[(index2 << 1) + 1];
    }

    public V setValueAt(int index2, V value) {
        if (!(0 <= index2 ? index2 < this.size : false)) {
            boolean $i$a$-require-SimpleArrayMap$setValueAt$22 = false;
            String $i$a$-require-SimpleArrayMap$setValueAt$22 = "Expected index to be within 0..size()-1, but was " + index2;
            throw new IllegalArgumentException($i$a$-require-SimpleArrayMap$setValueAt$22.toString());
        }
        int indexInArray = (index2 << 1) + 1;
        Object old = this.array[indexInArray];
        this.array[indexInArray] = value;
        return (V)old;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    @Nullable
    public V put(K key, V value) {
        int index2;
        int n;
        int osize = this.size;
        K k = key;
        int hash = k != null ? k.hashCode() : 0;
        K k2 = key;
        if (k2 != null) {
            K it = k2;
            boolean bl = false;
            n = this.indexOf(it, hash);
        } else {
            n = index2 = this.indexOfNull();
        }
        if (index2 >= 0) {
            index2 = (index2 << 1) + 1;
            Object old = this.array[index2];
            this.array[index2] = value;
            return (V)old;
        }
        index2 ^= 0xFFFFFFFF;
        if (osize >= this.hashes.length) {
            int n2 = osize >= 8 ? osize + (osize >> 1) : (osize >= 4 ? 8 : 4);
            int[] nArray = Arrays.copyOf(this.hashes, n2);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(this, newSize)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.array, n2 << 1);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(this, newSize)");
            this.array = objectArray;
            if (osize != this.size) {
                throw new ConcurrentModificationException();
            }
        }
        if (index2 < osize) {
            ArraysKt.copyInto(this.hashes, this.hashes, index2 + 1, index2, osize);
            ArraysKt.copyInto(this.array, this.array, index2 + 1 << 1, index2 << 1, this.size << 1);
        }
        if (osize != this.size || index2 >= this.hashes.length) {
            throw new ConcurrentModificationException();
        }
        this.hashes[index2] = hash;
        this.array[index2 << 1] = key;
        this.array[(index2 << 1) + 1] = value;
        int n3 = this.size;
        this.size = n3 + 1;
        return null;
    }

    public void putAll(@NotNull SimpleArrayMap<? extends K, ? extends V> map2) {
        Intrinsics.checkNotNullParameter(map2, "map");
        int n = map2.size;
        this.ensureCapacity(this.size + n);
        if (this.size == 0) {
            if (n > 0) {
                ArraysKt.copyInto(map2.hashes, this.hashes, 0, 0, n);
                ArraysKt.copyInto(map2.array, this.array, 0, 0, n << 1);
                this.size = n;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.put(map2.keyAt(i), map2.valueAt(i));
            }
        }
    }

    @Nullable
    public V putIfAbsent(K key, V value) {
        V mapValue = this.get(key);
        if (mapValue == null) {
            mapValue = this.put(key, value);
        }
        return mapValue;
    }

    @Nullable
    public V remove(K key) {
        int index2 = this.indexOfKey(key);
        return index2 >= 0 ? (V)this.removeAt(index2) : null;
    }

    public boolean remove(K key, V value) {
        V mapValue;
        int index2 = this.indexOfKey(key);
        if (index2 >= 0 && Intrinsics.areEqual(value, mapValue = this.valueAt(index2))) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public V removeAt(int index2) {
        if (!(0 <= index2 ? index2 < this.size : false)) {
            boolean $i$a$-require-SimpleArrayMap$removeAt$22 = false;
            String $i$a$-require-SimpleArrayMap$removeAt$22 = "Expected index to be within 0..size()-1, but was " + index2;
            throw new IllegalArgumentException($i$a$-require-SimpleArrayMap$removeAt$22.toString());
        }
        Object old = this.array[(index2 << 1) + 1];
        int osize = this.size;
        if (osize <= 1) {
            this.clear();
        } else {
            int nsize = osize - 1;
            if (this.hashes.length > 8 && osize < this.hashes.length / 3) {
                int n = osize > 8 ? osize + (osize >> 1) : 8;
                int[] ohashes = this.hashes;
                Object[] oarray = this.array;
                int[] nArray = Arrays.copyOf(this.hashes, n);
                Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(this, newSize)");
                this.hashes = nArray;
                Object[] objectArray = Arrays.copyOf(this.array, n << 1);
                Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(this, newSize)");
                this.array = objectArray;
                if (osize != this.size) {
                    throw new ConcurrentModificationException();
                }
                if (index2 > 0) {
                    ArraysKt.copyInto(ohashes, this.hashes, 0, 0, index2);
                    ArraysKt.copyInto(oarray, this.array, 0, 0, index2 << 1);
                }
                if (index2 < nsize) {
                    ArraysKt.copyInto(ohashes, this.hashes, index2, index2 + 1, nsize + 1);
                    ArraysKt.copyInto(oarray, this.array, index2 << 1, index2 + 1 << 1, nsize + 1 << 1);
                }
            } else {
                if (index2 < nsize) {
                    ArraysKt.copyInto(this.hashes, this.hashes, index2, index2 + 1, nsize + 1);
                    ArraysKt.copyInto(this.array, this.array, index2 << 1, index2 + 1 << 1, nsize + 1 << 1);
                }
                this.array[nsize << 1] = null;
                this.array[(nsize << 1) + 1] = null;
            }
            if (osize != this.size) {
                throw new ConcurrentModificationException();
            }
            this.size = nsize;
        }
        return (V)old;
    }

    @Nullable
    public V replace(K key, V value) {
        int index2 = this.indexOfKey(key);
        return index2 >= 0 ? (V)this.setValueAt(index2, value) : null;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        V mapValue;
        int index2 = this.indexOfKey(key);
        if (index2 >= 0 && Intrinsics.areEqual(oldValue, mapValue = this.valueAt(index2))) {
            this.setValueAt(index2, newValue);
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        try {
            if (other instanceof SimpleArrayMap) {
                if (this.size() != ((SimpleArrayMap)other).size()) {
                    return false;
                }
                SimpleArrayMap otherSimpleArrayMap = (SimpleArrayMap)other;
                int n = this.size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    V theirs = otherSimpleArrayMap.get(key);
                    if (!(mine == null ? theirs != null || !otherSimpleArrayMap.containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
            if (other instanceof Map) {
                if (this.size() != ((Map)other).size()) {
                    return false;
                }
                int n = this.size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = ((Map)other).get(key);
                    if (!(mine == null ? theirs != null || !((Map)other).containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        int[] hashes = this.hashes;
        Object[] array = this.array;
        int result2 = 0;
        int i = 0;
        int v = 1;
        int s2 = this.size;
        while (i < s2) {
            Object value = array[v];
            Object object = value;
            result2 += hashes[i] ^ (object != null ? object.hashCode() : 0);
            ++i;
            v += 2;
        }
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        if (this.isEmpty()) {
            return "{}";
        }
        int n = this.size * 28;
        StringBuilder $this$toString_u24lambda_u245 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$toString_u24lambda_u245.append('{');
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            K key;
            if (i > 0) {
                $this$toString_u24lambda_u245.append(", ");
            }
            if ((key = this.keyAt(i)) != $this$toString_u24lambda_u245) {
                $this$toString_u24lambda_u245.append(key);
            } else {
                $this$toString_u24lambda_u245.append("(this Map)");
            }
            $this$toString_u24lambda_u245.append('=');
            V value = this.valueAt(i);
            if (value != $this$toString_u24lambda_u245) {
                $this$toString_u24lambda_u245.append(value);
                continue;
            }
            $this$toString_u24lambda_u245.append("(this Map)");
        }
        $this$toString_u24lambda_u245.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @JvmOverloads
    public SimpleArrayMap() {
        this(0, 1, null);
    }
}

