/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.BoundsAnimationKt;
import androidx.compose.animation.BoundsTransform;
import androidx.compose.animation.ExperimentalSharedTransitionApi;
import androidx.compose.animation.SharedTransitionScope;
import androidx.compose.animation.core.AnimationVector4D;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.animation.core.Transition;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\tJ,\u00106\u001a\u0002032\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\fRW\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR;\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001b2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0014\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R+\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010\u0014\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010'\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010/\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006\u0007"}, d2={"Landroidx/compose/animation/BoundsAnimation;", "", "transitionScope", "Landroidx/compose/animation/SharedTransitionScope;", "transition", "Landroidx/compose/animation/core/Transition;", "", "animation", "Landroidx/compose/animation/core/Transition$DeferredAnimation;", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/animation/core/AnimationVector4D;", "boundsTransform", "Landroidx/compose/animation/BoundsTransform;", "(Landroidx/compose/animation/SharedTransitionScope;Landroidx/compose/animation/core/Transition;Landroidx/compose/animation/core/Transition$DeferredAnimation;Landroidx/compose/animation/BoundsTransform;)V", "<set-?>", "getAnimation", "()Landroidx/compose/animation/core/Transition$DeferredAnimation;", "setAnimation", "(Landroidx/compose/animation/core/Transition$DeferredAnimation;)V", "animation$delegate", "Landroidx/compose/runtime/MutableState;", "animationSpec", "Landroidx/compose/animation/core/FiniteAnimationSpec;", "getAnimationSpec", "()Landroidx/compose/animation/core/FiniteAnimationSpec;", "setAnimationSpec", "(Landroidx/compose/animation/core/FiniteAnimationSpec;)V", "Landroidx/compose/runtime/State;", "animationState", "getAnimationState", "()Landroidx/compose/runtime/State;", "setAnimationState", "(Landroidx/compose/runtime/State;)V", "animationState$delegate", "getBoundsTransform", "()Landroidx/compose/animation/BoundsTransform;", "setBoundsTransform", "(Landroidx/compose/animation/BoundsTransform;)V", "boundsTransform$delegate", "isRunning", "()Z", "target", "getTarget", "getTransition", "()Landroidx/compose/animation/core/Transition;", "getTransitionScope", "()Landroidx/compose/animation/SharedTransitionScope;", "value", "getValue", "()Landroidx/compose/ui/geometry/Rect;", "animate", "", "currentBounds", "targetBounds", "updateAnimation"})
@ExperimentalSharedTransitionApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBoundsAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundsAnimation.kt\nandroidx/compose/animation/BoundsAnimation\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,102:1\n81#2:103\n107#2,2:104\n81#2:106\n107#2,2:107\n81#2:109\n107#2,2:110\n*S KotlinDebug\n*F\n+ 1 BoundsAnimation.kt\nandroidx/compose/animation/BoundsAnimation\n*L\n39#1:103\n39#1:104,2\n54#1:106\n54#1:107,2\n69#1:109\n69#1:110,2\n*E\n"})
public final class BoundsAnimation {
    @NotNull
    private final SharedTransitionScope transitionScope;
    @NotNull
    private final Transition<Boolean> transition;
    @NotNull
    private final MutableState animation$delegate;
    @NotNull
    private final MutableState boundsTransform$delegate;
    @NotNull
    private FiniteAnimationSpec<Rect> animationSpec;
    @NotNull
    private final MutableState animationState$delegate;
    public static final int $stable = 8;

    public BoundsAnimation(@NotNull SharedTransitionScope transitionScope, @NotNull Transition<Boolean> transition, @NotNull Transition.DeferredAnimation<Rect, AnimationVector4D> animation2, @NotNull BoundsTransform boundsTransform) {
        Intrinsics.checkNotNullParameter(transitionScope, "transitionScope");
        Intrinsics.checkNotNullParameter(transition, "transition");
        Intrinsics.checkNotNullParameter(animation2, "animation");
        Intrinsics.checkNotNullParameter(boundsTransform, "boundsTransform");
        this.transitionScope = transitionScope;
        this.transition = transition;
        this.animation$delegate = SnapshotStateKt.mutableStateOf$default(animation2, null, 2, null);
        this.boundsTransform$delegate = SnapshotStateKt.mutableStateOf$default(boundsTransform, null, 2, null);
        this.animationSpec = BoundsAnimationKt.access$getDefaultBoundsAnimation$p();
        this.animationState$delegate = SnapshotStateKt.mutableStateOf$default(null, null, 2, null);
    }

    @NotNull
    public final SharedTransitionScope getTransitionScope() {
        return this.transitionScope;
    }

    @NotNull
    public final Transition<Boolean> getTransition() {
        return this.transition;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Transition.DeferredAnimation<Rect, AnimationVector4D> getAnimation() {
        void $this$getValue$iv;
        State state2 = this.animation$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Transition.DeferredAnimation)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setAnimation(Transition.DeferredAnimation<Rect, AnimationVector4D> deferredAnimation) {
        void $this$setValue$iv;
        MutableState mutableState = this.animation$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(deferredAnimation);
    }

    public final void updateAnimation(@NotNull Transition.DeferredAnimation<Rect, AnimationVector4D> animation2, @NotNull BoundsTransform boundsTransform) {
        Intrinsics.checkNotNullParameter(animation2, "animation");
        Intrinsics.checkNotNullParameter(boundsTransform, "boundsTransform");
        if (!Intrinsics.areEqual(this.getAnimation(), animation2)) {
            this.setAnimation(animation2);
            this.setAnimationState(null);
            this.animationSpec = BoundsAnimationKt.access$getDefaultBoundsAnimation$p();
        }
        this.setBoundsTransform(boundsTransform);
    }

    /*
     * WARNING - void declaration
     */
    private final BoundsTransform getBoundsTransform() {
        void $this$getValue$iv;
        State state2 = this.boundsTransform$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (BoundsTransform)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setBoundsTransform(BoundsTransform boundsTransform) {
        void $this$setValue$iv;
        MutableState mutableState = this.boundsTransform$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(boundsTransform);
    }

    public final boolean isRunning() {
        Transition<Boolean> parent2 = this.transition;
        while (parent2.getParentTransition() != null) {
            Intrinsics.checkNotNull(parent2.getParentTransition());
        }
        return !Intrinsics.areEqual(parent2.getCurrentState(), parent2.getTargetState());
    }

    @NotNull
    public final FiniteAnimationSpec<Rect> getAnimationSpec() {
        return this.animationSpec;
    }

    public final void setAnimationSpec(@NotNull FiniteAnimationSpec<Rect> finiteAnimationSpec) {
        Intrinsics.checkNotNullParameter(finiteAnimationSpec, "<set-?>");
        this.animationSpec = finiteAnimationSpec;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final State<Rect> getAnimationState() {
        void $this$getValue$iv;
        State state2 = this.animationState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (State)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnimationState(@Nullable State<Rect> state2) {
        void $this$setValue$iv;
        MutableState mutableState = this.animationState$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(state2);
    }

    @Nullable
    public final Rect getValue() {
        Rect rect2;
        if (this.transitionScope.isTransitionActive()) {
            State<Rect> state2 = this.getAnimationState();
            rect2 = state2 != null ? state2.getValue() : null;
        } else {
            rect2 = null;
        }
        return rect2;
    }

    public final void animate(@NotNull Rect currentBounds, @NotNull Rect targetBounds) {
        Intrinsics.checkNotNullParameter(currentBounds, "currentBounds");
        Intrinsics.checkNotNullParameter(targetBounds, "targetBounds");
        if (this.transitionScope.isTransitionActive()) {
            if (this.getAnimationState() == null) {
                this.animationSpec = this.getBoundsTransform().transform(currentBounds, targetBounds);
            }
            this.setAnimationState(this.getAnimation().animate((Function1)new Function1<Transition.Segment<Boolean>, FiniteAnimationSpec<Rect>>(this){
                final /* synthetic */ BoundsAnimation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final FiniteAnimationSpec<Rect> invoke(@NotNull Transition.Segment<Boolean> $this$animate) {
                    Intrinsics.checkNotNullParameter($this$animate, "$this$animate");
                    return this.this$0.getAnimationSpec();
                }
            }, (Function1)new Function1<Boolean, Rect>(this, targetBounds, currentBounds){
                final /* synthetic */ BoundsAnimation this$0;
                final /* synthetic */ Rect $targetBounds;
                final /* synthetic */ Rect $currentBounds;
                {
                    this.this$0 = $receiver;
                    this.$targetBounds = $targetBounds;
                    this.$currentBounds = $currentBounds;
                    super(1);
                }

                @NotNull
                public final Rect invoke(boolean it) {
                    return it == this.this$0.getTransition().getTargetState() ? this.$targetBounds : this.$currentBounds;
                }
            }));
        }
    }

    public final boolean getTarget() {
        return this.transition.getTargetState();
    }
}

