/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.collection.MutableIntList;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.ArcMode;
import androidx.compose.animation.core.ArcSpline;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.IntListExtensionKt;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.core.VectorizedKeyframeSpecElementInfo;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B9\b\u0016\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bBC\b\u0000\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000e\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\b\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\u0006H\u0002J \u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,H\u0002J-\u0010-\u001a\u00028\u00002\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00103J-\u00104\u001a\u00028\u00002\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00103J%\u00105\u001a\u0002062\u0006\u00100\u001a\u00028\u00002\u0006\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00107R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0016\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u001c\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010$\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00068"}, d2={"Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "keyframes", "", "", "Lkotlin/Pair;", "Landroidx/compose/animation/core/Easing;", "durationMillis", "delayMillis", "(Ljava/util/Map;II)V", "timestamps", "Landroidx/collection/IntList;", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/animation/core/VectorizedKeyframeSpecElementInfo;", "defaultEasing", "initialArcMode", "Landroidx/compose/animation/core/ArcMode;", "(Landroidx/collection/IntList;Landroidx/collection/IntObjectMap;IILandroidx/compose/animation/core/Easing;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "arcSpline", "Landroidx/compose/animation/core/ArcSpline;", "getDelayMillis", "()I", "getDurationMillis", "I", "lastInitialValue", "Landroidx/compose/animation/core/AnimationVector;", "lastTargetValue", "modes", "", "posArray", "", "slopeArray", "times", "valueVector", "velocityVector", "findEntryForTimeMillis", "timeMillis", "getEasedTime", "", "getEasedTimeFromIndex", "index", "asFraction", "", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "init", "", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)V", "animation-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVectorizedAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 IntList.kt\nandroidx/collection/IntList\n*L\n1#1,1081:1\n215#2,2:1082\n215#2,2:1084\n70#3:1086\n*S KotlinDebug\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n*L\n256#1:1082,2\n273#1:1084,2\n506#1:1086\n*E\n"})
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final IntList timestamps;
    @NotNull
    private final IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    @NotNull
    private final Easing defaultEasing;
    private final int initialArcMode;
    private int[] modes;
    private float[] times;
    private V valueVector;
    private V velocityVector;
    private V lastInitialValue;
    private V lastTargetValue;
    private float[] posArray;
    private float[] slopeArray;
    private ArcSpline arcSpline;
    public static final int $stable = 8;

    private VectorizedKeyframesSpec(IntList timestamps, IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes, int durationMillis, int delayMillis2, Easing defaultEasing, int initialArcMode) {
        Intrinsics.checkNotNullParameter(timestamps, "timestamps");
        Intrinsics.checkNotNullParameter(keyframes, "keyframes");
        Intrinsics.checkNotNullParameter(defaultEasing, "defaultEasing");
        this.timestamps = timestamps;
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis2;
        this.defaultEasing = defaultEasing;
        this.initialArcMode = initialArcMode;
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    public VectorizedKeyframesSpec(@NotNull Map<Integer, ? extends Pair<? extends V, ? extends Easing>> keyframes, int durationMillis, int delayMillis2) {
        Map.Entry<Integer, Pair<V, Easing>> entry2;
        Map.Entry<Integer, Pair<Object, Easing>> element$iv;
        Intrinsics.checkNotNullParameter(keyframes, "keyframes");
        VectorizedKeyframesSpec<V> vectorizedKeyframesSpec = this;
        boolean bl = false;
        MutableIntList times = new MutableIntList(keyframes.size() + 2);
        Map<Integer, Pair<Pair<V, Easing>, Easing>> $this$forEach$iv = keyframes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Pair<Object, Easing>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry2 = element$iv = iterator2.next();
            boolean bl2 = false;
            int t2 = ((Number)entry2.getKey()).intValue();
            times.add(t2);
        }
        if (!keyframes.containsKey(0)) {
            times.add(0, 0);
        }
        if (!keyframes.containsKey(durationMillis)) {
            times.add(durationMillis);
        }
        if (times.isNotEmpty()) {
            times.sort();
        }
        IntList intList = times;
        boolean bl3 = false;
        MutableIntObjectMap timeToInfoMap = new MutableIntObjectMap(0, 1, null);
        $this$forEach$iv = keyframes;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry2 = element$iv = iterator2.next();
            boolean bl4 = false;
            int time = ((Number)entry2.getKey()).intValue();
            Pair<V, Easing> valueEasing = entry2.getValue();
            timeToInfoMap.set(time, new VectorizedKeyframeSpecElementInfo((AnimationVector)valueEasing.getFirst(), valueEasing.getSecond(), ArcMode.Companion.getArcLinear--9T-Mq4(), null));
        }
        MutableIntObjectMap mutableIntObjectMap = timeToInfoMap;
        vectorizedKeyframesSpec(intList, mutableIntObjectMap, durationMillis, delayMillis2, EasingKt.getLinearEasing(), ArcMode.Companion.getArcLinear--9T-Mq4(), null);
    }

    public /* synthetic */ VectorizedKeyframesSpec(Map map2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(map2, n, n2);
    }

    private final void init(V initialValue, V targetValue2, V initialVelocity) {
        block27: {
            int n;
            Object object;
            block26: {
                boolean requiresArcSpline;
                boolean bl = requiresArcSpline = this.arcSpline != null;
                if (this.valueVector == null) {
                    this.valueVector = AnimationVectorsKt.newInstance(initialValue);
                    this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
                    int n2 = 0;
                    int n3 = this.timestamps.getSize();
                    Object[] objectArray = new float[n3];
                    object = this;
                    while (n2 < n3) {
                        n = n2++;
                        objectArray[n] = (float)this.timestamps.get(n) / (float)1000L;
                    }
                    ((VectorizedKeyframesSpec)object).times = objectArray;
                    n3 = this.timestamps.getSize();
                    objectArray = new int[n3];
                    object = this;
                    for (n2 = 0; n2 < n3; ++n2) {
                        int mode;
                        n = n2;
                        VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(this.timestamps.get(n));
                        int n4 = mode = vectorizedKeyframeSpecElementInfo != null ? vectorizedKeyframeSpecElementInfo.getArcMode--9T-Mq4() : this.initialArcMode;
                        if (!ArcMode.equals-impl0(mode, ArcMode.Companion.getArcLinear--9T-Mq4())) {
                            requiresArcSpline = true;
                        }
                        objectArray[n] = mode;
                    }
                    ((VectorizedKeyframesSpec)object).modes = (int[])objectArray;
                }
                if (!requiresArcSpline) {
                    return;
                }
                if (this.arcSpline == null) break block26;
                V v = this.lastInitialValue;
                if (v == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("lastInitialValue");
                    v = null;
                }
                if (!Intrinsics.areEqual(v, initialValue)) break block26;
                V v2 = this.lastTargetValue;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("lastTargetValue");
                    v2 = null;
                }
                if (Intrinsics.areEqual(v2, targetValue2)) break block27;
            }
            this.lastInitialValue = initialValue;
            this.lastTargetValue = targetValue2;
            int dimensionCount = ((AnimationVector)initialValue).getSize$animation_core() % 2 + ((AnimationVector)initialValue).getSize$animation_core();
            this.posArray = new float[dimensionCount];
            this.slopeArray = new float[dimensionCount];
            n = this.timestamps.getSize();
            float[][] fArrayArray = new float[n][];
            for (int i = 0; i < n; ++i) {
                int n5;
                V v;
                float[] fArray;
                int n6;
                Object object2;
                int n7;
                float[] fArray2;
                int n8;
                int n9 = i;
                int timestamp = this.timestamps.get(n9);
                if (timestamp == 0) {
                    if (!this.keyframes.contains(timestamp)) {
                        n8 = 0;
                        fArray2 = new float[dimensionCount];
                        n7 = n9;
                        object = fArrayArray;
                        while (n8 < dimensionCount) {
                            int n10 = n8++;
                            fArray2[n10] = ((AnimationVector)initialValue).get$animation_core(n10);
                        }
                        object2 = object;
                        n6 = n7;
                        fArray = fArray2;
                    } else {
                        n8 = 0;
                        fArray2 = new float[dimensionCount];
                        VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(timestamp);
                        Intrinsics.checkNotNull(vectorizedKeyframeSpecElementInfo);
                        v = vectorizedKeyframeSpecElementInfo.getVectorValue();
                        object = fArrayArray;
                        while (n8 < dimensionCount) {
                            n5 = n8++;
                            fArray2[n5] = ((AnimationVector)v).get$animation_core(n5);
                        }
                        object2 = object;
                        n6 = n7;
                        fArray = fArray2;
                    }
                } else if (timestamp == this.getDurationMillis()) {
                    if (!this.keyframes.contains(timestamp)) {
                        n8 = 0;
                        fArray2 = new float[dimensionCount];
                        object = fArrayArray;
                        while (n8 < dimensionCount) {
                            int n11 = n8++;
                            fArray2[n11] = ((AnimationVector)targetValue2).get$animation_core(n11);
                        }
                        object2 = object;
                        n6 = n7;
                        fArray = fArray2;
                    } else {
                        n8 = 0;
                        fArray2 = new float[dimensionCount];
                        VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(timestamp);
                        Intrinsics.checkNotNull(vectorizedKeyframeSpecElementInfo);
                        v = vectorizedKeyframeSpecElementInfo.getVectorValue();
                        object = fArrayArray;
                        while (n8 < dimensionCount) {
                            n5 = n8++;
                            fArray2[n5] = ((AnimationVector)v).get$animation_core(n5);
                        }
                        object2 = object;
                        n6 = n7;
                        fArray = fArray2;
                    }
                } else {
                    n8 = 0;
                    fArray2 = new float[dimensionCount];
                    VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(timestamp);
                    Intrinsics.checkNotNull(vectorizedKeyframeSpecElementInfo);
                    v = vectorizedKeyframeSpecElementInfo.getVectorValue();
                    object = fArrayArray;
                    while (n8 < dimensionCount) {
                        n5 = n8++;
                        fArray2[n5] = ((AnimationVector)v).get$animation_core(n5);
                    }
                    object2 = object;
                    n6 = n7;
                    fArray = fArray2;
                }
                object2[n6] = fArray;
            }
            float[][] values2 = fArrayArray;
            int[] nArray = this.modes;
            if (this.modes == null) {
                Intrinsics.throwUninitializedPropertyAccessException("modes");
                nArray = null;
            }
            float[] fArray = this.times;
            if (this.times == null) {
                Intrinsics.throwUninitializedPropertyAccessException("times");
                fArray = null;
            }
            this.arcSpline = new ArcSpline(nArray, fArray, values2);
        }
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        V v;
        V v2;
        Intrinsics.checkNotNullParameter(initialValue, "initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, "targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, "initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (this.keyframes.contains(clampedPlayTime)) {
            VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(clampedPlayTime);
            Intrinsics.checkNotNull(vectorizedKeyframeSpecElementInfo);
            return vectorizedKeyframeSpecElementInfo.getVectorValue();
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue2;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        this.init(initialValue, targetValue2, initialVelocity);
        if (this.arcSpline != null) {
            float easedTime = this.getEasedTime(clampedPlayTime);
            ArcSpline arcSpline = this.arcSpline;
            if (arcSpline == null) {
                Intrinsics.throwUninitializedPropertyAccessException("arcSpline");
                arcSpline = null;
            }
            float[] fArray = this.posArray;
            if (this.posArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException("posArray");
                fArray = null;
            }
            arcSpline.getPos(easedTime, fArray);
            int i = 0;
            float[] fArray2 = this.posArray;
            if (this.posArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException("posArray");
                fArray2 = null;
            }
            int n = fArray2.length;
            while (i < n) {
                V v3 = this.valueVector;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("valueVector");
                    v3 = null;
                }
                float[] fArray3 = this.posArray;
                if (this.posArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("posArray");
                    fArray3 = null;
                }
                ((AnimationVector)v3).set$animation_core(i, fArray3[i]);
                ++i;
            }
            V v4 = this.valueVector;
            if (v4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("valueVector");
                v4 = null;
            }
            return v4;
        }
        int index2 = this.findEntryForTimeMillis(clampedPlayTime);
        float easedTime = this.getEasedTimeFromIndex(index2, clampedPlayTime, true);
        int timestampStart = this.timestamps.get(index2);
        if (this.keyframes.contains(timestampStart)) {
            VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(timestampStart);
            Intrinsics.checkNotNull(vectorizedKeyframeSpecElementInfo);
            v2 = vectorizedKeyframeSpecElementInfo.getVectorValue();
        } else {
            v2 = initialValue;
        }
        V startValue = v2;
        int timestampEnd = this.timestamps.get(index2 + 1);
        if (this.keyframes.contains(timestampEnd)) {
            VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(timestampEnd);
            Intrinsics.checkNotNull(vectorizedKeyframeSpecElementInfo);
            v = vectorizedKeyframeSpecElementInfo.getVectorValue();
        } else {
            v = targetValue2;
        }
        V endValue = v;
        int i = 0;
        V v5 = this.valueVector;
        if (v5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("valueVector");
            v5 = null;
        }
        int n = ((AnimationVector)v5).getSize$animation_core();
        while (i < n) {
            V v6 = this.valueVector;
            if (v6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("valueVector");
                v6 = null;
            }
            ((AnimationVector)v6).set$animation_core(i, VectorConvertersKt.lerp(((AnimationVector)startValue).get$animation_core(i), ((AnimationVector)endValue).get$animation_core(i), easedTime));
            ++i;
        }
        V v7 = this.valueVector;
        if (v7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("valueVector");
            v7 = null;
        }
        return v7;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, "initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, "targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, "initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime < 0L) {
            return initialVelocity;
        }
        this.init(initialValue, targetValue2, initialVelocity);
        if (this.arcSpline != null) {
            float easedTime = this.getEasedTime((int)clampedPlayTime);
            ArcSpline arcSpline = this.arcSpline;
            if (arcSpline == null) {
                Intrinsics.throwUninitializedPropertyAccessException("arcSpline");
                arcSpline = null;
            }
            float[] fArray = this.slopeArray;
            if (this.slopeArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException("slopeArray");
                fArray = null;
            }
            arcSpline.getSlope(easedTime, fArray);
            int i = 0;
            float[] fArray2 = this.slopeArray;
            if (this.slopeArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException("slopeArray");
                fArray2 = null;
            }
            int n = fArray2.length;
            while (i < n) {
                V v = this.velocityVector;
                if (v == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("velocityVector");
                    v = null;
                }
                float[] fArray3 = this.slopeArray;
                if (this.slopeArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("slopeArray");
                    fArray3 = null;
                }
                ((AnimationVector)v).set$animation_core(i, fArray3[i]);
                ++i;
            }
            V v = this.velocityVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException("velocityVector");
                v = null;
            }
            return v;
        }
        V startNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime - 1L, initialValue, targetValue2, initialVelocity);
        V endNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime, initialValue, targetValue2, initialVelocity);
        int n = ((AnimationVector)startNum).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            V v = this.velocityVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException("velocityVector");
                v = null;
            }
            ((AnimationVector)v).set$animation_core(i, (((AnimationVector)startNum).get$animation_core(i) - ((AnimationVector)endNum).get$animation_core(i)) * 1000.0f);
        }
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException("velocityVector");
            v = null;
        }
        return v;
    }

    private final float getEasedTime(int timeMillis) {
        int index2 = this.findEntryForTimeMillis(timeMillis);
        return this.getEasedTimeFromIndex(index2, timeMillis, false);
    }

    private final float getEasedTimeFromIndex(int index2, int timeMillis, boolean asFraction) {
        IntList this_$iv = this.timestamps;
        boolean $i$f$getLastIndex = false;
        if (index2 >= this_$iv._size - 1) {
            return (float)timeMillis / (float)1000L;
        }
        int timeMin = this.timestamps.get(index2);
        int timeMax = this.timestamps.get(index2 + 1);
        if (timeMillis == timeMin) {
            return (float)timeMin / (float)1000L;
        }
        int timeRange = timeMax - timeMin;
        VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(timeMin);
        if (vectorizedKeyframeSpecElementInfo == null || (vectorizedKeyframeSpecElementInfo = vectorizedKeyframeSpecElementInfo.getEasing()) == null) {
            vectorizedKeyframeSpecElementInfo = this.defaultEasing;
        }
        VectorizedKeyframeSpecElementInfo<V> easing = vectorizedKeyframeSpecElementInfo;
        float rawFraction = (float)(timeMillis - timeMin) / (float)timeRange;
        float easedFraction = easing.transform(rawFraction);
        if (asFraction) {
            return easedFraction;
        }
        return ((float)timeRange * easedFraction + (float)timeMin) / (float)1000L;
    }

    private final int findEntryForTimeMillis(int timeMillis) {
        int index2 = IntListExtensionKt.binarySearch$default(this.timestamps, timeMillis, 0, 0, 6, null);
        return index2 < -1 ? -(index2 + 2) : index2;
    }

    public /* synthetic */ VectorizedKeyframesSpec(IntList timestamps, IntObjectMap keyframes, int durationMillis, int delayMillis2, Easing defaultEasing, int initialArcMode, DefaultConstructorMarker $constructor_marker) {
        this(timestamps, keyframes, durationMillis, delayMillis2, defaultEasing, initialArcMode);
    }
}

