/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.ExperimentalAnimationSpecApi;
import androidx.compose.animation.core.IntListExtensionKt;
import androidx.compose.animation.core.MonoSpline;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u000bH\u0002J-\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J-\u0010+\u001a\u00028\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J%\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010.R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0012\u0010\u0015\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006/"}, d2={"Landroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "timestamps", "Landroidx/collection/IntList;", "keyframes", "Landroidx/collection/IntObjectMap;", "Lkotlin/Pair;", "Landroidx/compose/animation/core/Easing;", "durationMillis", "", "delayMillis", "periodicBias", "", "(Landroidx/collection/IntList;Landroidx/collection/IntObjectMap;IIF)V", "getDelayMillis", "()I", "getDurationMillis", "lastInitialValue", "Landroidx/compose/animation/core/AnimationVector;", "lastTargetValue", "monoSpline", "Landroidx/compose/animation/core/MonoSpline;", "times", "", "valueVector", "values", "", "[[F", "velocityVector", "findEntryForTimeMillis", "timeMillis", "getEasedTimeFromIndex", "index", "getEasing", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "init", "", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)V", "animation-core"})
@ExperimentalAnimationSpecApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVectorizedMonoSplineKeyframesSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedMonoSplineKeyframesSpec.kt\nandroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec\n+ 2 IntList.kt\nandroidx/collection/IntList\n*L\n1#1,203:1\n70#2:204\n*S KotlinDebug\n*F\n+ 1 VectorizedMonoSplineKeyframesSpec.kt\nandroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec\n*L\n174#1:204\n*E\n"})
public final class VectorizedMonoSplineKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final IntList timestamps;
    @NotNull
    private final IntObjectMap<Pair<V, Easing>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    private final float periodicBias;
    private V valueVector;
    private V velocityVector;
    private float[] times;
    private MonoSpline monoSpline;
    private float[][] values;
    @Nullable
    private V lastInitialValue;
    @Nullable
    private V lastTargetValue;
    public static final int $stable = 8;

    public VectorizedMonoSplineKeyframesSpec(@NotNull IntList timestamps, @NotNull IntObjectMap<Pair<V, Easing>> keyframes, int durationMillis, int delayMillis2, float periodicBias) {
        Intrinsics.checkNotNullParameter(timestamps, "timestamps");
        Intrinsics.checkNotNullParameter(keyframes, "keyframes");
        this.timestamps = timestamps;
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis2;
        this.periodicBias = periodicBias;
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    private final void init(V initialValue, V targetValue2, V initialVelocity) {
        int n;
        Object object;
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
            this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
            int n2 = 0;
            int n3 = this.timestamps.getSize();
            float[] fArray = new float[n3];
            object = this;
            while (n2 < n3) {
                n = n2++;
                fArray[n] = (float)this.timestamps.get(n) / (float)1000L;
            }
            ((VectorizedMonoSplineKeyframesSpec)object).times = fArray;
        }
        if (this.monoSpline == null || !Intrinsics.areEqual(this.lastInitialValue, initialValue) || !Intrinsics.areEqual(this.lastTargetValue, targetValue2)) {
            boolean initialChanged = !Intrinsics.areEqual(this.lastInitialValue, initialValue);
            boolean targetChanged = !Intrinsics.areEqual(this.lastTargetValue, targetValue2);
            this.lastInitialValue = initialValue;
            this.lastTargetValue = targetValue2;
            int dimension = ((AnimationVector)initialValue).getSize$animation_core();
            if (this.values == null) {
                int n4 = this.timestamps.getSize();
                float[][] fArrayArray = new float[n4][];
                object = this;
                for (n = 0; n < n4; ++n) {
                    int n5;
                    AnimationVector animationVector;
                    float[] fArray;
                    int n6;
                    float[][] fArrayArray2;
                    float[][] fArrayArray3;
                    int n7;
                    float[] fArray2;
                    int n8;
                    int n9 = n;
                    int timestamp = this.timestamps.get(n9);
                    if (timestamp == 0) {
                        if (!this.keyframes.contains(timestamp)) {
                            n8 = 0;
                            fArray2 = new float[dimension];
                            n7 = n9;
                            fArrayArray3 = fArrayArray;
                            while (n8 < dimension) {
                                int n10 = n8++;
                                fArray2[n10] = ((AnimationVector)initialValue).get$animation_core(n10);
                            }
                            fArrayArray2 = fArrayArray3;
                            n6 = n7;
                            fArray = fArray2;
                        } else {
                            n8 = 0;
                            fArray2 = new float[dimension];
                            Pair<V, Easing> pair = this.keyframes.get(timestamp);
                            Intrinsics.checkNotNull(pair);
                            animationVector = (AnimationVector)pair.getFirst();
                            while (n8 < dimension) {
                                n5 = n8++;
                                fArray2[n5] = animationVector.get$animation_core(n5);
                            }
                            fArrayArray2 = fArrayArray3;
                            n6 = n7;
                            fArray = fArray2;
                        }
                    } else if (timestamp == this.getDurationMillis()) {
                        if (!this.keyframes.contains(timestamp)) {
                            n8 = 0;
                            fArray2 = new float[dimension];
                            while (n8 < dimension) {
                                int n11 = n8++;
                                fArray2[n11] = ((AnimationVector)targetValue2).get$animation_core(n11);
                            }
                            fArrayArray2 = fArrayArray3;
                            n6 = n7;
                            fArray = fArray2;
                        } else {
                            n8 = 0;
                            fArray2 = new float[dimension];
                            Pair<V, Easing> pair = this.keyframes.get(timestamp);
                            Intrinsics.checkNotNull(pair);
                            animationVector = (AnimationVector)pair.getFirst();
                            while (n8 < dimension) {
                                n5 = n8++;
                                fArray2[n5] = animationVector.get$animation_core(n5);
                            }
                            fArrayArray2 = fArrayArray3;
                            n6 = n7;
                            fArray = fArray2;
                        }
                    } else {
                        n8 = 0;
                        fArray2 = new float[dimension];
                        Pair<V, Easing> pair = this.keyframes.get(timestamp);
                        Intrinsics.checkNotNull(pair);
                        animationVector = (AnimationVector)pair.getFirst();
                        while (n8 < dimension) {
                            n5 = n8++;
                            fArray2[n5] = animationVector.get$animation_core(n5);
                        }
                        fArrayArray2 = fArrayArray3;
                        n6 = n7;
                        fArray = fArray2;
                    }
                    fArrayArray2[n6] = fArray;
                }
                ((VectorizedMonoSplineKeyframesSpec)object).values = fArrayArray;
            } else {
                int n12;
                int n13;
                float[] fArray;
                if (initialChanged && !this.keyframes.contains(0)) {
                    float[][] fArray3 = this.values;
                    if (this.values == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("values");
                        fArray3 = null;
                    }
                    n = 0;
                    fArray = new float[dimension];
                    n13 = IntListExtensionKt.binarySearch$default(this.timestamps, 0, 0, 0, 6, null);
                    object = fArray3;
                    while (n < dimension) {
                        n12 = n++;
                        fArray[n12] = ((AnimationVector)initialValue).get$animation_core(n12);
                    }
                    object[n13] = fArray;
                }
                if (targetChanged && !this.keyframes.contains(this.getDurationMillis())) {
                    float[][] fArray4 = this.values;
                    if (this.values == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("values");
                        fArray4 = null;
                    }
                    n = 0;
                    fArray = new float[dimension];
                    n13 = IntListExtensionKt.binarySearch$default(this.timestamps, this.getDurationMillis(), 0, 0, 6, null);
                    object = fArray4;
                    while (n < dimension) {
                        n12 = n++;
                        fArray[n12] = ((AnimationVector)targetValue2).get$animation_core(n12);
                    }
                    object[n13] = fArray;
                }
            }
            float[] fArray = this.times;
            if (this.times == null) {
                Intrinsics.throwUninitializedPropertyAccessException("times");
                fArray = null;
            }
            float[][] fArray5 = this.values;
            if (this.values == null) {
                Intrinsics.throwUninitializedPropertyAccessException("values");
                fArray5 = null;
            }
            this.monoSpline = new MonoSpline(fArray, fArray5, this.periodicBias);
        }
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, "initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, "targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, "initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (this.keyframes.containsKey(clampedPlayTime)) {
            Pair<V, Easing> pair = this.keyframes.get(clampedPlayTime);
            Intrinsics.checkNotNull(pair);
            return (V)((AnimationVector)pair.getFirst());
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue2;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        this.init(initialValue, targetValue2, initialVelocity);
        int index2 = this.findEntryForTimeMillis(clampedPlayTime);
        MonoSpline monoSpline = this.monoSpline;
        if (monoSpline == null) {
            Intrinsics.throwUninitializedPropertyAccessException("monoSpline");
            monoSpline = null;
        }
        MonoSpline monoSpline2 = monoSpline;
        float f = this.getEasedTimeFromIndex(index2, clampedPlayTime);
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException("valueVector");
            v = null;
        }
        V v2 = v;
        monoSpline2.getPos(f, (AnimationVector)v2, index2);
        V v3 = this.valueVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("valueVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, "initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, "targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, "initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime < 0) {
            return initialVelocity;
        }
        this.init(initialValue, targetValue2, initialVelocity);
        int index2 = this.findEntryForTimeMillis(clampedPlayTime);
        MonoSpline monoSpline = this.monoSpline;
        if (monoSpline == null) {
            Intrinsics.throwUninitializedPropertyAccessException("monoSpline");
            monoSpline = null;
        }
        MonoSpline monoSpline2 = monoSpline;
        float f = this.getEasedTimeFromIndex(index2, clampedPlayTime);
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException("velocityVector");
            v = null;
        }
        V v2 = v;
        monoSpline2.getSlope(f, (AnimationVector)v2, index2);
        V v3 = this.velocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("velocityVector");
            v3 = null;
        }
        return v3;
    }

    private final Easing getEasing(int index2) {
        int timestamp = this.timestamps.get(index2);
        Pair<V, Easing> pair = this.keyframes.get(timestamp);
        if (pair == null || (pair = pair.getSecond()) == null) {
            pair = EasingKt.getLinearEasing();
        }
        return pair;
    }

    private final float getEasedTimeFromIndex(int index2, int timeMillis) {
        IntList this_$iv = this.timestamps;
        boolean $i$f$getLastIndex = false;
        if (index2 >= this_$iv._size - 1) {
            return (float)timeMillis / (float)1000L;
        }
        int timeMin = this.timestamps.get(index2);
        int timeMax = this.timestamps.get(index2 + 1);
        if (timeMillis == timeMin) {
            return (float)timeMin / (float)1000L;
        }
        int timeRange = timeMax - timeMin;
        Easing easing = this.getEasing(index2);
        float rawFraction = (float)(timeMillis - timeMin) / (float)timeRange;
        float easedFraction = easing.transform(rawFraction);
        return ((float)timeRange * easedFraction + (float)timeMin) / (float)1000L;
    }

    private final int findEntryForTimeMillis(int timeMillis) {
        int index2 = IntListExtensionKt.binarySearch$default(this.timestamps, timeMillis, 0, 0, 6, null);
        return index2 < -1 ? -(index2 + 2) : index2;
    }
}

