/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\u000e*\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0014\u0010\u0018\u001a\u00020\u000e*\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\t\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Landroidx/compose/foundation/gestures/TouchSlopDetector;", "", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "(Landroidx/compose/foundation/gestures/Orientation;)V", "getOrientation", "()Landroidx/compose/foundation/gestures/Orientation;", "totalPositionChange", "Landroidx/compose/ui/geometry/Offset;", "J", "addPointerInputChange", "dragEvent", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "touchSlop", "", "addPointerInputChange-GcwITfU", "calculatePostSlopOffset", "calculatePostSlopOffset-tuRUvjQ", "(F)J", "reset", "", "crossAxis", "crossAxis-k-4lQ0M", "(J)F", "mainAxis", "mainAxis-k-4lQ0M", "foundation"})
@StabilityInferred(parameters=0)
public final class TouchSlopDetector {
    @Nullable
    private final Orientation orientation;
    private long totalPositionChange;
    public static final int $stable = 8;

    public TouchSlopDetector(@Nullable Orientation orientation) {
        this.orientation = orientation;
        this.totalPositionChange = Offset.Companion.getZero-F1C5BW0();
    }

    public /* synthetic */ TouchSlopDetector(Orientation orientation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            orientation = null;
        }
        this(orientation);
    }

    @Nullable
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final float mainAxis-k-4lQ0M(long $this$mainAxis_u2dk_u2d4lQ0M) {
        return this.orientation == Orientation.Horizontal ? Offset.getX-impl($this$mainAxis_u2dk_u2d4lQ0M) : Offset.getY-impl($this$mainAxis_u2dk_u2d4lQ0M);
    }

    public final float crossAxis-k-4lQ0M(long $this$crossAxis_u2dk_u2d4lQ0M) {
        return this.orientation == Orientation.Horizontal ? Offset.getY-impl($this$crossAxis_u2dk_u2d4lQ0M) : Offset.getX-impl($this$crossAxis_u2dk_u2d4lQ0M);
    }

    @Nullable
    public final Offset addPointerInputChange-GcwITfU(@NotNull PointerInputChange dragEvent, float touchSlop) {
        Intrinsics.checkNotNullParameter(dragEvent, "dragEvent");
        long currentPosition = dragEvent.getPosition-F1C5BW0();
        long previousPosition = dragEvent.getPreviousPosition-F1C5BW0();
        long positionChange = Offset.minus-MK-Hz9U(currentPosition, previousPosition);
        this.totalPositionChange = Offset.plus-MK-Hz9U(this.totalPositionChange, positionChange);
        float inDirection = this.orientation == null ? Offset.getDistance-impl(this.totalPositionChange) : Math.abs(this.mainAxis-k-4lQ0M(this.totalPositionChange));
        boolean hasCrossedSlop = inDirection >= touchSlop;
        return hasCrossedSlop ? Offset.box-impl(this.calculatePostSlopOffset-tuRUvjQ(touchSlop)) : null;
    }

    public final void reset() {
        this.totalPositionChange = Offset.Companion.getZero-F1C5BW0();
    }

    private final long calculatePostSlopOffset-tuRUvjQ(float touchSlop) {
        long l;
        if (this.orientation == null) {
            long touchSlopOffset = Offset.times-tuRUvjQ(Offset.div-tuRUvjQ(this.totalPositionChange, Offset.getDistance-impl(this.totalPositionChange)), touchSlop);
            l = Offset.minus-MK-Hz9U(this.totalPositionChange, touchSlopOffset);
        } else {
            float finalMainAxisChange = this.mainAxis-k-4lQ0M(this.totalPositionChange) - Math.signum(this.mainAxis-k-4lQ0M(this.totalPositionChange)) * touchSlop;
            float finalCrossAxisChange = this.crossAxis-k-4lQ0M(this.totalPositionChange);
            l = this.orientation == Orientation.Horizontal ? OffsetKt.Offset(finalMainAxisChange, finalCrossAxisChange) : OffsetKt.Offset(finalCrossAxisChange, finalMainAxisChange);
        }
        return l;
    }

    public TouchSlopDetector() {
        this(null, 1, null);
    }
}

